/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.CommonBundle;
import com.intellij.jarRepository.RemoteRepositoriesConfiguration;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.RepositoryAttachDialog;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.jarRepository.services.MavenRepositoryServicesManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JComponent;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.transfer.RepositoryOfflineException;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.version.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.aether.ArtifactDependencyNode;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.idea.maven.aether.ProgressConsumer;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

public class JarRepositoryManager {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.maven.utils.library.RepositoryAttachHandler");
    private static final String MAVEN_REPOSITORY_MACRO = "$MAVEN_REPOSITORY$";
    private static final String DEFAULT_REPOSITORY_PATH = ".m2/repository";
    private static final AtomicInteger ourTasksInProgress = new AtomicInteger();
    private static final Map<String, OrderRootType> ourClassifierToRootType = new HashMap<String, OrderRootType>();
    private static volatile File ourLocalRepositoryPath;

    public static boolean hasRunningTasks() {
        return ourTasksInProgress.get() > 0;
    }

    @Nullable
    public static NewLibraryConfiguration chooseLibraryAndDownload(@NotNull Project project2, @Nullable String initialFilter, JComponent parentComponent) {
        NewLibraryConfiguration config;
        RepositoryAttachDialog dialog = new RepositoryAttachDialog(project2, initialFilter, RepositoryAttachDialog.Mode.DOWNLOAD);
        if (!dialog.showAndGet()) {
            return null;
        }
        String coord = dialog.getCoordinateText();
        boolean attachSources = dialog.getAttachSources();
        boolean attachJavaDoc = dialog.getAttachJavaDoc();
        boolean attachAnnotations = dialog.getAttachExternalAnnotations();
        boolean includeTransitiveDependencies = dialog.getIncludeTransitiveDependencies();
        String copyTo = dialog.getDirectoryPath();
        EnumSet<ArtifactKind> artifactKinds = JarRepositoryManager.kindsOf(attachSources, attachJavaDoc, dialog.getPackaging());
        if (attachAnnotations) {
            artifactKinds.add(ArtifactKind.ANNOTATIONS);
        }
        if ((config = JarRepositoryManager.resolveAndDownload(project2, coord, artifactKinds, includeTransitiveDependencies, copyTo, RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories())) == null) {
            Messages.showErrorDialog((Component)parentComponent, (String)("No files were downloaded for " + coord), (String)CommonBundle.getErrorTitle());
        }
        return config;
    }

    private static NewLibraryConfiguration resolveAndDownload(Project project2, String coord, EnumSet<ArtifactKind> kinds, boolean includeTransitiveDependencies, String copyTo, Collection<RemoteRepositoryDescription> repositories) {
        String packaging = "jar";
        for (ArtifactKind kind : kinds) {
            if (!kind.getClassifier().isEmpty()) continue;
            packaging = kind.getExtension();
            break;
        }
        RepositoryLibraryProperties props = new RepositoryLibraryProperties(coord, packaging, includeTransitiveDependencies);
        JpsMavenRepositoryLibraryDescriptor libDescriptor = props.getRepositoryLibraryDescriptor();
        ArrayList roots = ContainerUtil.newArrayList();
        if (libDescriptor.getMavenId() != null) {
            roots.addAll(JarRepositoryManager.loadDependenciesModal(project2, libDescriptor, kinds, repositories, copyTo));
        }
        if (!roots.isEmpty()) {
            JarRepositoryManager.notifyArtifactsDownloaded(project2, roots);
            return JarRepositoryManager.createNewLibraryConfiguration(props, roots);
        }
        return null;
    }

    @Nullable
    public static NewLibraryConfiguration resolveAndDownload(@NotNull Project project2, String coord, boolean attachSources, boolean attachJavaDoc, boolean includeTransitiveDependencies, String copyTo, Collection<RemoteRepositoryDescription> repositories) {
        return JarRepositoryManager.resolveAndDownload(project2, coord, attachSources, attachJavaDoc, "jar", includeTransitiveDependencies, copyTo, repositories);
    }

    @Nullable
    public static NewLibraryConfiguration resolveAndDownload(@NotNull Project project2, String coord, boolean attachSources, boolean attachJavaDoc, String packaging, boolean includeTransitiveDependencies, String copyTo, Collection<RemoteRepositoryDescription> repositories) {
        return JarRepositoryManager.resolveAndDownload(project2, coord, JarRepositoryManager.kindsOf(attachSources, attachJavaDoc, packaging), includeTransitiveDependencies, copyTo, repositories);
    }

    @NotNull
    protected static NewLibraryConfiguration createNewLibraryConfiguration(RepositoryLibraryProperties props, final Collection<? extends OrderRoot> roots) {
        return new NewLibraryConfiguration(RepositoryLibraryDescription.findDescription((RepositoryLibraryProperties)props).getDisplayName(props.getVersion()), RepositoryLibraryType.getInstance(), (LibraryProperties)props){

            public void addRoots(@NotNull LibraryEditor editor) {
                editor.addRoots(roots);
            }
        };
    }

    @NotNull
    public static File getLocalRepositoryPath() {
        File repoPath = ourLocalRepositoryPath;
        if (repoPath != null) {
            return repoPath;
        }
        String expanded = PathMacroManager.getInstance((ComponentManager)ApplicationManager.getApplication()).expandPath(MAVEN_REPOSITORY_MACRO);
        if (!MAVEN_REPOSITORY_MACRO.equals(expanded) && (repoPath = new File(expanded)).exists()) {
            try {
                repoPath = repoPath.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ourLocalRepositoryPath = repoPath;
            return repoPath;
        }
        String userHome = System.getProperty("user.home", null);
        ourLocalRepositoryPath = repoPath = userHome != null ? new File(userHome, DEFAULT_REPOSITORY_PATH) : new File(DEFAULT_REPOSITORY_PATH);
        return repoPath;
    }

    static void setLocalRepositoryPath(File localRepo) {
        ourLocalRepositoryPath = localRepo;
    }

    public static Collection<OrderRoot> loadDependenciesModal(@NotNull Project project2, @NotNull RepositoryLibraryProperties libraryProps, boolean loadSources, boolean loadJavadoc, @Nullable String copyTo, @Nullable Collection<RemoteRepositoryDescription> repositories) {
        JpsMavenRepositoryLibraryDescriptor libDescriptor = libraryProps.getRepositoryLibraryDescriptor();
        if (libDescriptor.getMavenId() != null) {
            EnumSet<ArtifactKind> kinds = JarRepositoryManager.kindsOf(loadSources, loadJavadoc, libraryProps.getPackaging());
            return JarRepositoryManager.loadDependenciesModal(project2, libDescriptor, kinds, repositories, copyTo);
        }
        return Collections.emptyList();
    }

    public static Collection<OrderRoot> loadDependenciesModal(@NotNull Project project2, @NotNull JpsMavenRepositoryLibraryDescriptor desc, Set<ArtifactKind> artifactKinds, @Nullable Collection<RemoteRepositoryDescription> repositories, @Nullable String copyTo) {
        Collection<RemoteRepositoryDescription> effectiveRepos = JarRepositoryManager.addDefaultsIfEmpty(project2, repositories);
        return JarRepositoryManager.submitModalJob(project2, "Resolving Maven dependencies...", JarRepositoryManager.newOrderRootResolveJob(desc, artifactKinds, effectiveRepos, copyTo));
    }

    public static Promise<List<OrderRoot>> loadDependenciesAsync(@NotNull Project project2, RepositoryLibraryProperties libraryProps, boolean loadSources, boolean loadJavadoc, @Nullable List<RemoteRepositoryDescription> repos, @Nullable String copyTo) {
        EnumSet<ArtifactKind> kinds = JarRepositoryManager.kindsOf(loadSources, loadJavadoc, libraryProps.getPackaging());
        return JarRepositoryManager.loadDependenciesAsync(project2, libraryProps.getRepositoryLibraryDescriptor(), kinds, repos, copyTo);
    }

    public static Promise<List<OrderRoot>> loadDependenciesAsync(@NotNull Project project2, JpsMavenRepositoryLibraryDescriptor desc, Set<ArtifactKind> artifactKinds, @Nullable List<RemoteRepositoryDescription> repos, @Nullable String copyTo) {
        Collection<RemoteRepositoryDescription> effectiveRepos = JarRepositoryManager.addDefaultsIfEmpty(project2, repos);
        return JarRepositoryManager.submitBackgroundJob(JarRepositoryManager.newOrderRootResolveJob(desc, artifactKinds, effectiveRepos, copyTo));
    }

    @Nullable
    public static List<OrderRoot> loadDependenciesSync(@NotNull Project project2, JpsMavenRepositoryLibraryDescriptor desc, Set<ArtifactKind> artifactKinds, @Nullable List<RemoteRepositoryDescription> repos, @Nullable String copyTo) {
        Collection<RemoteRepositoryDescription> effectiveRepos = JarRepositoryManager.addDefaultsIfEmpty(project2, repos);
        return JarRepositoryManager.submitSyncJob(JarRepositoryManager.newOrderRootResolveJob(desc, artifactKinds, effectiveRepos, copyTo));
    }

    @NotNull
    protected static Collection<RemoteRepositoryDescription> addDefaultsIfEmpty(@NotNull Project project2, @Nullable Collection<RemoteRepositoryDescription> repositories) {
        if (repositories == null || repositories.isEmpty()) {
            repositories = RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories();
        }
        return repositories;
    }

    public static EnumSet<ArtifactKind> kindsOf(boolean loadSources, boolean loadJavadoc, String ... artifactPackaging) {
        EnumSet kinds = ArtifactKind.kindsOf((boolean)loadSources, (boolean)loadJavadoc);
        if (artifactPackaging.length == 0 || artifactPackaging.length == 1 && artifactPackaging[0] == null) {
            kinds.add(ArtifactKind.ARTIFACT);
        } else {
            for (String packaging : artifactPackaging) {
                ArtifactKind artifact = ArtifactKind.find((String)ArtifactKind.ARTIFACT.getClassifier(), (String)packaging);
                if (artifact == null) continue;
                kinds.add(artifact);
            }
        }
        return kinds;
    }

    @NotNull
    public static Promise<Collection<String>> getAvailableVersions(@NotNull Project project2, @NotNull RepositoryLibraryDescription libraryDescription) {
        List repos = RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories();
        return JarRepositoryManager.submitBackgroundJob(new VersionResolveJob(libraryDescription, repos));
    }

    @Nullable
    public static ArtifactDependencyNode loadDependenciesTree(final @NotNull RepositoryLibraryDescription description, final @NotNull String version, Project project2) {
        List repositories = RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories();
        return JarRepositoryManager.submitModalJob(project2, "Resolving Maven Dependencies", new AetherJob<ArtifactDependencyNode>((Collection)repositories){

            @Override
            protected String getProgressText() {
                return "Loading dependencies of " + description.getMavenCoordinates(version);
            }

            @Override
            protected ArtifactDependencyNode perform(ProgressIndicator progress, @NotNull ArtifactRepositoryManager manager) throws Exception {
                return manager.collectDependencies(description.getGroupId(), description.getArtifactId(), version);
            }

            @Override
            protected ArtifactDependencyNode getDefaultResult() {
                return null;
            }
        });
    }

    private static void notifyArtifactsDownloaded(Project project2, Collection<OrderRoot> roots) {
        StringBuilder sb = new StringBuilder();
        String title = "The following files were downloaded:";
        for (OrderRoot root : roots) {
            sb.append("<p/>");
            sb.append(root.getFile().getName());
        }
        Notifications.Bus.notify((Notification)new Notification("Repository", "The following files were downloaded:", sb.toString(), NotificationType.INFORMATION), (Project)project2);
    }

    public static void searchArtifacts(Project project2, String coord, Consumer<? super Collection<Pair<RepositoryArtifactDescription, RemoteRepositoryDescription>>> resultProcessor) {
        JarRepositoryManager.searchArtifacts(project2, coord, "jar", resultProcessor);
    }

    public static void searchArtifacts(final Project project2, String coord, String packaging, final Consumer<? super Collection<Pair<RepositoryArtifactDescription, RemoteRepositoryDescription>>> resultProcessor) {
        if (coord == null || coord.length() == 0) {
            return;
        }
        final RepositoryArtifactDescription template = coord.indexOf(58) == -1 && Character.isUpperCase(coord.charAt(0)) ? new RepositoryArtifactDescription(null, null, null, packaging, null, coord, null) : new RepositoryArtifactDescription(new RepositoryLibraryProperties(coord, packaging, true), null);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, "Maven", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                ArrayList<Pair> resultList = new ArrayList<Pair>();
                try {
                    for (String serviceUrl : MavenRepositoryServicesManager.getServiceUrls((Project)project2)) {
                        try {
                            List artifacts = MavenRepositoryServicesManager.findArtifacts((RepositoryArtifactDescription)template, (String)serviceUrl);
                            if (artifacts.isEmpty()) continue;
                            List repositories = MavenRepositoryServicesManager.getRepositories((String)serviceUrl);
                            THashMap map2 = new THashMap();
                            for (RemoteRepositoryDescription repository : repositories) {
                                map2.put(repository.getId(), repository);
                            }
                            for (RepositoryArtifactDescription artifact : artifacts) {
                                RemoteRepositoryDescription repository = (RemoteRepositoryDescription)map2.get(artifact.getRepositoryId());
                                if (repository == null) continue;
                                resultList.add(Pair.create((Object)artifact, (Object)repository));
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
                finally {
                    ApplicationManager.getApplication().invokeLater(() -> resultProcessor.accept(resultList));
                }
            }
        });
    }

    public static void searchRepositories(Project project2, final Collection<String> serviceUrls, final Processor<? super Collection<RemoteRepositoryDescription>> resultProcessor) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, "Maven", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Ref result = Ref.create(Collections.emptyList());
                try {
                    ArrayList repoList = new ArrayList();
                    for (String url : serviceUrls) {
                        List repositories;
                        try {
                            repositories = MavenRepositoryServicesManager.getRepositories((String)url);
                        }
                        catch (Exception ex) {
                            LOG.warn("Accessing Service at: " + url, (Throwable)ex);
                            continue;
                        }
                        repoList.addAll(repositories);
                    }
                    result.set(repoList);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    ApplicationManager.getApplication().invokeLater(() -> resultProcessor.process(result.get()));
                }
            }
        });
    }

    @Nullable
    private static <T> T submitSyncJob(@NotNull Function<? super ProgressIndicator, ? extends T> job) {
        try {
            ourTasksInProgress.incrementAndGet();
            EmptyProgressIndicator indicator = new EmptyProgressIndicator(ModalityState.defaultModalityState());
            Object object = ProgressManager.getInstance().runProcess(() -> JarRepositoryManager.lambda$submitSyncJob$0(job, (ProgressIndicator)indicator), (ProgressIndicator)indicator);
            return (T)object;
        }
        finally {
            ourTasksInProgress.decrementAndGet();
        }
    }

    @Nullable
    private static <T> T submitModalJob(@Nullable Project project2, String title, final Function<? super ProgressIndicator, ? extends T> job) {
        final Ref result = Ref.create(null);
        new Task.Modal(project2, title, true){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    ourTasksInProgress.incrementAndGet();
                    result.set(job.apply(indicator));
                }
                finally {
                    ourTasksInProgress.decrementAndGet();
                }
            }
        }.queue();
        return (T)result.get();
    }

    @NotNull
    private static <T> Promise<T> submitBackgroundJob(@NotNull Function<? super ProgressIndicator, ? extends T> job) {
        ModalityState startModality = ModalityState.defaultModalityState();
        AsyncPromise promise = new AsyncPromise();
        JobExecutor.INSTANCE.submit(() -> {
            try {
                ourTasksInProgress.incrementAndGet();
                EmptyProgressIndicator indicator = new EmptyProgressIndicator(startModality);
                Object result = ProgressManager.getInstance().runProcess(() -> JarRepositoryManager.lambda$null$1(job, (ProgressIndicator)indicator), (ProgressIndicator)indicator);
                promise.setResult(result);
            }
            catch (ProcessCanceledException ignored) {
                promise.cancel();
            }
            catch (Throwable e) {
                LOG.info(e);
                promise.setError(e);
            }
            finally {
                ourTasksInProgress.decrementAndGet();
            }
        });
        return promise;
    }

    @NotNull
    private static Collection<String> lookupVersionsImpl(String groupId, String artifactId, @NotNull ArtifactRepositoryManager manager) throws Exception {
        try {
            ArrayList versions = new ArrayList(manager.getAvailableVersions(groupId, artifactId, "[0,)", ArtifactKind.ARTIFACT));
            ArrayList<String> strings = new ArrayList<String>(versions.size());
            for (int i = versions.size() - 1; i >= 0; --i) {
                strings.add(((Version)versions.get(i)).toString());
            }
            return strings;
        }
        catch (TransferCancelledException e) {
            throw new ProcessCanceledException((Throwable)e);
        }
    }

    private static Function<ProgressIndicator, List<OrderRoot>> newOrderRootResolveJob(@NotNull JpsMavenRepositoryLibraryDescriptor desc, @NotNull Set<ArtifactKind> kinds, @NotNull Collection<RemoteRepositoryDescription> repositories, @Nullable String copyTo) {
        return new LibraryResolveJob(desc, kinds, repositories).andThen(resolved -> resolved.isEmpty() ? Collections.emptyList() : (List)WriteAction.computeAndWait(() -> JarRepositoryManager.createRoots(resolved, copyTo)));
    }

    private static List<OrderRoot> createRoots(@NotNull Collection<? extends Artifact> artifacts, @Nullable String copyTo) {
        ArrayList<OrderRoot> result = new ArrayList<OrderRoot>();
        VirtualFileManager manager = VirtualFileManager.getInstance();
        for (Artifact artifact : artifacts) {
            try {
                File repoFile;
                File toFile = repoFile = artifact.getFile();
                if (copyTo != null) {
                    toFile = new File(copyTo, repoFile.getName());
                    if (repoFile.exists()) {
                        FileUtil.copy((File)repoFile, (File)toFile);
                    }
                }
                manager.refreshAndFindFileByUrl(VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)toFile.getPath())));
                String url = VfsUtil.getUrlForLibraryRoot((File)toFile);
                VirtualFile file = manager.refreshAndFindFileByUrl(url);
                if (file == null) continue;
                OrderRootType rootType = ourClassifierToRootType.getOrDefault(artifact.getClassifier(), OrderRootType.CLASSES);
                result.add(new OrderRoot(file, rootType));
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
        return result;
    }

    private static /* synthetic */ Object lambda$null$1(Function job, ProgressIndicator indicator) {
        return job.apply(indicator);
    }

    private static /* synthetic */ Object lambda$submitSyncJob$0(Function job, ProgressIndicator indicator) {
        return job.apply(indicator);
    }

    static {
        ourClassifierToRootType.put(ArtifactKind.ARTIFACT.getClassifier(), OrderRootType.CLASSES);
        ourClassifierToRootType.put(ArtifactKind.JAVADOC.getClassifier(), JavadocOrderRootType.getInstance());
        ourClassifierToRootType.put(ArtifactKind.SOURCES.getClassifier(), OrderRootType.SOURCES);
        ourClassifierToRootType.put(ArtifactKind.ANNOTATIONS.getClassifier(), AnnotationOrderRootType.getInstance());
    }

    private static class VersionResolveJob
    extends AetherJob<Collection<String>> {
        @NotNull
        private final RepositoryLibraryDescription myDescription;

        VersionResolveJob(@NotNull RepositoryLibraryDescription repositoryLibraryDescription, @NotNull List<RemoteRepositoryDescription> repositories) {
            super(repositories);
            this.myDescription = repositoryLibraryDescription;
        }

        @Override
        protected String getProgressText() {
            return "Loading " + this.myDescription.getDisplayName() + " versions";
        }

        @Override
        protected Collection<String> perform(ProgressIndicator progress, @NotNull ArtifactRepositoryManager manager) throws Exception {
            return JarRepositoryManager.lookupVersionsImpl(this.myDescription.getGroupId(), this.myDescription.getArtifactId(), manager);
        }

        @Override
        protected Collection<String> getDefaultResult() {
            return Collections.emptyList();
        }
    }

    private static class LibraryResolveJob
    extends AetherJob<Collection<Artifact>> {
        @NotNull
        private final JpsMavenRepositoryLibraryDescriptor myDesc;
        @NotNull
        private final Set<ArtifactKind> myKinds;

        LibraryResolveJob(@NotNull JpsMavenRepositoryLibraryDescriptor desc, @NotNull Set<ArtifactKind> kinds, @NotNull Collection<RemoteRepositoryDescription> repositories) {
            super(repositories);
            this.myDesc = desc;
            this.myKinds = kinds;
        }

        @Override
        protected boolean canStart() {
            return super.canStart() && this.myDesc.getMavenId() != null;
        }

        @Override
        protected String getProgressText() {
            return "Loading " + RepositoryLibraryDescription.findDescription((JpsMavenRepositoryLibraryDescriptor)this.myDesc).getDisplayName();
        }

        @Override
        protected Collection<Artifact> getDefaultResult() {
            return Collections.emptyList();
        }

        @Override
        protected Collection<Artifact> perform(ProgressIndicator progress, @NotNull ArtifactRepositoryManager manager) throws Exception {
            String version = this.myDesc.getVersion();
            try {
                return manager.resolveDependencyAsArtifact(this.myDesc.getGroupId(), this.myDesc.getArtifactId(), version, this.myKinds, this.myDesc.isIncludeTransitiveDependencies(), this.myDesc.getExcludedDependencies());
            }
            catch (TransferCancelledException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (RepositoryOfflineException e) {
                throw e;
            }
            catch (Exception e) {
                String resolvedVersion = this.resolveVersion(manager, version);
                if (Comparing.equal((String)version, (String)resolvedVersion)) {
                    throw e;
                }
                try {
                    return manager.resolveDependencyAsArtifact(this.myDesc.getGroupId(), this.myDesc.getArtifactId(), resolvedVersion, this.myKinds, this.myDesc.isIncludeTransitiveDependencies(), this.myDesc.getExcludedDependencies());
                }
                catch (TransferCancelledException e1) {
                    throw new ProcessCanceledException((Throwable)e1);
                }
            }
        }

        @Nullable
        private String resolveVersion(ArtifactRepositoryManager manager, String version) throws Exception {
            boolean isLatest = "LATEST".equals(version);
            boolean isRelease = "RELEASE".equals(version);
            if (isLatest || isRelease) {
                try {
                    for (String ver : JarRepositoryManager.lookupVersionsImpl(this.myDesc.getGroupId(), this.myDesc.getArtifactId(), manager)) {
                        if (isRelease && ver.endsWith("-SNAPSHOT")) continue;
                        return ver;
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error("Got unexpected exception while resolving artifact versions", (Throwable)e);
                }
            }
            return version;
        }
    }

    private static abstract class AetherJob<T>
    implements Function<ProgressIndicator, T> {
        @NotNull
        private final Collection<? extends RemoteRepositoryDescription> myRepositories;

        AetherJob(@NotNull Collection<? extends RemoteRepositoryDescription> repositories) {
            this.myRepositories = repositories;
        }

        protected boolean canStart() {
            return !this.myRepositories.isEmpty();
        }

        @Override
        public final T apply(final ProgressIndicator indicator) {
            if (this.canStart()) {
                indicator.setText(this.getProgressText());
                indicator.setIndeterminate(true);
                ArrayList<RemoteRepository> remotes = new ArrayList<RemoteRepository>();
                for (RemoteRepositoryDescription remoteRepositoryDescription : this.myRepositories) {
                    remotes.add(ArtifactRepositoryManager.createRemoteRepository((String)remoteRepositoryDescription.getId(), (String)remoteRepositoryDescription.getUrl()));
                }
                try {
                    return this.perform(indicator, new ArtifactRepositoryManager(JarRepositoryManager.getLocalRepositoryPath(), remotes, new ProgressConsumer(){

                        public void consume(String message) {
                            indicator.setText(message);
                        }

                        public boolean isCanceled() {
                            return indicator.isCanceled();
                        }
                    }));
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                }
            }
            return this.getDefaultResult();
        }

        protected abstract String getProgressText();

        protected abstract T perform(ProgressIndicator var1, @NotNull ArtifactRepositoryManager var2) throws Exception;

        protected abstract T getDefaultResult();
    }

    private static class JobExecutor {
        static final ExecutorService INSTANCE = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"RemoteLibraryDownloader");

        private JobExecutor() {
        }
    }
}

