/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.jarRepository.settings.RepositoryLibraryPropertiesDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.IdeaModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibrarySupport;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;

public class RepositoryAddLibraryAction
extends IntentionAndQuickFixAction {
    private final Module module;
    @NotNull
    private final RepositoryLibraryDescription libraryDescription;

    public RepositoryAddLibraryAction(Module module2, @NotNull RepositoryLibraryDescription libraryDescription) {
        this.module = module2;
        this.libraryDescription = libraryDescription;
    }

    @NotNull
    public String getName() {
        return "Add " + this.libraryDescription.getDisplayName() + " library to module dependencies";
    }

    @NotNull
    public String getFamilyName() {
        return "Maven libraries";
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project2, PsiFile file, @Nullable Editor editor) {
        RepositoryAddLibraryAction.addLibraryToModule(this.libraryDescription, this.module);
    }

    public static Promise<Void> addLibraryToModule(RepositoryLibraryDescription libraryDescription, Module module2) {
        RepositoryLibraryPropertiesModel model = new RepositoryLibraryPropertiesModel("RELEASE", false, false);
        RepositoryLibraryPropertiesDialog dialog = new RepositoryLibraryPropertiesDialog(module2.getProject(), model, libraryDescription, false, true);
        if (!dialog.showAndGet()) {
            return Promises.rejectedPromise();
        }
        IdeaModifiableModelsProvider modifiableModelsProvider2 = new IdeaModifiableModelsProvider();
        ModifiableRootModel modifiableModel = modifiableModelsProvider2.getModuleModifiableModel(module2);
        RepositoryLibrarySupport librarySupport = new RepositoryLibrarySupport(module2.getProject(), libraryDescription, model);
        assert (modifiableModel != null);
        librarySupport.addSupport(module2, modifiableModel, modifiableModelsProvider2);
        ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableRootModel)modifiableModel).commit());
        return Promises.resolvedPromise(null);
    }
}

