/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryLibraryWithDescriptionEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public class RepositoryLibraryType
extends LibraryType<RepositoryLibraryProperties> {
    public static final PersistentLibraryKind<RepositoryLibraryProperties> REPOSITORY_LIBRARY_KIND = new PersistentLibraryKind<RepositoryLibraryProperties>("repository"){

        @NotNull
        public RepositoryLibraryProperties createDefaultProperties() {
            return new RepositoryLibraryProperties();
        }
    };

    protected RepositoryLibraryType() {
        super(REPOSITORY_LIBRARY_KIND);
    }

    public static RepositoryLibraryType getInstance() {
        return (RepositoryLibraryType)((Object)EP_NAME.findExtension(RepositoryLibraryType.class));
    }

    @Nullable
    public String getCreateActionName() {
        return "From Maven...";
    }

    public NewLibraryConfiguration createNewLibrary(@NotNull JComponent parentComponent, @Nullable VirtualFile contextDirectory, @NotNull Project project2) {
        return JarRepositoryManager.chooseLibraryAndDownload(project2, null, parentComponent);
    }

    public LibraryPropertiesEditor createPropertiesEditor(@NotNull LibraryEditorComponent<RepositoryLibraryProperties> component) {
        return new RepositoryLibraryWithDescriptionEditor(component);
    }

    @Nullable
    public Icon getIcon(@Nullable RepositoryLibraryProperties properties) {
        if (properties == null || properties.getGroupId() == null || properties.getArtifactId() == null) {
            return RepositoryLibraryDescription.DEFAULT_ICON;
        }
        return RepositoryLibraryDescription.findDescription((RepositoryLibraryProperties)properties).getIcon();
    }

    @NotNull
    public String getDescription(@NotNull RepositoryLibraryProperties properties) {
        RepositoryLibraryDescription description = RepositoryLibraryDescription.findDescription((RepositoryLibraryProperties)properties);
        return "Maven: " + description.getDisplayName(properties.getVersion());
    }
}

