/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.settings;

import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import org.eclipse.aether.artifact.Artifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactDependencyNode;

class DependencyExclusionEditor {
    private final CheckboxTree myDependenciesTree;
    private final CheckedTreeNode myRootNode;
    private final JPanel myMainPanel;

    DependencyExclusionEditor(ArtifactDependencyNode root, JPanel parentComponent) {
        this.myMainPanel = parentComponent;
        this.myRootNode = DependencyExclusionEditor.createDependencyTreeNode(root);
        CheckboxTreeBase.CheckPolicy policy = new CheckboxTreeBase.CheckPolicy(false, true, true, false);
        this.myDependenciesTree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(){
            {
                this.myIgnoreInheritance = true;
            }

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!(value instanceof CheckedTreeNode)) {
                    return;
                }
                Object userObject = ((CheckedTreeNode)value).getUserObject();
                if (!(userObject instanceof Artifact)) {
                    return;
                }
                Artifact artifact = (Artifact)userObject;
                this.getTextRenderer().append(artifact.getGroupId() + ":" + artifact.getArtifactId(), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
                this.getTextRenderer().append(":" + artifact.getVersion(), SimpleTextAttributes.GRAYED_ATTRIBUTES, true);
            }
        }, this.myRootNode, policy);
        this.myDependenciesTree.setRootVisible(false);
    }

    @Nullable
    public Set<String> selectExcludedDependencies(List<String> excludedDependencies) {
        DependencyExclusionEditor.uncheckExcludedNodes(this.myRootNode, new HashSet<String>(excludedDependencies), false);
        TreeUtil.expandAll((JTree)this.myDependenciesTree);
        DialogBuilder dialogBuilder = new DialogBuilder((Component)this.myMainPanel).title("Include Transitive Dependencies").centerPanel((JComponent)new JBScrollPane((Component)this.myDependenciesTree));
        dialogBuilder.setPreferredFocusComponent((JComponent)this.myDependenciesTree);
        if (dialogBuilder.showAndGet()) {
            return DependencyExclusionEditor.collectUncheckedNodes(this.myRootNode, new LinkedHashSet<String>());
        }
        return null;
    }

    private static void uncheckExcludedNodes(CheckedTreeNode node, Set<String> excluded, boolean parentIsExcluded) {
        boolean isExcluded = parentIsExcluded || excluded.contains(DependencyExclusionEditor.getGroupAndArtifactId(node));
        node.setChecked(!isExcluded);
        Enumeration children = node.children();
        while (children.hasMoreElements()) {
            Object child = children.nextElement();
            DependencyExclusionEditor.uncheckExcludedNodes((CheckedTreeNode)child, excluded, isExcluded);
        }
    }

    private static Set<String> collectUncheckedNodes(CheckedTreeNode node, Set<String> result) {
        if (node.isChecked()) {
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                Object child = children.nextElement();
                DependencyExclusionEditor.collectUncheckedNodes((CheckedTreeNode)child, result);
            }
        } else {
            result.add(DependencyExclusionEditor.getGroupAndArtifactId(node));
        }
        return result;
    }

    @NotNull
    private static String getGroupAndArtifactId(CheckedTreeNode node) {
        Artifact artifact = (Artifact)node.getUserObject();
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    @NotNull
    private static CheckedTreeNode createDependencyTreeNode(ArtifactDependencyNode node) {
        CheckedTreeNode treeNode = new CheckedTreeNode((Object)node.getArtifact());
        for (ArtifactDependencyNode dependency : node.getDependencies()) {
            treeNode.add((MutableTreeNode)DependencyExclusionEditor.createDependencyTreeNode(dependency));
        }
        return treeNode;
    }
}

