/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class MockDocument
extends UserDataHolderBase
implements DocumentEx {
    private StringBuffer myText = new StringBuffer();
    private long myModStamp = LocalTimeCounter.currentTime();

    @NotNull
    public CharSequence getImmutableCharSequence() {
        return this.myText.toString();
    }

    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        this.myText = new StringBuffer();
        this.myText.append(chars);
        this.myModStamp = newModificationStamp;
    }

    public void moveText(int srcStart, int srcEnd, int dstOffset) {
        throw new UnsupportedOperationException();
    }

    public CharSequence textToCharArray() {
        return this.getText();
    }

    public int getTextLength() {
        return this.myText.length();
    }

    public int getLineCount() {
        return 1;
    }

    public int getLineNumber(int offset) {
        return 0;
    }

    public int getLineStartOffset(int line) {
        return 0;
    }

    public int getLineEndOffset(int line) {
        return this.myText.length();
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        this.myText.insert(offset, s);
    }

    public void deleteString(int startOffset, int endOffset) {
        this.myText.delete(startOffset, endOffset);
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        this.myText.replace(startOffset, endOffset, s.toString());
        this.myModStamp = LocalTimeCounter.currentTime();
    }

    public boolean isWritable() {
        return false;
    }

    public long getModificationStamp() {
        return this.myModStamp;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public LineIterator createLineIterator() {
        throw new UnsupportedOperationException();
    }

    public void setModificationStamp(long modificationStamp) {
        this.myModStamp = modificationStamp;
    }

    public void setText(@NotNull CharSequence text) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
    }

    public boolean processRangeMarkers(@NotNull Processor<? super RangeMarker> processor2) {
        return false;
    }

    public boolean processRangeMarkersOverlappingWith(int start, int end, @NotNull Processor<? super RangeMarker> processor2) {
        return false;
    }

    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        return false;
    }
}

