/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockVirtualFileSystem;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.SmartList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockVirtualFile
extends VirtualFile {
    private static final MockVirtualFileSystem ourFileSystem = new MockVirtualFileSystem();
    private VirtualFile myParent;
    private final String myName;
    private final boolean myDirectory;
    private final List<VirtualFile> myChildren = new SmartList();
    private String myText;
    private boolean myIsWritable = true;
    private long myModStamp = LocalTimeCounter.currentTime();
    private final long myTimeStamp = System.currentTimeMillis();
    private VirtualFileListener myListener;

    public static MockVirtualFile dir(@NotNull String name2, MockVirtualFile ... children) {
        MockVirtualFile dir = new MockVirtualFile(true, name2);
        for (MockVirtualFile child : children) {
            dir.addChild(child);
        }
        return dir;
    }

    public static MockVirtualFile file(@NotNull String name2) {
        return new MockVirtualFile(name2);
    }

    public MockVirtualFile(String name2) {
        this(false, name2);
    }

    public MockVirtualFile(boolean directory, String name2) {
        this.myDirectory = directory;
        this.myName = name2;
    }

    public MockVirtualFile(String name2, String text) {
        this.myName = name2;
        this.myText = text;
        this.myDirectory = false;
    }

    public void setText(String text) {
        this.myText = text;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public void setParent(VirtualFile parent) {
        this.myParent = parent;
    }

    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull String name2) {
        MockVirtualFile file = new MockVirtualFile(name2);
        this.addChild(file);
        return file;
    }

    public void addChild(@NotNull MockVirtualFile child) {
        child.setParent(this);
        this.myChildren.add(child);
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return ourFileSystem;
    }

    @NotNull
    public String getPath() {
        String prefix = this.myParent == null ? "MOCK_ROOT:" : this.myParent.getPath();
        return prefix + "/" + this.myName;
    }

    public boolean isWritable() {
        return this.myIsWritable;
    }

    public void setWritable(boolean writable) {
        this.myIsWritable = writable;
    }

    public boolean isDirectory() {
        return this.myDirectory;
    }

    public boolean isValid() {
        return true;
    }

    @Nullable
    public VirtualFile getParent() {
        return this.myParent;
    }

    public VirtualFile[] getChildren() {
        return VfsUtilCore.toVirtualFileArray(this.myChildren);
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        return new ByteArrayOutputStream(){

            @Override
            public void close() {
                MockVirtualFile.this.myModStamp = newModificationStamp;
                MockVirtualFile.this.myText = this.toString();
            }
        };
    }

    public long getModificationStamp() {
        return this.myModStamp;
    }

    public void setModificationStamp(long modStamp) {
        this.myModStamp = modStamp;
    }

    @NotNull
    public byte[] contentsToByteArray() {
        return this.myText == null ? ArrayUtil.EMPTY_BYTE_ARRAY : this.myText.getBytes(CharsetToolkit.UTF8_CHARSET);
    }

    public long getTimeStamp() {
        return this.myTimeStamp;
    }

    public long getLength() {
        return this.myText == null ? 0L : (long)this.myText.length();
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public InputStream getInputStream() {
        throw new UnsupportedOperationException("Method getInputStream is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public void setListener(VirtualFileListener listener) {
        this.myListener = listener;
    }

    public void setContent(@Nullable Object requestor, String content, boolean fireEvent) {
        long oldStamp = this.myModStamp;
        this.myText = content;
        if (fireEvent) {
            this.myModStamp = LocalTimeCounter.currentTime();
            this.myListener.contentsChanged(new VirtualFileEvent(requestor, (VirtualFile)this, null, oldStamp, this.myModStamp));
        }
    }
}

