/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import gnu.trove.THashMap;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockVirtualFileSystem
extends DeprecatedVirtualFileSystem {
    private static final String PROTOCOL = "mock";
    private final MyVirtualFile myRoot = new MyVirtualFile("", null){

        @Override
        @NotNull
        public VirtualFileSystem getFileSystem() {
            return MockVirtualFileSystem.this;
        }
    };

    @NotNull
    public MyVirtualFile findFileByPath(@NotNull String path) {
        String normalized = path.replace(File.separatorChar, '/').replace('/', ':');
        if (StringUtil.startsWithChar((CharSequence)normalized, (char)':')) {
            normalized = normalized.substring(1);
        }
        MyVirtualFile file = this.myRoot;
        for (String component : StringUtil.split((String)normalized, (String)":")) {
            file = file.getOrCreate(component);
        }
        return file;
    }

    @NotNull
    public MockVirtualFileSystem file(@NotNull String path, @NotNull String data) {
        MyVirtualFile file = this.findFileByPath(path);
        file.setContent(null, data, false);
        return this;
    }

    @NotNull
    public VirtualFile getRoot() {
        return this.myRoot;
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    public void refresh(boolean asynchronous) {
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return this.findFileByPath(path);
    }

    private static class MyVirtualFile
    extends LightVirtualFile {
        private final MyVirtualFile myParent;
        private Map<String, MyVirtualFile> myChildren;

        private MyVirtualFile(String name2, MyVirtualFile parent) {
            super(name2);
            this.myParent = parent;
        }

        @NotNull
        public VirtualFileSystem getFileSystem() {
            return this.myParent.getFileSystem();
        }

        @NotNull
        public MyVirtualFile getOrCreate(@NotNull String name2) {
            MyVirtualFile file = this.findChild(name2);
            if (file == null) {
                if (this.myChildren == null) {
                    this.myChildren = new THashMap();
                }
                file = new MyVirtualFile(name2, this);
                this.myChildren.put(name2, file);
            }
            return file;
        }

        public boolean isDirectory() {
            return this.myParent == null || this.myChildren != null && !this.myChildren.isEmpty();
        }

        @NotNull
        public String getPath() {
            MyVirtualFile parent = this.getParent();
            return parent == null ? this.getName() : parent.getPath() + "/" + this.getName();
        }

        public MyVirtualFile getParent() {
            return this.myParent;
        }

        public VirtualFile[] getChildren() {
            return this.myChildren == null ? EMPTY_ARRAY : VfsUtilCore.toVirtualFileArray(this.myChildren.values());
        }

        @Nullable
        public MyVirtualFile findChild(@NotNull String name2) {
            return this.myChildren == null ? null : this.myChildren.get(name2);
        }
    }
}

