/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.generic;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="192.0")
public class VirtualFileWithDependenciesState {
    public static final DataExternalizer<VirtualFileWithDependenciesState> EXTERNALIZER = new VirtualFileWithDependenciesExternalizer();
    private final long mySourceTimestamp;
    private final Map<String, Long> myDependencies = new HashMap<String, Long>();

    public VirtualFileWithDependenciesState(long sourceTimestamp) {
        this.mySourceTimestamp = sourceTimestamp;
    }

    public void addDependency(@NotNull VirtualFile file) {
        this.myDependencies.put(file.getUrl(), file.getTimeStamp());
    }

    public boolean isUpToDate(@NotNull VirtualFile sourceFile) {
        if (sourceFile.getTimeStamp() != this.mySourceTimestamp) {
            return false;
        }
        VirtualFileManager manager = VirtualFileManager.getInstance();
        for (Map.Entry<String, Long> entry : this.myDependencies.entrySet()) {
            VirtualFile file = manager.findFileByUrl(entry.getKey());
            if (file != null && file.getTimeStamp() == entry.getValue().longValue()) continue;
            return false;
        }
        return true;
    }

    private static class VirtualFileWithDependenciesExternalizer
    implements DataExternalizer<VirtualFileWithDependenciesState> {
        private VirtualFileWithDependenciesExternalizer() {
        }

        public void save(@NotNull DataOutput out, VirtualFileWithDependenciesState value) throws IOException {
            out.writeLong(value.mySourceTimestamp);
            Map dependencies = value.myDependencies;
            out.writeInt(dependencies.size());
            for (Map.Entry entry : dependencies.entrySet()) {
                IOUtil.writeUTF((DataOutput)out, (String)((String)entry.getKey()));
                out.writeLong((Long)entry.getValue());
            }
        }

        public VirtualFileWithDependenciesState read(@NotNull DataInput in) throws IOException {
            VirtualFileWithDependenciesState state = new VirtualFileWithDependenciesState(in.readLong());
            int size = in.readInt();
            while (size-- > 0) {
                String url = IOUtil.readUTF((DataInput)in);
                long timestamp = in.readLong();
                state.myDependencies.put(url, timestamp);
            }
            return state;
        }
    }
}

