/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.wizard.AbstractExternalProjectImportProvider;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.projectImport.ProjectImportProvider;
import org.jetbrains.annotations.NotNull;

public class AttachExternalProjectAction
extends AnAction {
    public AttachExternalProjectAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.attach.external.project.text", (Object[])new Object[]{"external"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.attach.external.project.description", (Object[])new Object[]{"external"}));
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        if (!ExternalSystemApiUtil.isJavaCompatibleIde()) {
            presentation.setVisible(false);
            presentation.setEnabled(false);
            return;
        }
        ProjectSystemId externalSystemId = (ProjectSystemId)ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.getData(e.getDataContext());
        if (externalSystemId != null) {
            String name2 = externalSystemId.getReadableName();
            presentation.setText(ExternalSystemBundle.message((String)"action.attach.external.project.text", (Object[])new Object[]{name2}));
            presentation.setDescription(ExternalSystemBundle.message((String)"action.attach.external.project.description", (Object[])new Object[]{name2}));
        }
        presentation.setIcon(AllIcons.General.Add);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ProjectSystemId externalSystemId = (ProjectSystemId)ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.getData(e.getDataContext());
        if (externalSystemId == null) {
            return;
        }
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        if (manager == null) {
            return;
        }
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        ExternalSystemActionsCollector.trigger(project2, externalSystemId, this, e, new String[0]);
        ProjectImportProvider[] projectImportProviders = new ProjectImportProvider[1];
        for (ProjectImportProvider provider2 : (ProjectImportProvider[])ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensions()) {
            if (!(provider2 instanceof AbstractExternalProjectImportProvider) || !externalSystemId.equals((Object)((AbstractExternalProjectImportProvider)provider2).getExternalSystemId())) continue;
            projectImportProviders[0] = provider2;
            break;
        }
        if (projectImportProviders[0] == null) {
            return;
        }
        AddModuleWizard wizard = ImportModuleAction.selectFileAndCreateWizard(project2, null, manager.getExternalProjectDescriptor(), projectImportProviders);
        if (wizard != null && (wizard.getStepCount() <= 0 || wizard.showAndGet())) {
            ImportModuleAction.createFromWizard(project2, wizard);
        }
    }
}

