/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public abstract class ExternalSystemAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Presentation p = e.getPresentation();
        boolean visible = this.isVisible(e);
        p.setVisible(visible);
        p.setEnabled(visible && this.isEnabled(e));
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        return this.hasProject(e) && this.getSystemId(e) != null;
    }

    protected boolean isVisible(@NotNull AnActionEvent e) {
        return true;
    }

    protected Project getProject(@NotNull AnActionEvent e) {
        return e.getProject();
    }

    protected ProjectSystemId getSystemId(@NotNull AnActionEvent e) {
        return (ProjectSystemId)ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.getData(e.getDataContext());
    }

    protected boolean hasProject(@NotNull AnActionEvent e) {
        return this.getProject(e) != null;
    }

    protected void setText(String message) {
        this.getTemplatePresentation().setText(message);
    }

    protected void setDescription(String message) {
        this.getTemplatePresentation().setDescription(message);
    }

    protected void setText(@NotNull AnActionEvent e, String message) {
        e.getPresentation().setText(message);
    }
}

