/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public abstract class ExternalSystemToggleAction
extends ToggleAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Presentation p = e.getPresentation();
        boolean visible = this.isVisible(e);
        p.setVisible(visible);
        p.setEnabled(visible && this.isEnabled(e));
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        return this.hasProject(e);
    }

    protected boolean isVisible(@NotNull AnActionEvent e) {
        return true;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (!this.isEnabled(e)) {
            return false;
        }
        return this.doIsSelected(e);
    }

    protected abstract boolean doIsSelected(@NotNull AnActionEvent var1);

    protected Project getProject(@NotNull AnActionEvent e) {
        return e.getProject();
    }

    protected boolean hasProject(@NotNull AnActionEvent e) {
        return this.getProject(e) != null;
    }

    protected ProjectSystemId getSystemId(@NotNull AnActionEvent e) {
        return (ProjectSystemId)ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.getData(e.getDataContext());
    }

    protected void setText(String message) {
        this.getTemplatePresentation().setText(message);
    }

    protected void setDescription(String message) {
        this.getTemplatePresentation().setDescription(message);
    }

    protected void setText(@NotNull AnActionEvent e, String message) {
        e.getPresentation().setText(message);
    }

    protected void setDescription(@NotNull AnActionEvent e, String message) {
        e.getPresentation().setDescription(message);
    }
}

