/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.action.ExternalSystemToggleAction;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class IgnoreExternalProjectAction
extends ExternalSystemToggleAction {
    private static final Logger LOG = Logger.getInstance(IgnoreExternalProjectAction.class);

    public IgnoreExternalProjectAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.ignore.external.projects.text", (Object[])new Object[]{"external", "project"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.ignore.external.projects.description", (Object[])new Object[]{"external", "project"}));
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        ProjectSystemId projectSystemId = this.getSystemId(e);
        List<ExternalSystemNode<ExternalConfigPathAware>> projectNodes = IgnoreExternalProjectAction.getProjectNodes(e);
        if (projectNodes.isEmpty()) {
            return;
        }
        final Project project2 = this.getProject(e);
        ExternalSystemActionsCollector.trigger(project2, projectSystemId, (AnAction)this, e, new String[0]);
        projectNodes.forEach(projectNode -> projectNode.setIgnored(state));
        final Set uniqueExternalProjects = projectNodes.stream().map(projectNode -> {
            DataNode projectDataNode;
            String externalProjectPath = ((ExternalConfigPathAware)projectNode.getData()).getLinkedExternalProjectPath();
            ExternalProjectInfo externalProjectInfo = ExternalSystemUtil.getExternalProjectInfo(project2, projectSystemId, externalProjectPath);
            DataNode dataNode = projectDataNode = externalProjectInfo == null ? null : externalProjectInfo.getExternalProjectStructure();
            if (projectDataNode == null && LOG.isDebugEnabled()) {
                LOG.debug(String.format("external project data not found, path: %s, data: %s", externalProjectPath, externalProjectInfo));
            }
            return projectDataNode;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, e.getPresentation().getText(), false){

            public void run(@NotNull ProgressIndicator indicator) {
                uniqueExternalProjects.forEach(externalProjectInfo -> ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProjectInfo, project2, true));
            }
        });
    }

    @Override
    public boolean isSelected(@NotNull AnActionEvent e) {
        boolean selected = super.isSelected(e);
        ProjectSystemId systemId = this.getSystemId(e);
        String systemIdName = systemId != null ? systemId.getReadableName() : "external";
        String pluralizedProjects = StringUtil.pluralize((String)"project", (int)IgnoreExternalProjectAction.getProjectNodes(e).size());
        if (selected) {
            this.setText(e, ExternalSystemBundle.message((String)"action.unignore.external.projects.text", (Object[])new Object[]{systemIdName, pluralizedProjects}));
            this.setDescription(e, ExternalSystemBundle.message((String)"action.unignore.external.projects.description", (Object[])new Object[]{systemIdName, pluralizedProjects}));
        } else {
            this.setText(e, ExternalSystemBundle.message((String)"action.ignore.external.projects.text", (Object[])new Object[]{systemIdName, pluralizedProjects}));
            this.setDescription(e, ExternalSystemBundle.message((String)"action.ignore.external.projects.description", (Object[])new Object[]{systemIdName, pluralizedProjects}));
        }
        return selected;
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        return !IgnoreExternalProjectAction.getProjectNodes(e).isEmpty();
    }

    @Override
    protected boolean doIsSelected(@NotNull AnActionEvent e) {
        return ContainerUtil.exists(IgnoreExternalProjectAction.getProjectNodes(e), projectNode -> projectNode.isIgnored());
    }

    @NotNull
    private static List<ExternalSystemNode<ExternalConfigPathAware>> getProjectNodes(@NotNull AnActionEvent e) {
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        if (selectedNodes == null || selectedNodes.isEmpty()) {
            return Collections.emptyList();
        }
        return selectedNodes.stream().map(node -> node instanceof ModuleNode || node instanceof ProjectNode ? node : null).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

