/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemNodeAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.task.ui.ConfigureTasksActivationDialog;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OpenTasksActivationManagerAction
extends ExternalSystemNodeAction<AbstractExternalEntityData> {
    public OpenTasksActivationManagerAction() {
        super(AbstractExternalEntityData.class);
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"external.system.task.activation.title", (Object[])new Object[0]));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"external.system.task.activation.description", (Object[])new Object[]{"external system"}));
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        if (selectedNodes == null || selectedNodes.size() != 1) {
            return false;
        }
        Object externalData = ((ExternalSystemNode)selectedNodes.get(0)).getData();
        ProjectSystemId projectSystemId = this.getSystemId(e);
        e.getPresentation().setText(ExternalSystemBundle.message((String)"external.system.task.activation.title", (Object[])new Object[0]));
        e.getPresentation().setDescription(ExternalSystemBundle.message((String)"external.system.task.activation.description", (Object[])new Object[]{projectSystemId.getReadableName()}));
        boolean isProjectNode = externalData instanceof ProjectData || externalData instanceof ModuleData;
        return isProjectNode && StringUtil.isNotEmpty((String)((ExternalConfigPathAware)externalData).getLinkedExternalProjectPath());
    }

    @Override
    public void perform(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull AbstractExternalEntityData externalEntityData, @NotNull AnActionEvent e) {
        ExternalConfigPathAware externalConfigPathAware;
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        ExternalSystemNode externalSystemNode = (ExternalSystemNode)ContainerUtil.getFirstItem((List)selectedNodes);
        assert (externalSystemNode != null);
        ExternalConfigPathAware externalConfigPathAware2 = externalConfigPathAware = externalSystemNode.getData() instanceof ExternalConfigPathAware ? (ExternalConfigPathAware)externalSystemNode.getData() : null;
        assert (externalConfigPathAware != null);
        new ConfigureTasksActivationDialog(project2, projectSystemId, externalConfigPathAware.getLinkedExternalProjectPath()).showAndGet();
    }
}

