/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.internal;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternalExternalProjectInfo
implements ExternalProjectInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private ProjectSystemId myProjectSystemId;
    @NotNull
    private String myExternalProjectPath;
    @Nullable
    private DataNode<ProjectData> myExternalProjectStructure;
    private long lastSuccessfulImportTimestamp = -1L;
    private long lastImportTimestamp = -1L;
    private String myBuildNumber;

    public InternalExternalProjectInfo(@NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath, @Nullable DataNode<ProjectData> externalProjectStructure) {
        this.myProjectSystemId = projectSystemId;
        this.myExternalProjectPath = externalProjectPath;
        this.myExternalProjectStructure = externalProjectStructure;
        this.myBuildNumber = ApplicationInfo.getInstance().getBuild().asString();
    }

    @NotNull
    public ProjectSystemId getProjectSystemId() {
        return this.myProjectSystemId;
    }

    @NotNull
    public String getExternalProjectPath() {
        return this.myExternalProjectPath;
    }

    @Nullable
    public String getNullSafeExternalProjectPath() {
        return this.myExternalProjectPath;
    }

    @Nullable
    public DataNode<ProjectData> getExternalProjectStructure() {
        return this.myExternalProjectStructure;
    }

    public long getLastSuccessfulImportTimestamp() {
        return this.lastSuccessfulImportTimestamp;
    }

    public long getLastImportTimestamp() {
        return this.lastImportTimestamp;
    }

    public void setLastSuccessfulImportTimestamp(long lastSuccessfulImportTimestamp) {
        this.lastSuccessfulImportTimestamp = lastSuccessfulImportTimestamp;
    }

    public void setLastImportTimestamp(long lastImportTimestamp) {
        this.lastImportTimestamp = lastImportTimestamp;
    }

    public String getBuildNumber() {
        return this.myBuildNumber;
    }

    public ExternalProjectInfo copy() {
        InternalExternalProjectInfo copy = new InternalExternalProjectInfo(this.myProjectSystemId, this.myExternalProjectPath, this.myExternalProjectStructure != null ? this.myExternalProjectStructure.graphCopy() : null);
        copy.setLastImportTimestamp(this.lastImportTimestamp);
        copy.setLastSuccessfulImportTimestamp(this.lastSuccessfulImportTimestamp);
        return copy;
    }

    public String toString() {
        return "InternalExternalProjectInfo{myProjectSystemId=" + this.myProjectSystemId + ", myExternalProjectPath='" + this.myExternalProjectPath + '\'' + ", myExternalProjectStructure=" + this.myExternalProjectStructure + ", lastSuccessfulImportTimestamp=" + this.lastSuccessfulImportTimestamp + ", lastImportTimestamp=" + this.lastImportTimestamp + '}';
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.myProjectSystemId);
        out.writeObject(this.myExternalProjectPath);
        out.writeObject(this.myExternalProjectStructure);
        out.writeLong(this.lastSuccessfulImportTimestamp);
        out.writeLong(this.lastImportTimestamp);
        out.writeObject(this.myBuildNumber);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.myProjectSystemId = (ProjectSystemId)in.readObject();
        this.myExternalProjectPath = (String)in.readObject();
        this.myExternalProjectStructure = (DataNode)in.readObject();
        this.lastSuccessfulImportTimestamp = in.readLong();
        this.lastImportTimestamp = in.readLong();
        try {
            this.myBuildNumber = (String)in.readObject();
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
    }
}

