/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemTaskSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemRunConfigurationEditor
extends SettingsEditor<ExternalSystemRunConfiguration> {
    @NotNull
    private final ExternalSystemTaskSettingsControl myControl;

    public ExternalSystemRunConfigurationEditor(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        this.myControl = new ExternalSystemTaskSettingsControl(project2, externalSystemId);
    }

    protected void resetEditorFrom(@NotNull ExternalSystemRunConfiguration s) {
        this.myControl.setOriginalSettings(s.getSettings());
        this.myControl.reset(s.getProject());
    }

    protected void applyEditorTo(@NotNull ExternalSystemRunConfiguration s) throws ConfigurationException {
        this.myControl.apply(s.getSettings());
    }

    @NotNull
    protected JComponent createEditor() {
        PaintAwarePanel result = new PaintAwarePanel(new GridBagLayout());
        this.myControl.fillUi(result, 0);
        result.add((Component)new Box.Filler(new Dimension(0, 0), new Dimension(0, 200), new Dimension(0, 0)), ExternalSystemUiUtil.getFillLineConstraints(0));
        ExternalSystemUiUtil.fillBottom(result);
        return result;
    }

    protected void disposeEditor() {
        this.myControl.disposeUIResources();
    }
}

