/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.BuildView;
import com.intellij.debugger.impl.GenericDebuggerRunner;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ForkedDebuggerThread;
import java.net.ServerSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskDebugRunner
extends GenericDebuggerRunner {
    static final Logger LOG = Logger.getInstance(ExternalSystemTaskDebugRunner.class);

    @Override
    @NotNull
    public String getRunnerId() {
        return "ExternalSystemTaskDebugRunner";
    }

    @Override
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile2) {
        return profile2 instanceof ExternalSystemRunConfiguration && DefaultDebugExecutor.EXECUTOR_ID.equals(executorId);
    }

    @Override
    @Nullable
    protected RunContentDescriptor createContentDescriptor(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state instanceof ExternalSystemRunConfiguration.MyRunnableState) {
            ExternalSystemRunConfiguration.MyRunnableState myRunnableState = (ExternalSystemRunConfiguration.MyRunnableState)state;
            int port = myRunnableState.getDebugPort();
            if (port > 0) {
                RunContentDescriptor runContentDescriptor = this.doGetRunContentDescriptor(myRunnableState, environment, port);
                if (runContentDescriptor == null) {
                    return null;
                }
                ProcessHandler processHandler = runContentDescriptor.getProcessHandler();
                ServerSocket socket = myRunnableState.getForkSocket();
                if (socket != null && processHandler != null) {
                    new ForkedDebuggerThread(processHandler, runContentDescriptor, socket, environment.getProject()).start();
                }
                return runContentDescriptor;
            }
            LOG.warn("Can't attach debugger to external system task execution. Reason: target debug port is unknown");
        } else {
            LOG.warn(String.format("Can't attach debugger to external system task execution. Reason: invalid run profile state is provided- expected '%s' but got '%s'", ExternalSystemRunConfiguration.MyRunnableState.class.getName(), state.getClass().getName()));
        }
        return null;
    }

    @Nullable
    private RunContentDescriptor doGetRunContentDescriptor(@NotNull ExternalSystemRunConfiguration.MyRunnableState state, @NotNull ExecutionEnvironment environment, int port) throws ExecutionException {
        RemoteConnection connection = new RemoteConnection(true, "127.0.0.1", String.valueOf(port), true);
        RunContentDescriptor runContentDescriptor = this.attachVirtualMachine((RunProfileState)state, environment, connection, true);
        if (runContentDescriptor == null) {
            return null;
        }
        state.setContentDescriptor(runContentDescriptor);
        ExecutionConsole executionConsole = runContentDescriptor.getExecutionConsole();
        if (executionConsole instanceof BuildView) {
            return runContentDescriptor;
        }
        RunContentDescriptor descriptor2 = new RunContentDescriptor(runContentDescriptor.getExecutionConsole(), runContentDescriptor.getProcessHandler(), runContentDescriptor.getComponent(), runContentDescriptor.getDisplayName(), runContentDescriptor.getIcon(), null, runContentDescriptor.getRestartActions()){

            public boolean isHiddenContent() {
                return true;
            }
        };
        descriptor2.setRunnerLayoutUi(runContentDescriptor.getRunnerLayoutUi());
        return descriptor2;
    }
}

