/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.ExternalSystemProgressNotificationManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.keyFMap.KeyFMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemExecuteTaskTask
extends AbstractExternalSystemTask {
    @NotNull
    private final List<String> myTasksToExecute;
    @Nullable
    private final String myVmOptions;
    @Nullable
    private String myArguments;
    @Nullable
    private final String myJvmAgentSetup;
    private final boolean myPassParentEnvs;
    private final Map<String, String> myEnv;

    public ExternalSystemExecuteTaskTask(@NotNull Project project2, @NotNull ExternalSystemTaskExecutionSettings settings, @Nullable String jvmAgentSetup) throws IllegalArgumentException {
        super(settings.getExternalSystemId(), ExternalSystemTaskType.EXECUTE_TASK, project2, settings.getExternalProjectPath());
        this.myTasksToExecute = ContainerUtilRt.newArrayList((Iterable)settings.getTaskNames());
        this.myVmOptions = settings.getVmOptions();
        this.myArguments = settings.getScriptParameters();
        this.myPassParentEnvs = settings.isPassParentEnvs();
        this.myEnv = settings.getEnv();
        this.myJvmAgentSetup = jvmAgentSetup;
    }

    @Deprecated
    public ExternalSystemExecuteTaskTask(@NotNull ProjectSystemId externalSystemId, @NotNull Project project2, @NotNull List<? extends ExternalTaskPojo> tasksToExecute, @Nullable String vmOptions, @Nullable String arguments, @Nullable String jvmAgentSetup) throws IllegalArgumentException {
        super(externalSystemId, ExternalSystemTaskType.EXECUTE_TASK, project2, ExternalSystemExecuteTaskTask.getLinkedExternalProjectPath(tasksToExecute));
        this.myTasksToExecute = ContainerUtil.map(tasksToExecute, ExternalTaskPojo::getName);
        this.myVmOptions = vmOptions;
        this.myArguments = arguments;
        this.myJvmAgentSetup = jvmAgentSetup;
        this.myPassParentEnvs = true;
        this.myEnv = Collections.emptyMap();
    }

    @NotNull
    public List<String> getTasksToExecute() {
        return this.myTasksToExecute;
    }

    @Nullable
    public String getVmOptions() {
        return this.myVmOptions;
    }

    @Nullable
    public String getArguments() {
        return this.myArguments;
    }

    public void appendArguments(@NotNull String arguments) {
        this.myArguments = this.myArguments == null ? arguments : this.myArguments + ' ' + arguments;
    }

    @Deprecated
    @NotNull
    private static String getLinkedExternalProjectPath(@NotNull Collection<? extends ExternalTaskPojo> tasks2) throws IllegalArgumentException {
        if (tasks2.isEmpty()) {
            throw new IllegalArgumentException("Can't execute external tasks. Reason: given tasks list is empty");
        }
        String result = null;
        for (ExternalTaskPojo externalTaskPojo : tasks2) {
            String path = externalTaskPojo.getLinkedExternalProjectPath();
            if (result == null) {
                result = path;
                continue;
            }
            if (result.equals(path)) continue;
            throw new IllegalArgumentException(String.format("Can't execute given external system tasks. Reason: expected that all of them belong to the same external project but they are not (at least two different projects detected - '%s' and '%s'). Tasks: %s", result, externalTaskPojo.getLinkedExternalProjectPath(), tasks2));
        }
        assert (result != null);
        return result;
    }

    @Override
    protected void doExecute() throws Exception {
        RemoteExternalSystemTaskManager<ExternalSystemExecutionSettings> taskManager;
        ExternalSystemExecutionSettings settings;
        ExternalSystemProgressNotificationManagerImpl progressNotificationManager = (ExternalSystemProgressNotificationManagerImpl)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
        ExternalSystemTaskId id = this.getId();
        String projectPath = this.getExternalProjectPath();
        try {
            progressNotificationManager.onStart(id, projectPath);
            ExternalSystemFacadeManager manager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
            settings = ExternalSystemApiUtil.getExecutionSettings((Project)this.getIdeProject(), (String)projectPath, (ProjectSystemId)this.getExternalSystemId());
            KeyFMap keyFMap = this.getUserMap();
            for (Key key : keyFMap.getKeys()) {
                settings.putUserData(key, keyFMap.get(key));
            }
            RemoteExternalSystemFacade facade = manager.getFacade(this.getIdeProject(), projectPath, this.getExternalSystemId());
            taskManager = facade.getTaskManager();
            List<String> vmOptions = ExternalSystemExecuteTaskTask.parseCmdParameters(this.myVmOptions);
            List<String> arguments = ExternalSystemExecuteTaskTask.parseCmdParameters(this.myArguments);
            settings.withVmOptions(vmOptions).withArguments(arguments).withEnvironmentVariables(this.myEnv).passParentEnvs(this.myPassParentEnvs);
        }
        catch (Exception e) {
            progressNotificationManager.onFailure(id, e);
            progressNotificationManager.onEnd(id);
            throw e;
        }
        taskManager.executeTasks(id, this.myTasksToExecute, projectPath, settings, this.myJvmAgentSetup);
    }

    @Override
    protected boolean doCancel() throws Exception {
        ExternalSystemFacadeManager manager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
        RemoteExternalSystemFacade facade = manager.getFacade(this.getIdeProject(), this.getExternalProjectPath(), this.getExternalSystemId());
        RemoteExternalSystemTaskManager taskManager = facade.getTaskManager();
        return taskManager.cancelTask(this.getId());
    }

    private static List<String> parseCmdParameters(@Nullable String cmdArgsLine) {
        return cmdArgsLine != null ? ParametersListUtil.parse((String)cmdArgsLine, (boolean)false, (boolean)true) : ContainerUtil.newArrayList();
    }
}

