/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.service.project.ExternalLibraryPathTypeMapper;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ExternalLibraryPathTypeMapperImpl
implements ExternalLibraryPathTypeMapper {
    private static final Map<LibraryPathType, OrderRootType> MAPPINGS = new EnumMap<LibraryPathType, OrderRootType>(LibraryPathType.class);

    @NotNull
    public OrderRootType map(@NotNull LibraryPathType type) {
        return MAPPINGS.get(type);
    }

    static {
        MAPPINGS.put(LibraryPathType.BINARY, OrderRootType.CLASSES);
        MAPPINGS.put(LibraryPathType.SOURCE, OrderRootType.SOURCES);
        OrderRootType docRootType = Arrays.stream(OrderRootType.getAllTypes()).anyMatch(JavadocOrderRootType.class::isInstance) ? JavadocOrderRootType.getInstance() : OrderRootType.DOCUMENTATION;
        MAPPINGS.put(LibraryPathType.DOC, docRootType);
        assert (LibraryPathType.values().length == MAPPINGS.size());
    }
}

