/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.service.project.AbstractIdeModifiableModelsProvider;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeModifiableModelsProviderImpl
extends AbstractIdeModifiableModelsProvider {
    private final LibraryTable.ModifiableModel myLibrariesModel;

    public IdeModifiableModelsProviderImpl(Project project2) {
        super(project2);
        this.myLibrariesModel = ProjectLibraryTable.getInstance((Project)this.myProject).getModifiableModel();
    }

    @Override
    @NotNull
    public LibraryTable.ModifiableModel getModifiableProjectLibrariesModel() {
        return this.myLibrariesModel;
    }

    @Override
    protected ModifiableArtifactModel doGetModifiableArtifactModel() {
        return (ModifiableArtifactModel)ReadAction.compute(() -> {
            ArtifactManager artifactManager = ArtifactManager.getInstance((Project)this.myProject);
            return artifactManager != null ? artifactManager.createModifiableModel() : new DummyArtifactModel();
        });
    }

    @Override
    protected ModifiableModuleModel doGetModifiableModuleModel() {
        return (ModifiableModuleModel)ReadAction.compute(() -> ModuleManager.getInstance((Project)this.myProject).getModifiableModel());
    }

    @Override
    @NotNull
    protected ModifiableRootModel doGetModifiableRootModel(@NotNull Module module2) {
        return (ModifiableRootModel)ReadAction.compute(() -> ModuleRootManager.getInstance((Module)module2).getModifiableModel());
    }

    @Override
    protected ModifiableFacetModel doGetModifiableFacetModel(Module module2) {
        return FacetManager.getInstance((Module)module2).createModifiableModel();
    }

    @Override
    protected Library.ModifiableModel doGetModifiableLibraryModel(Library library) {
        return library.getModifiableModel();
    }

    private static class DummyArtifactModel
    implements ModifiableArtifactModel {
        private DummyArtifactModel() {
        }

        @NotNull
        public ModifiableArtifact addArtifact(@NotNull String name2, @NotNull ArtifactType artifactType) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public ModifiableArtifact addArtifact(@NotNull String name2, @NotNull ArtifactType artifactType, CompositePackagingElement<?> rootElement) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public ModifiableArtifact addArtifact(@NotNull String name2, @NotNull ArtifactType artifactType, CompositePackagingElement<?> rootElement, @Nullable ProjectModelExternalSource externalSource) {
            throw new UnsupportedOperationException();
        }

        public void removeArtifact(@NotNull Artifact artifact) {
        }

        @NotNull
        public ModifiableArtifact getOrCreateModifiableArtifact(@NotNull Artifact artifact) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Artifact getModifiableCopy(Artifact artifact) {
            return null;
        }

        public void addListener(@NotNull ArtifactListener listener) {
        }

        public void removeListener(@NotNull ArtifactListener listener) {
        }

        public boolean isModified() {
            return false;
        }

        public void commit() {
        }

        public void dispose() {
        }

        @NotNull
        public Artifact[] getArtifacts() {
            return new Artifact[0];
        }

        @Nullable
        public Artifact findArtifact(@NotNull String name2) {
            return null;
        }

        @NotNull
        public Artifact getArtifactByOriginal(@NotNull Artifact artifact) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Artifact getOriginalArtifact(@NotNull Artifact artifact) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Collection<? extends Artifact> getArtifactsByType(@NotNull ArtifactType type) {
            throw new UnsupportedOperationException();
        }

        public List<? extends Artifact> getAllArtifactsIncludingInvalid() {
            throw new UnsupportedOperationException();
        }
    }
}

