/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.AbstractIdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectsWorkspaceImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class ModifiableWorkspace {
    private final Map<ProjectCoordinate, String> myModuleMappingById = ContainerUtil.newTroveMap((TObjectHashingStrategy)new TObjectHashingStrategy<ProjectCoordinate>(){

        public int computeHashCode(ProjectCoordinate object) {
            String groupId = object.getGroupId();
            String artifactId = object.getArtifactId();
            String version = object.getVersion();
            int result = groupId != null ? groupId.hashCode() : 0;
            result = 31 * result + (artifactId != null ? artifactId.hashCode() : 0);
            result = 31 * result + (version != null ? version.hashCode() : 0);
            return result;
        }

        public boolean equals(ProjectCoordinate o1, ProjectCoordinate o2) {
            if (o1.getGroupId() != null ? !o1.getGroupId().equals(o2.getGroupId()) : o2.getGroupId() != null) {
                return false;
            }
            if (o1.getArtifactId() != null ? !o1.getArtifactId().equals(o2.getArtifactId()) : o2.getArtifactId() != null) {
                return false;
            }
            return !(o1.getVersion() != null ? !o1.getVersion().equals(o2.getVersion()) : o2.getVersion() != null);
        }
    });
    private final AbstractIdeModifiableModelsProvider myModelsProvider;
    private final ExternalProjectsWorkspaceImpl.State myState;
    private final MultiMap<String, String> mySubstitutions = MultiMap.createSet();
    private final Map<String, String> myNamesMap = ContainerUtil.newHashMap();

    public ModifiableWorkspace(ExternalProjectsWorkspaceImpl.State state, AbstractIdeModifiableModelsProvider modelsProvider) {
        this.myModelsProvider = modelsProvider;
        HashSet existingModules = ContainerUtil.newHashSet();
        for (Module module2 : modelsProvider.getModules()) {
            this.register(module2, modelsProvider);
            existingModules.add(module2.getName());
        }
        this.myState = state;
        if (this.myState.names != null) {
            for (Map.Entry entry : this.myState.names.entrySet()) {
                if (!existingModules.contains(entry.getKey())) continue;
                this.myNamesMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.myState.substitutions != null) {
            for (Map.Entry entry : this.myState.substitutions.entrySet()) {
                if (!existingModules.contains(entry.getKey())) continue;
                this.mySubstitutions.put(entry.getKey(), (Collection)entry.getValue());
            }
        }
    }

    public void commit() {
        HashSet existingModules = ContainerUtil.newHashSet();
        Arrays.stream(this.myModelsProvider.getModules()).map(Module::getName).forEach(existingModules::add);
        this.myState.names = new HashMap<String, String>();
        this.myNamesMap.forEach((module2, lib) -> {
            if (existingModules.contains(module2)) {
                this.myState.names.put((String)module2, (String)lib);
            }
        });
        this.myState.substitutions = new HashMap<String, Set<String>>();
        for (Map.Entry entry : this.mySubstitutions.entrySet()) {
            Collection value;
            if (!existingModules.contains(entry.getKey()) || (value = (Collection)entry.getValue()) == null || value.isEmpty()) continue;
            this.myState.substitutions.put((String)entry.getKey(), new TreeSet(value));
        }
    }

    public void addSubstitution(String ownerModuleName, String moduleName, String libraryName, DependencyScope scope) {
        this.myNamesMap.put(moduleName, libraryName);
        this.mySubstitutions.putValue((Object)ownerModuleName, (Object)(moduleName + '_' + scope.getDisplayName()));
    }

    public void removeSubstitution(String ownerModuleName, String moduleName, String libraryName, DependencyScope scope) {
        this.mySubstitutions.remove((Object)ownerModuleName, (Object)(moduleName + '_' + scope.getDisplayName()));
        Collection substitutions = this.mySubstitutions.values();
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!substitutions.contains(moduleName + '_' + dependencyScope.getDisplayName())) continue;
            return;
        }
        this.myNamesMap.remove(moduleName, libraryName);
    }

    public boolean isSubstitution(String moduleOwner, String substitutionModule, DependencyScope scope) {
        return this.mySubstitutions.get((Object)moduleOwner).contains(substitutionModule + '_' + scope.getDisplayName());
    }

    public boolean isSubstituted(String libraryName) {
        return this.myNamesMap.values().contains(libraryName);
    }

    public String getSubstitutedLibrary(String moduleName) {
        return this.myNamesMap.get(moduleName);
    }

    @Nullable
    public String findModule(@NotNull ProjectCoordinate id) {
        if (StringUtil.isEmpty((String)id.getArtifactId())) {
            return null;
        }
        String result = this.myModuleMappingById.get(id);
        return result == null && id.getVersion() != null ? this.myModuleMappingById.get(new ProjectId(id.getGroupId(), id.getArtifactId(), null)) : result;
    }

    public void register(@NotNull ProjectCoordinate id, @NotNull Module module2) {
        this.myModuleMappingById.put(id, module2.getName());
        this.myModuleMappingById.put((ProjectCoordinate)new ProjectId(id.getGroupId(), id.getArtifactId(), null), module2.getName());
    }

    private void register(@NotNull Module module2, AbstractIdeModifiableModelsProvider modelsProvider) {
        Arrays.stream(ExternalProjectsWorkspaceImpl.EP_NAME.getExtensions()).map(contributor -> contributor.findProjectId(module2, modelsProvider)).filter(Objects::nonNull).findFirst().ifPresent(id -> this.register((ProjectCoordinate)id, module2));
    }
}

