/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.configurationStore.StateStorageManagerKt;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;
import javax.swing.event.HyperlinkEvent;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModuleDataService<E extends ModuleData>
extends AbstractProjectDataService<E, Module> {
    public static final Key<ModuleData> MODULE_DATA_KEY = Key.create((String)"MODULE_DATA_KEY");
    public static final Key<Module> MODULE_KEY = Key.create((String)"LINKED_MODULE");
    public static final Key<Map<OrderEntry, OrderAware>> ORDERED_DATA_MAP_KEY = Key.create((String)"ORDER_ENTRY_DATA_MAP");
    private static final Key<Set<Path>> ORPHAN_MODULE_FILES = Key.create((String)"ORPHAN_FILES");
    private static final Key<AtomicInteger> ORPHAN_MODULE_HANDLERS_COUNTER = Key.create((String)"ORPHAN_MODULE_HANDLERS_COUNTER");
    private static final NotificationGroup ORPHAN_MODULE_NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Build sync orphan modules", (String)ToolWindowId.BUILD);
    private static final Logger LOG = Logger.getInstance(AbstractModuleDataService.class);

    public void importData(@NotNull Collection<DataNode<E>> toImport, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Module module2;
        if (toImport.isEmpty()) {
            return;
        }
        Collection<DataNode<E>> toCreate = this.filterExistingModules(toImport, modelsProvider);
        if (!toCreate.isEmpty()) {
            this.createModules(toCreate, modelsProvider);
        }
        for (DataNode<E> node : toImport) {
            module2 = (Module)node.getUserData(MODULE_KEY);
            if (module2 == null) continue;
            ProjectCoordinate publication = ((ModuleData)node.getData()).getPublication();
            if (publication != null) {
                modelsProvider.registerModulePublication(module2, publication);
            }
            String productionModuleId = ((ModuleData)node.getData()).getProductionModuleId();
            modelsProvider.setTestModuleProperties(module2, productionModuleId);
            this.setModuleOptions(module2, node);
            ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module2);
            AbstractModuleDataService.syncPaths(module2, modifiableRootModel, (ModuleData)node.getData());
            if ("JAVA_MODULE".equals(module2.getModuleTypeName()) && ExternalSystemApiUtil.isJavaCompatibleIde()) {
                this.setLanguageLevel(modifiableRootModel, (ModuleData)node.getData());
            }
            this.setSdk(modifiableRootModel, (ModuleData)node.getData());
        }
        for (DataNode<E> node : toImport) {
            module2 = (Module)node.getUserData(MODULE_KEY);
            if (module2 == null) continue;
            String[] groupPath = ((ModuleData)node.getData()).getIdeModuleGroup();
            ModifiableModuleModel modifiableModel = modelsProvider.getModifiableModuleModel();
            modifiableModel.setModuleGroupPath(module2, groupPath);
        }
    }

    private void createModules(@NotNull Collection<DataNode<E>> toCreate, @NotNull IdeModifiableModelsProvider modelsProvider) {
        for (DataNode<E> module2 : toCreate) {
            ModuleData data = (ModuleData)module2.getData();
            Module created = modelsProvider.newModule(data);
            module2.putUserData(MODULE_KEY, (Object)created);
            final ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(created);
            modifiableRootModel.inheritSdk();
            RootPolicy<Object> visitor = new RootPolicy<Object>(){

                public Object visitLibraryOrderEntry(@NotNull LibraryOrderEntry libraryOrderEntry, Object value) {
                    modifiableRootModel.removeOrderEntry((OrderEntry)libraryOrderEntry);
                    return value;
                }

                public Object visitModuleOrderEntry(@NotNull ModuleOrderEntry moduleOrderEntry, Object value) {
                    modifiableRootModel.removeOrderEntry((OrderEntry)moduleOrderEntry);
                    return value;
                }
            };
            for (OrderEntry orderEntry : modifiableRootModel.getOrderEntries()) {
                orderEntry.accept((RootPolicy)visitor, null);
            }
        }
    }

    @NotNull
    private Collection<DataNode<E>> filterExistingModules(@NotNull Collection<DataNode<E>> modules, @NotNull IdeModifiableModelsProvider modelsProvider) {
        ArrayList result = ContainerUtilRt.newArrayList();
        for (DataNode<E> node : modules) {
            ModuleData moduleData = (ModuleData)node.getData();
            Module module2 = modelsProvider.findIdeModule(moduleData);
            if (module2 == null) {
                UnloadedModuleDescription unloadedModuleDescription = modelsProvider.getUnloadedModuleDescription(moduleData);
                if (unloadedModuleDescription != null) continue;
                result.add(node);
                continue;
            }
            node.putUserData(MODULE_KEY, (Object)module2);
        }
        return result;
    }

    private static void syncPaths(@NotNull Module module2, @NotNull ModifiableRootModel modifiableModel, @NotNull ModuleData data) {
        CompilerModuleExtension extension = (CompilerModuleExtension)modifiableModel.getModuleExtension(CompilerModuleExtension.class);
        if (extension == null) {
            LOG.debug(String.format("No compiler extension is found for '%s', compiler output path will not be synced.", module2.getName()));
            return;
        }
        String compileOutputPath = data.getCompileOutputPath(ExternalSystemSourceType.SOURCE);
        extension.setCompilerOutputPath(compileOutputPath != null ? VfsUtilCore.pathToUrl((String)compileOutputPath) : null);
        String testCompileOutputPath = data.getCompileOutputPath(ExternalSystemSourceType.TEST);
        extension.setCompilerOutputPathForTests(testCompileOutputPath != null ? VfsUtilCore.pathToUrl((String)testCompileOutputPath) : null);
        extension.inheritCompilerOutputPath(data.isInheritProjectCompileOutputPath());
    }

    public void removeData(@NotNull Computable<Collection<Module>> toRemoveComputable, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Collection toRemove = (Collection)toRemoveComputable.compute();
        SmartList modules = new SmartList(toRemove);
        for (DataNode<E> moduleDataNode : toIgnore) {
            Module module2 = modelsProvider.findIdeModule((ModuleData)moduleDataNode.getData());
            ContainerUtil.addIfNotNull((Collection)modules, (Object)module2);
        }
        if (modules.isEmpty()) {
            return;
        }
        ContainerUtil.removeDuplicates((Collection)modules);
        for (Module module3 : modules) {
            if (module3.isDisposed()) continue;
            AbstractModuleDataService.unlinkModuleFromExternalSystem(module3);
        }
        ExternalSystemApiUtil.executeOnEdt((boolean)true, () -> AbstractModuleDataService.lambda$removeData$0(project2, projectData, (List)modules, modelsProvider));
    }

    public void onSuccessImport(@NotNull Collection<DataNode<E>> imported, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModelsProvider modelsProvider) {
        Set orphanModules = (Set)project2.getUserData(ORPHAN_MODULE_FILES);
        if (orphanModules == null || orphanModules.isEmpty()) {
            return;
        }
        AtomicInteger counter = (AtomicInteger)project2.getUserData(ORPHAN_MODULE_HANDLERS_COUNTER);
        if (counter == null) {
            return;
        }
        if (counter.decrementAndGet() == 0) {
            project2.putUserData(ORPHAN_MODULE_FILES, null);
            project2.putUserData(ORPHAN_MODULE_HANDLERS_COUNTER, null);
            StringBuilder modulesToRestoreText = new StringBuilder();
            ArrayList modulesToRestore = ContainerUtil.newArrayList();
            for (Path modulePath : orphanModules) {
                try {
                    String path = FileUtil.loadFile((File)modulePath.resolveSibling(modulePath.getFileName() + ".path").toFile());
                    modulesToRestoreText.append(FileUtil.getNameWithoutExtension((File)new File(path))).append("\n");
                    modulesToRestore.add(Pair.create((Object)path, (Object)modulePath));
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
            String buildSystem = projectData != null ? projectData.getOwner().getReadableName() : "build system";
            String content = ExternalSystemBundle.message((String)"orphan.modules.text", (Object[])new Object[]{buildSystem, StringUtil.shortenTextWithEllipsis((String)modulesToRestoreText.toString(), (int)50, (int)0)});
            Notification cleanUpNotification = ORPHAN_MODULE_NOTIFICATION_GROUP.createNotification(content, NotificationType.INFORMATION).setListener((notification, event) -> {
                if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                if (AbstractModuleDataService.showRemovedOrphanModules(modulesToRestore, project2)) {
                    notification.expire();
                }
            }).whenExpired(() -> {
                List filesToRemove = ContainerUtil.map((Collection)orphanModules, Path::toFile);
                List toRemove2 = ContainerUtil.map((Collection)orphanModules, path -> path.resolveSibling(path.getFileName() + ".path").toFile());
                FileUtil.asyncDelete((Collection)ContainerUtil.concat((List)filesToRemove, (List)toRemove2));
            });
            Disposer.register((Disposable)project2, () -> ((Notification)cleanUpNotification).expire());
            cleanUpNotification.notify(project2);
        }
    }

    public void onFailureImport(Project project2) {
        project2.putUserData(ORPHAN_MODULE_FILES, null);
        project2.putUserData(ORPHAN_MODULE_HANDLERS_COUNTER, null);
    }

    private static boolean showRemovedOrphanModules(final @NotNull List<Pair<String, Path>> orphanModules, @NotNull Project project2) {
        final CheckBoxList orphanModulesList = new CheckBoxList();
        DialogWrapper dialog = new DialogWrapper(project2){
            {
                super(x0);
                this.setTitle(ExternalSystemBundle.message((String)"orphan.modules.dialog.title", (Object[])new Object[0]));
                this.init();
            }

            protected JComponent createCenterPanel() {
                orphanModulesList.setSelectionMode(2);
                orphanModulesList.setItems(orphanModules, module2 -> FileUtil.getNameWithoutExtension((File)new File((String)module2.getFirst())));
                orphanModulesList.setBorder(JBUI.Borders.empty((int)5));
                JScrollPane myModulesScrollPane = ScrollPaneFactory.createScrollPane((Component)orphanModulesList, (int)20, (int)30);
                myModulesScrollPane.setBorder(new MatteBorder(0, 0, 1, 0, JBColor.border()));
                myModulesScrollPane.setMaximumSize(new Dimension(-1, 300));
                JPanel content = new JPanel(new BorderLayout());
                content.add((Component)myModulesScrollPane, "Center");
                return content;
            }

            @NotNull
            protected JComponent createNorthPanel() {
                GridBagConstraints gbConstraints = new GridBagConstraints();
                JPanel panel = new JPanel(new GridBagLayout());
                gbConstraints.insets = JBUI.insets((int)4, (int)0, (int)10, (int)8);
                panel.add((Component)new JLabel(ExternalSystemBundle.message((String)"orphan.modules.dialog.text", (Object[])new Object[0])), gbConstraints);
                return panel;
            }
        };
        if (dialog.showAndGet()) {
            ExternalSystemApiUtil.doWriteAction(() -> {
                for (int i = 0; i < orphanModules.size(); ++i) {
                    Pair pair2 = (Pair)orphanModules.get(i);
                    String originalPath = (String)pair2.first;
                    Path savedPath = (Path)pair2.second;
                    if (!orphanModulesList.isItemSelected(i) || !savedPath.toFile().isFile()) continue;
                    try {
                        FileUtil.copy((File)savedPath.toFile(), (File)new File(originalPath));
                        ModuleManager.getInstance((Project)project2).loadModule(originalPath);
                        continue;
                    }
                    catch (ModuleWithNameAlreadyExists | IOException | JDOMException e) {
                        LOG.warn(e);
                    }
                }
            });
            return true;
        }
        return false;
    }

    public static void unlinkModuleFromExternalSystem(@NotNull Module module2) {
        ExternalSystemModulePropertyManager.getInstance((Module)module2).unlinkExternalOptions();
    }

    protected void setModuleOptions(Module module2, DataNode<E> moduleDataNode) {
        ModuleData moduleData = (ModuleData)moduleDataNode.getData();
        module2.putUserData(MODULE_DATA_KEY, (Object)moduleData);
        ExternalSystemModulePropertyManager.getInstance((Module)module2).setExternalOptions(moduleData.getOwner(), moduleData, (ProjectData)moduleDataNode.getData(ProjectKeys.PROJECT));
    }

    public void postProcess(@NotNull Collection<DataNode<E>> toImport, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        for (DataNode<E> moduleDataNode : toImport) {
            Module module2 = (Module)moduleDataNode.getUserData(MODULE_KEY);
            if (module2 == null) continue;
            Map orderAwareMap = (Map)moduleDataNode.getUserData(ORDERED_DATA_MAP_KEY);
            if (orderAwareMap != null) {
                this.rearrangeOrderEntries(orderAwareMap, modelsProvider.getModifiableRootModel(module2));
            }
            this.setBytecodeTargetLevel(project2, module2, (ModuleData)moduleDataNode.getData());
            moduleDataNode.putUserData(MODULE_KEY, null);
            moduleDataNode.putUserData(ORDERED_DATA_MAP_KEY, null);
        }
        for (Module module3 : modelsProvider.getModules()) {
            module3.putUserData(MODULE_DATA_KEY, null);
        }
    }

    protected void rearrangeOrderEntries(@NotNull Map<OrderEntry, OrderAware> orderEntryDataMap, @NotNull ModifiableRootModel modifiableRootModel) {
        Pair pair2;
        OrderAware orderAware;
        OrderEntry orderEntry;
        Object[] orderEntries = modifiableRootModel.getOrderEntries();
        int length = orderEntries.length;
        Object[] newOrder = new OrderEntry[length];
        PriorityQueue<Pair> priorityQueue = new PriorityQueue<Pair>(11, (o1, o2) -> {
            int order2;
            int order1 = ((OrderAware)o1.second).getOrder();
            return order1 != (order2 = ((OrderAware)o2.second).getOrder()) ? (order1 < order2 ? -1 : 1) : 0;
        });
        int shift = 0;
        for (int i = 0; i < length; ++i) {
            orderEntry = orderEntries[i];
            orderAware = orderEntryDataMap.get(orderEntry);
            if (orderAware == null) {
                newOrder[i] = orderEntry;
                ++shift;
                continue;
            }
            priorityQueue.add(Pair.create((Object)orderEntry, (Object)orderAware));
        }
        while ((pair2 = (Pair)priorityQueue.poll()) != null) {
            orderEntry = (OrderEntry)pair2.first;
            orderAware = (OrderAware)pair2.second;
            int order = orderAware.getOrder() != -1 ? orderAware.getOrder() : length - 1;
            int newPlace = AbstractModuleDataService.findNewPlace((OrderEntry[])newOrder, order - shift);
            assert (newPlace != -1);
            newOrder[newPlace] = orderEntry;
        }
        if (LOG.isDebugEnabled()) {
            boolean changed = !ArrayUtil.equals((Object[])orderEntries, (Object[])newOrder, Comparator.naturalOrder());
            LOG.debug(String.format("rearrange status (%s): %s", modifiableRootModel.getModule(), changed ? "modified" : "not modified"));
        }
        modifiableRootModel.rearrangeOrderEntries((OrderEntry[])newOrder);
    }

    private static int findNewPlace(OrderEntry[] newOrder, int newIndex) {
        int idx;
        for (idx = newIndex; idx < 0 || idx < newOrder.length && newOrder[idx] != null; ++idx) {
        }
        if (idx >= newOrder.length) {
            for (idx = newIndex - 1; idx >= 0 && (idx >= newOrder.length || newOrder[idx] != null); --idx) {
            }
        }
        return idx;
    }

    private void setLanguageLevel(@NotNull ModifiableRootModel modifiableRootModel, E data) {
        LanguageLevel level = LanguageLevel.parse((String)data.getSourceCompatibility());
        if (level != null) {
            try {
                ((LanguageLevelModuleExtension)modifiableRootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(level);
            }
            catch (IllegalArgumentException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    private void setSdk(@NotNull ModifiableRootModel modifiableRootModel, E data) {
        String skdName = data.getSdkName();
        if (skdName != null) {
            ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
            Sdk sdk = projectJdkTable.findJdk(skdName);
            if (sdk != null) {
                modifiableRootModel.setSdk(sdk);
            } else {
                modifiableRootModel.setInvalidSdk(skdName, JavaSdk.getInstance().getName());
            }
        }
    }

    private void setBytecodeTargetLevel(@NotNull Project project2, @NotNull Module module2, @NotNull E data) {
        String targetLevel = data.getTargetCompatibility();
        if (targetLevel != null) {
            CompilerConfiguration configuration = CompilerConfiguration.getInstance((Project)project2);
            configuration.setBytecodeTargetLevel(module2, targetLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$removeData$0(Project project2, ProjectData projectData, List modules, IdeModifiableModelsProvider modelsProvider) {
        AtomicInteger counter = (AtomicInteger)project2.getUserData(ORPHAN_MODULE_HANDLERS_COUNTER);
        if (counter == null) {
            counter = new AtomicInteger();
            project2.putUserData(ORPHAN_MODULE_HANDLERS_COUNTER, (Object)counter);
        }
        counter.incrementAndGet();
        Set orphanModules = (Set)project2.getUserData(ORPHAN_MODULE_FILES);
        if (orphanModules == null) {
            orphanModules = ContainerUtil.newLinkedHashSet();
            project2.putUserData(ORPHAN_MODULE_FILES, (Object)orphanModules);
        }
        LocalHistoryAction historyAction = LocalHistory.getInstance().startAction(ExternalSystemBundle.message((String)"local.history.remove.orphan.modules", (Object[])new Object[0]));
        try {
            String rootProjectPathKey = String.valueOf(projectData.getLinkedExternalProjectPath().hashCode());
            Path unlinkedModulesDir = ExternalProjectsDataStorage.getProjectConfigurationDir(project2).resolve("orphanModules").resolve(rootProjectPathKey);
            if (!FileUtil.createDirectory((File)unlinkedModulesDir.toFile())) {
                LOG.warn("Unable to create " + unlinkedModulesDir);
                return;
            }
            AbstractExternalSystemLocalSettings localSettings = ExternalSystemApiUtil.getLocalSettings((Project)project2, (ProjectSystemId)projectData.getOwner());
            AbstractExternalSystemLocalSettings.SyncType syncType = (AbstractExternalSystemLocalSettings.SyncType)localSettings.getProjectSyncType().get(projectData.getLinkedExternalProjectPath());
            for (Module module2 : modules) {
                if (module2.isDisposed()) continue;
                String path = module2.getModuleFilePath();
                if (!ApplicationManager.getApplication().isHeadlessEnvironment() && syncType == AbstractExternalSystemLocalSettings.SyncType.RE_IMPORT) {
                    try {
                        StateStorageManagerKt.saveComponentManager((ComponentManager)module2);
                        VirtualFile moduleFile = module2.getModuleFile();
                        if (moduleFile != null) {
                            Path orphanModulePath = unlinkedModulesDir.resolve(String.valueOf(path.hashCode()));
                            FileUtil.writeToFile((File)orphanModulePath.toFile(), (byte[])moduleFile.contentsToByteArray());
                            Path orphanModuleOriginPath = unlinkedModulesDir.resolve(path.hashCode() + ".path");
                            FileUtil.writeToFile((File)orphanModuleOriginPath.toFile(), (String)path);
                            orphanModules.add(orphanModulePath);
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Throwable)e);
                    }
                }
                modelsProvider.getModifiableModuleModel().disposeModule(module2);
                ModuleBuilder.deleteModuleFile((String)path);
            }
        }
        finally {
            historyAction.finish();
        }
    }
}

