/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.SourceFolderManager;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Order(value=-2147483618)
public class ContentRootDataService
extends AbstractProjectDataService<ContentRootData, ContentEntry> {
    public static final com.intellij.openapi.util.Key<Boolean> CREATE_EMPTY_DIRECTORIES = com.intellij.openapi.util.Key.create((String)"createEmptyDirectories");
    private static final Logger LOG = Logger.getInstance(ContentRootDataService.class);

    @NotNull
    public Key<ContentRootData> getTargetDataKey() {
        return ProjectKeys.CONTENT_ROOT;
    }

    public void importData(@NotNull Collection<DataNode<ContentRootData>> toImport, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        ContentRootDataService.logUnitTest("Importing data. Data size is [" + toImport.size() + "]");
        if (toImport.isEmpty()) {
            return;
        }
        SourceFolderManager sourceFolderManager = SourceFolderManager.getInstance((Project)project2);
        boolean isNewlyImportedProject = project2.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) == Boolean.TRUE;
        boolean forceDirectoriesCreation = false;
        DataNode projectDataNode = ExternalSystemApiUtil.findParent(toImport.iterator().next(), (Key)ProjectKeys.PROJECT);
        if (projectDataNode != null) {
            forceDirectoriesCreation = projectDataNode.getUserData(CREATE_EMPTY_DIRECTORIES) == Boolean.TRUE;
        }
        THashSet modulesToExpand = ContainerUtil.newTroveSet();
        MultiMap byModule = ExternalSystemApiUtil.groupBy(toImport, ModuleData.class);
        ContentRootDataService.filterAndReportDuplicatingContentRoots((MultiMap<DataNode<ModuleData>, DataNode<ContentRootData>>)byModule, project2);
        for (Map.Entry entry : byModule.entrySet()) {
            Module module2 = (Module)((DataNode)entry.getKey()).getUserData(AbstractModuleDataService.MODULE_KEY);
            Module module3 = module2 = module2 != null ? module2 : modelsProvider.findIdeModule((ModuleData)((DataNode)entry.getKey()).getData());
            if (module2 == null) {
                LOG.warn(String.format("Can't import content roots. Reason: target module (%s) is not found at the ide. Content roots: %s", entry.getKey(), entry.getValue()));
                continue;
            }
            ContentRootDataService.importData(modelsProvider, sourceFolderManager, (Collection)entry.getValue(), module2, forceDirectoriesCreation);
            if (!forceDirectoriesCreation && (!isNewlyImportedProject || projectData == null || !projectData.getLinkedExternalProjectPath().equals(ExternalSystemApiUtil.getExternalProjectPath((Module)module2)))) continue;
            modulesToExpand.add(module2);
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !modulesToExpand.isEmpty()) {
            for (Module module4 : modulesToExpand) {
                VirtualFile[] roots;
                String productionModuleName = modelsProvider.getProductionModuleName(module4);
                if (productionModuleName != null && modulesToExpand.contains(modelsProvider.findIdeModule(productionModuleName)) || (roots = modelsProvider.getModifiableRootModel(module4).getContentRoots()).length <= 0) continue;
                VirtualFile virtualFile = roots[0];
                ExternalSystemUtil.invokeLater(project2, ModalityState.NON_MODAL, () -> StartupManager.getInstance((Project)project2).runWhenProjectIsInitialized(() -> {
                    ProjectView projectView = ProjectView.getInstance((Project)project2);
                    projectView.changeViewCB("ProjectPane", null).doWhenProcessed(() -> projectView.selectCB(null, virtualFile, false));
                }));
            }
        }
    }

    private static void importData(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull SourceFolderManager sourceFolderManager, @NotNull Collection<? extends DataNode<ContentRootData>> data, @NotNull Module module2, boolean forceDirectoriesCreation) {
        ContentRootDataService.logUnitTest("Import data for module [" + module2.getName() + "], data size [" + data.size() + "]");
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module2);
        ContentEntry[] contentEntries = modifiableRootModel.getContentEntries();
        HashMap contentEntriesMap = ContainerUtilRt.newHashMap();
        for (ContentEntry contentEntry : contentEntries) {
            contentEntriesMap.put(contentEntry.getUrl(), contentEntry);
        }
        boolean createEmptyContentRootDirectories = forceDirectoriesCreation;
        if (!forceDirectoriesCreation && !data.isEmpty()) {
            ProjectSystemId projectSystemId = ((ContentRootData)data.iterator().next().getData()).getOwner();
            AbstractExternalSystemSettings externalSystemSettings = ExternalSystemApiUtil.getSettings((Project)module2.getProject(), (ProjectSystemId)projectSystemId);
            String string = ExternalSystemModulePropertyManager.getInstance((Module)module2).getRootProjectPath();
            if (string != null) {
                ExternalProjectSettings projectSettings = externalSystemSettings.getLinkedProjectSettings(string);
                createEmptyContentRootDirectories = projectSettings != null && projectSettings.isCreateEmptyContentRootDirectories();
            }
        }
        sourceFolderManager.removeSourceFolders(module2);
        THashSet importedContentEntries = ContainerUtil.newIdentityTroveSet();
        for (DataNode<ContentRootData> dataNode : data) {
            ContentRootData contentRoot = (ContentRootData)dataNode.getData();
            ContentEntry contentEntry = ContentRootDataService.findOrCreateContentRoot(modifiableRootModel, contentRoot.getRootPath());
            if (!importedContentEntries.contains(contentEntry)) {
                ContentRootDataService.removeSourceFoldersIfAbsent(contentEntry, contentRoot);
                importedContentEntries.add(contentEntry);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Importing content root '%s' for module '%s'", contentRoot.getRootPath(), module2.getName()));
            }
            for (ExternalSystemSourceType externalSrcType : ExternalSystemSourceType.values()) {
                JpsModuleSourceRootType<?> type = ContentRootDataService.getJavaSourceRootType(externalSrcType);
                if (type == null) continue;
                for (ContentRootData.SourceRoot path : contentRoot.getPaths(externalSrcType)) {
                    ContentRootDataService.createSourceRootIfAbsent(sourceFolderManager, contentEntry, path, module2, type, externalSrcType.isGenerated(), createEmptyContentRootDirectories);
                }
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.EXCLUDED)) {
                ContentRootDataService.createExcludedRootIfAbsent(contentEntry, path, module2.getName(), module2.getProject());
            }
            contentEntriesMap.remove(contentEntry.getUrl());
        }
        for (ContentEntry contentEntry : contentEntriesMap.values()) {
            modifiableRootModel.removeContentEntry(contentEntry);
        }
    }

    @Nullable
    private static JpsModuleSourceRootType<?> getJavaSourceRootType(ExternalSystemSourceType type) {
        switch (type) {
            case SOURCE: {
                return JavaSourceRootType.SOURCE;
            }
            case TEST: {
                return JavaSourceRootType.TEST_SOURCE;
            }
            case EXCLUDED: {
                return null;
            }
            case SOURCE_GENERATED: {
                return JavaSourceRootType.SOURCE;
            }
            case TEST_GENERATED: {
                return JavaSourceRootType.TEST_SOURCE;
            }
            case RESOURCE: {
                return JavaResourceRootType.RESOURCE;
            }
            case TEST_RESOURCE: {
                return JavaResourceRootType.TEST_RESOURCE;
            }
        }
        return null;
    }

    @NotNull
    private static ContentEntry findOrCreateContentRoot(@NotNull ModifiableRootModel model, @NotNull String path) {
        ContentEntry[] entries2;
        for (ContentEntry entry : entries2 = model.getContentEntries()) {
            VirtualFile file = entry.getFile();
            if (file == null || !ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file).equals(path)) continue;
            return entry;
        }
        return model.addContentEntry(VfsUtilCore.pathToUrl((String)path));
    }

    private static Set<String> getSourceRoots(@NotNull ContentRootData contentRoot) {
        THashSet sourceRoots = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        for (ExternalSystemSourceType externalSrcType : ExternalSystemSourceType.values()) {
            JpsModuleSourceRootType<?> type = ContentRootDataService.getJavaSourceRootType(externalSrcType);
            if (type == null) continue;
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(externalSrcType)) {
                if (path == null) continue;
                sourceRoots.add(path.getPath());
            }
        }
        return sourceRoots;
    }

    private static void removeSourceFoldersIfAbsent(@NotNull ContentEntry contentEntry, @NotNull ContentRootData contentRoot) {
        SourceFolder[] sourceFolders;
        Set<String> sourceRoots = ContentRootDataService.getSourceRoots(contentRoot);
        for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
            String url = sourceFolder.getUrl();
            String path = VfsUtilCore.urlToPath((String)url);
            if (sourceRoots.contains(path)) continue;
            contentEntry.removeSourceFolder(sourceFolder);
        }
    }

    private static void createSourceRootIfAbsent(@NotNull SourceFolderManager sourceFolderManager, @NotNull ContentEntry entry, @NotNull ContentRootData.SourceRoot root, @NotNull Module module2, @NotNull JpsModuleSourceRootType<?> sourceRootType, boolean generated, boolean createEmptyContentRootDirectories) {
        JavaSourceRootProperties properties;
        SourceFolder[] folders;
        ContentRootDataService.logUnitTest("create source root if absent entry.url=[" + entry.getUrl() + "] root.path=[" + root.getPath() + "] generated=[" + generated + "] createEmptyContentRootDirectories=[" + createEmptyContentRootDirectories + "]");
        for (SourceFolder folder : folders = entry.getSourceFolders()) {
            VirtualFile file = folder.getFile();
            if (file == null || !ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file).equals(root.getPath())) continue;
            JpsModuleSourceRootType folderRootType = folder.getRootType();
            if (JavaSourceRootType.SOURCE.equals(folderRootType) || sourceRootType.equals((Object)folderRootType)) {
                return;
            }
            if (JavaSourceRootType.TEST_SOURCE.equals(folderRootType) && JavaResourceRootType.TEST_RESOURCE.equals(sourceRootType)) {
                return;
            }
            entry.removeSourceFolder(folder);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Importing %s for content root '%s' of module '%s'", root, entry.getUrl(), module2.getName()));
        }
        if (!(createEmptyContentRootDirectories || generated || FileUtil.exists((String)root.getPath()))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Source folder [" + root.getPath() + "] does not exist and will not be created, will add when dir is created");
            }
            ContentRootDataService.logUnitTest("Adding source folder listener to watch [" + root.getPath() + "] for creation in project [hashCode=" + module2.getProject().hashCode() + "]");
            String url = VfsUtilCore.pathToUrl((String)root.getPath());
            String packagePrefix = StringUtil.notNullize((String)root.getPackagePrefix());
            sourceFolderManager.addSourceFolder(module2, url, sourceRootType, packagePrefix);
            return;
        }
        SourceFolder sourceFolder = entry.addSourceFolder(VfsUtilCore.pathToUrl((String)root.getPath()), sourceRootType);
        if (!StringUtil.isEmpty((String)root.getPackagePrefix())) {
            sourceFolder.setPackagePrefix(root.getPackagePrefix());
        }
        if (generated && (properties = (JavaSourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES)) != null) {
            properties.setForGeneratedSources(true);
        }
        if (createEmptyContentRootDirectories && !FileUtil.exists((String)root.getPath())) {
            ExternalSystemApiUtil.doWriteAction(() -> {
                try {
                    VfsUtil.createDirectoryIfMissing((String)root.getPath());
                }
                catch (IOException e) {
                    LOG.warn(String.format("Unable to create directory for the path: %s", root.getPath()), (Throwable)e);
                }
            });
        }
    }

    private static void logUnitTest(String message) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.info(message);
        }
    }

    private static void createExcludedRootIfAbsent(@NotNull ContentEntry entry, @NotNull ContentRootData.SourceRoot root, @NotNull String moduleName, @NotNull Project project2) {
        String rootPath = root.getPath();
        for (VirtualFile file : entry.getExcludeFolderFiles()) {
            if (!ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file).equals(rootPath)) continue;
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Importing excluded root '%s' for content root '%s' of module '%s'", root, entry.getUrl(), moduleName));
        }
        entry.addExcludeFolder(VfsUtilCore.pathToUrl((String)rootPath));
        if (!Registry.is((String)"ide.hide.excluded.files")) {
            ChangeListManager.getInstance((Project)project2).addDirectoryToIgnoreImplicitly(rootPath);
        }
    }

    private static void filterAndReportDuplicatingContentRoots(@NotNull MultiMap<DataNode<ModuleData>, DataNode<ContentRootData>> moduleNodeToRootNodes, @NotNull Project project2) {
        String notificationMessage;
        LinkedHashMap filter = ContainerUtil.newLinkedHashMap();
        for (Map.Entry entry : moduleNodeToRootNodes.entrySet()) {
            ModuleData moduleData = (ModuleData)((DataNode)entry.getKey()).getData();
            Collection crDataNodes = (Collection)entry.getValue();
            Iterator iterator2 = crDataNodes.iterator();
            while (iterator2.hasNext()) {
                DataNode crDataNode = (DataNode)iterator2.next();
                String rootPath = ((ContentRootData)crDataNode.getData()).getRootPath();
                DuplicateModuleReport report = filter.putIfAbsent(rootPath, new DuplicateModuleReport(moduleData));
                if (report == null) continue;
                report.addDuplicate(moduleData);
                iterator2.remove();
                crDataNode.clear(true);
            }
        }
        Map toReport = filter.entrySet().stream().filter(e -> ((DuplicateModuleReport)e.getValue()).hasDuplicates()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (r1, r2) -> {
            LOG.warn("Unexpected duplicates in keys while collecting filtered reports");
            return r2;
        }, LinkedHashMap::new));
        if (!toReport.isEmpty() && (notificationMessage = ContentRootDataService.prepareMessageAndLogWarnings(toReport)) != null) {
            ContentRootDataService.showNotificationsPopup(project2, toReport.size(), notificationMessage);
        }
    }

    @Nullable
    private static String prepareMessageAndLogWarnings(@NotNull Map<String, DuplicateModuleReport> toReport) {
        String firstMessage = null;
        LOG.warn("Duplicating content roots detected.");
        for (Map.Entry<String, DuplicateModuleReport> entry : toReport.entrySet()) {
            String path = entry.getKey();
            DuplicateModuleReport report = entry.getValue();
            String message = String.format("Path [%s] of module [%s] was removed from modules [%s]", path, report.getOriginalName(), StringUtil.join(report.getDuplicatesNames(), (String)", "));
            if (firstMessage == null) {
                firstMessage = message;
            }
            LOG.warn(message);
        }
        return firstMessage;
    }

    private static void showNotificationsPopup(@NotNull Project project2, int reportsCount, @NotNull String notificationMessage) {
        int extraReportsCount = reportsCount - 1;
        if (extraReportsCount > 0) {
            notificationMessage = notificationMessage + "<br>Also " + extraReportsCount + " more " + StringUtil.pluralize((String)"path", (int)extraReportsCount) + " " + (extraReportsCount == 1 ? "was" : "were") + " deduplicated. See idea log for details";
        }
        Notification notification = new Notification("Content root duplicates", "Duplicate content roots detected", notificationMessage, NotificationType.WARNING);
        Notifications.Bus.notify((Notification)notification, (Project)project2);
    }

    private static class DuplicateModuleReport {
        private final ModuleData myOriginal;
        private final List<ModuleData> myDuplicates = new ArrayList<ModuleData>();

        public DuplicateModuleReport(@NotNull ModuleData original) {
            this.myOriginal = original;
        }

        public void addDuplicate(@NotNull ModuleData duplicate) {
            this.myDuplicates.add(duplicate);
        }

        public boolean hasDuplicates() {
            return !this.myDuplicates.isEmpty();
        }

        public String getOriginalName() {
            return this.myOriginal.getInternalName();
        }

        public Collection<String> getDuplicatesNames() {
            return ContainerUtil.map(this.myDuplicates, AbstractNamedData::getInternalName);
        }
    }
}

