/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483638)
public class ModuleDataService
extends AbstractModuleDataService<ModuleData> {
    @NotNull
    public Key<ModuleData> getTargetDataKey() {
        return ProjectKeys.MODULE;
    }

    @NotNull
    public Computable<Collection<Module>> computeOrphanData(@NotNull Collection<DataNode<ModuleData>> toImport, @NotNull ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        return () -> {
            List orphanIdeModules = ContainerUtil.newSmartList();
            for (Module module2 : modelsProvider.getModules()) {
                if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData.getOwner(), (Module)module2) || ExternalSystemApiUtil.getExternalModuleType((Module)module2) != null) continue;
                String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2);
                if (!projectData.getLinkedExternalProjectPath().equals(rootProjectPath) || module2.getUserData(AbstractModuleDataService.MODULE_DATA_KEY) != null) continue;
                orphanIdeModules.add(module2);
            }
            return orphanIdeModules;
        };
    }

    @Override
    public void postProcess(@NotNull Collection<DataNode<ModuleData>> toImport, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        super.postProcess(toImport, projectData, project2, modelsProvider);
        ModuleDataService.updateLocalSettings(toImport, project2);
    }

    private static void updateLocalSettings(Collection<DataNode<ModuleData>> toImport, Project project2) {
        if (toImport.isEmpty()) {
            return;
        }
        ProjectSystemId externalSystemId = ((ModuleData)toImport.iterator().next().getData()).getOwner();
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        MultiMap grouped = ExternalSystemApiUtil.groupBy(toImport, (Key)ProjectKeys.PROJECT);
        HashMap data = ContainerUtilRt.newHashMap();
        for (Map.Entry entry : grouped.entrySet()) {
            data.put(ExternalProjectPojo.from((Named)((Named)((DataNode)entry.getKey()).getData())), ContainerUtilRt.map2List((Collection)((Collection)entry.getValue()), node -> ExternalProjectPojo.from((Named)((Named)node.getData()))));
        }
        AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project2);
        Set<String> pathsToForget = ModuleDataService.detectRenamedProjects(data, settings.getAvailableProjects());
        if (!pathsToForget.isEmpty()) {
            settings.forgetExternalProjects(pathsToForget);
        }
        HashMap projects = ContainerUtilRt.newHashMap((Map)settings.getAvailableProjects());
        projects.putAll(data);
        settings.setAvailableProjects((Map)projects);
    }

    @NotNull
    private static Set<String> detectRenamedProjects(@NotNull Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> currentInfo, @NotNull Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> oldInfo) {
        HashMap map2 = ContainerUtilRt.newHashMap();
        for (Map.Entry<ExternalProjectPojo, Collection<ExternalProjectPojo>> entry : currentInfo.entrySet()) {
            map2.put(entry.getKey().getPath(), entry.getKey().getName());
            for (ExternalProjectPojo pojo : entry.getValue()) {
                map2.put(pojo.getPath(), pojo.getName());
            }
        }
        HashSet result = ContainerUtilRt.newHashSet();
        for (Map.Entry<ExternalProjectPojo, Collection<ExternalProjectPojo>> entry : oldInfo.entrySet()) {
            String newName = (String)map2.get(entry.getKey().getPath());
            if (newName != null && !newName.equals(entry.getKey().getName())) {
                result.add(entry.getKey().getPath());
            }
            for (ExternalProjectPojo pojo : entry.getValue()) {
                newName = (String)map2.get(pojo.getPath());
                if (newName == null || newName.equals(pojo.getName())) continue;
                result.add(pojo.getPath());
            }
        }
        return result;
    }
}

