/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.PerformanceTrace;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.DeduplicateVisitorsSupplier;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectDataManagerImpl
implements ProjectDataManager {
    private static final Logger LOG = Logger.getInstance(ProjectDataManagerImpl.class);
    private static final com.intellij.openapi.util.Key<Boolean> DATA_READY = com.intellij.openapi.util.Key.create((String)"externalSystem.data.ready");
    @NotNull
    private final NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>> myServices;

    public static ProjectDataManagerImpl getInstance() {
        ProjectDataManager service = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
        return (ProjectDataManagerImpl)service;
    }

    public ProjectDataManagerImpl() {
        this(() -> (ProjectDataService[])ProjectDataService.EP_NAME.getExtensions());
    }

    ProjectDataManagerImpl(ProjectDataService ... dataServices) {
        this(() -> dataServices);
    }

    private ProjectDataManagerImpl(final Supplier<ProjectDataService[]> supplier) {
        this.myServices = new NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>>(){

            @NotNull
            protected Map<Key<?>, List<ProjectDataService<?, ?>>> compute() {
                HashMap result = ContainerUtilRt.newHashMap();
                for (ProjectDataService service : (ProjectDataService[])supplier.get()) {
                    List services = (List)result.get(service.getTargetDataKey());
                    if (services == null) {
                        services = ContainerUtilRt.newArrayList();
                        result.put(service.getTargetDataKey(), services);
                    }
                    services.add(service);
                }
                for (List services : result.values()) {
                    ExternalSystemApiUtil.orderAwareSort((List)services);
                }
                return result;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(@NotNull Collection<DataNode<?>> nodes, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        PerformanceTrace trace;
        ProjectSystemId projectSystemId;
        ProjectData projectData;
        if (project2.isDisposed()) {
            return;
        }
        MultiMap grouped = ExternalSystemApiUtil.recursiveGroup(nodes);
        Collection projects = grouped.get((Object)ProjectKeys.PROJECT);
        assert (projects.size() == 1 || projects.isEmpty());
        DataNode projectNode = (DataNode)ContainerUtil.getFirstItem((Collection)projects);
        if (projectNode != null) {
            projectData = (ProjectData)projectNode.getData();
            projectSystemId = ((ProjectData)projectNode.getData()).getOwner();
            ExternalProjectsDataStorage.getInstance(project2).saveInclusionSettings((DataNode<ProjectData>)projectNode);
        } else {
            projectData = null;
            DataNode aModuleNode = (DataNode)ContainerUtil.getFirstItem((Collection)grouped.get((Object)ProjectKeys.MODULE));
            ProjectSystemId projectSystemId2 = projectSystemId = aModuleNode != null ? ((ModuleData)aModuleNode.getData()).getOwner() : null;
        }
        if (projectSystemId != null) {
            ExternalSystemUtil.scheduleExternalViewStructureUpdate(project2, projectSystemId);
        }
        List onSuccessImportTasks = ContainerUtil.newSmartList();
        List onFailureImportTasks = ContainerUtil.newSmartList();
        Collection traceNodes = grouped.get(PerformanceTrace.TRACE_NODE_KEY);
        if (traceNodes.size() > 0) {
            trace = (PerformanceTrace)((DataNode)traceNodes.iterator().next()).getData();
        } else {
            trace = new PerformanceTrace();
            grouped.putValue(PerformanceTrace.TRACE_NODE_KEY, (Object)new DataNode(PerformanceTrace.TRACE_NODE_KEY, (Object)trace, null));
        }
        long allStartTime = System.currentTimeMillis();
        try {
            TreeSet allKeys = new TreeSet(grouped.keySet());
            allKeys.addAll(((Map)this.myServices.getValue()).keySet());
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setIndeterminate(false);
            }
            int size = allKeys.size();
            int count = 0;
            List postImportTasks = ContainerUtil.newSmartList();
            for (Key key : allKeys) {
                if (indicator != null) {
                    String message = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{projectSystemId != null ? projectSystemId.getReadableName() : "", "Refresh " + ProjectDataManagerImpl.getReadableText(key)});
                    indicator.setText(message);
                    indicator.setFraction((double)count++ / (double)size);
                }
                long startTime = System.currentTimeMillis();
                this.doImportData(key, grouped.get((Object)key), projectData, project2, modelsProvider, postImportTasks, onSuccessImportTasks, onFailureImportTasks);
                trace.logPerformance("Data import by " + key.toString(), System.currentTimeMillis() - startTime);
            }
            for (Runnable postImportTask : postImportTasks) {
                postImportTask.run();
            }
            ProjectDataManagerImpl.commit(modelsProvider, project2, synchronous, "Imported data");
            if (indicator != null) {
                indicator.setIndeterminate(true);
            }
            ((ProjectDataImportListener)project2.getMessageBus().syncPublisher(ProjectDataImportListener.TOPIC)).onImportFinished(projectData != null ? projectData.getLinkedExternalProjectPath() : null);
            trace.logPerformance("Data import total", System.currentTimeMillis() - allStartTime);
        }
        catch (Throwable t) {
            try {
                ProjectDataManagerImpl.runFinalTasks(project2, synchronous, onFailureImportTasks);
                ProjectDataManagerImpl.dispose(modelsProvider, project2, synchronous);
            }
            finally {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
            }
        }
        ProjectDataManagerImpl.runFinalTasks(project2, synchronous, onSuccessImportTasks);
    }

    private static void runFinalTasks(@NotNull Project project2, boolean synchronous, final List<Runnable> tasks2) {
        DisposeAwareProjectChange runnable = new DisposeAwareProjectChange((ComponentManager)project2){

            public void execute() {
                for (Runnable task : ContainerUtil.reverse((List)tasks2)) {
                    task.run();
                }
            }
        };
        if (synchronous) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        } else {
            ApplicationManager.getApplication().invokeLater((Runnable)runnable);
        }
    }

    @NotNull
    private static String getReadableText(@NotNull Key key) {
        StringBuilder buffer = new StringBuilder();
        String s = key.toString();
        for (int i = 0; i < s.length(); ++i) {
            char currChar = s.charAt(i);
            if (Character.isUpperCase(currChar)) {
                if (i != 0) {
                    buffer.append(' ');
                }
                buffer.append(StringUtil.toLowerCase((char)currChar));
                continue;
            }
            buffer.append(currChar);
        }
        return buffer.toString();
    }

    public <T> void importData(@NotNull Collection<DataNode<T>> nodes, @NotNull Project project2, boolean synchronous) {
        List dummy = ContainerUtil.newSmartList();
        dummy.addAll(nodes);
        this.importData(dummy, project2, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project2), synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        List dummy = ContainerUtil.newSmartList();
        dummy.add(node);
        this.importData(dummy, project2, modelsProvider, synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project2, boolean synchronous) {
        this.importData(node, project2, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project2), synchronous);
    }

    private <T> void doImportData(@NotNull Key<T> key, @NotNull Collection<DataNode<?>> nodes, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modifiableModelsProvider2, @NotNull List<Runnable> postImportTasks, @NotNull List<Runnable> onSuccessImportTasks, @NotNull List<Runnable> onFailureImportTasks) {
        if (project2.isDisposed()) {
            return;
        }
        if (project2 instanceof ComponentManagerImpl) assert (((ComponentManagerImpl)project2).isComponentsCreated());
        List toImport = ContainerUtil.newSmartList();
        List toIgnore = ContainerUtil.newSmartList();
        for (DataNode<?> node : nodes) {
            if (!key.equals((Object)node.getKey())) continue;
            if (node.isIgnored()) {
                toIgnore.add(node);
                continue;
            }
            toImport.add(node);
        }
        this.ensureTheDataIsReadyToUse(toImport);
        List services = (List)((Map)this.myServices.getValue()).get(key);
        if (services == null) {
            LOG.debug(String.format("No data service is registered for %s", key));
        } else {
            for (ProjectDataService service : services) {
                long importStartTime = System.currentTimeMillis();
                service.importData((Collection)toImport, projectData, project2, modifiableModelsProvider2);
                if (LOG.isDebugEnabled()) {
                    long importTimeInMs = System.currentTimeMillis() - importStartTime;
                    LOG.debug(String.format("Service %s imported data in %d ms", service.getClass().getSimpleName(), importTimeInMs));
                }
                if (projectData == null) continue;
                this.ensureTheDataIsReadyToUse(toIgnore);
                long removeStartTime = System.currentTimeMillis();
                Computable orphanIdeDataComputable = service.computeOrphanData((Collection)toImport, projectData, project2, modifiableModelsProvider2);
                service.removeData(orphanIdeDataComputable, (Collection)toIgnore, projectData, project2, modifiableModelsProvider2);
                if (!LOG.isDebugEnabled()) continue;
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s computed and removed data in %d ms", service.getClass().getSimpleName(), removeTimeInMs));
            }
        }
        if (services != null && projectData != null) {
            postImportTasks.add(() -> {
                for (ProjectDataService service : services) {
                    if (!(service instanceof AbstractProjectDataService)) continue;
                    long taskStartTime = System.currentTimeMillis();
                    ((AbstractProjectDataService)service).postProcess((Collection)toImport, projectData, project2, modifiableModelsProvider2);
                    if (!LOG.isDebugEnabled()) continue;
                    long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                    LOG.debug(String.format("Service %s run post import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                }
            });
            onFailureImportTasks.add(() -> {
                for (ProjectDataService service : services) {
                    if (!(service instanceof AbstractProjectDataService)) continue;
                    long taskStartTime = System.currentTimeMillis();
                    ((AbstractProjectDataService)service).onFailureImport(project2);
                    if (!LOG.isDebugEnabled()) continue;
                    long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                    LOG.debug(String.format("Service %s run failure import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                }
            });
            onSuccessImportTasks.add(() -> {
                IdeModelsProviderImpl modelsProvider = new IdeModelsProviderImpl(project2);
                for (ProjectDataService service : services) {
                    if (!(service instanceof AbstractProjectDataService)) continue;
                    long taskStartTime = System.currentTimeMillis();
                    ((AbstractProjectDataService)service).onSuccessImport((Collection)toImport, projectData, project2, (IdeModelsProvider)modelsProvider);
                    if (!LOG.isDebugEnabled()) continue;
                    long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                    LOG.debug(String.format("Service %s run success import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                }
            });
        }
    }

    public void ensureTheDataIsReadyToUse(@Nullable DataNode startNode) {
        if (startNode == null) {
            return;
        }
        if (Boolean.TRUE.equals(startNode.getUserData(DATA_READY))) {
            return;
        }
        DeduplicateVisitorsSupplier supplier = new DeduplicateVisitorsSupplier();
        ExternalSystemApiUtil.visit((DataNode)startNode, dataNode -> {
            if (this.prepareDataToUse((DataNode)dataNode)) {
                dataNode.visitData(supplier.getVisitor(dataNode.getKey()));
                dataNode.putUserData(DATA_READY, (Object)Boolean.TRUE);
            }
        });
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> toRemove, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        try {
            List services = (List)((Map)this.myServices.getValue()).get(key);
            for (ProjectDataService service : services) {
                long removeStartTime = System.currentTimeMillis();
                service.removeData((Computable)new Computable.PredefinedValueComputable(toRemove), toIgnore, projectData, project2, modelsProvider);
                if (!LOG.isDebugEnabled()) continue;
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s removed data in %d ms", service.getClass().getSimpleName(), removeTimeInMs));
            }
            ProjectDataManagerImpl.commit(modelsProvider, project2, synchronous, "Removed data");
        }
        catch (Throwable t) {
            ProjectDataManagerImpl.dispose(modelsProvider, project2, synchronous);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> toRemove, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project2, boolean synchronous) {
        this.removeData(key, toRemove, toIgnore, projectData, project2, new IdeModifiableModelsProviderImpl(project2), synchronous);
    }

    public void updateExternalProjectData(@NotNull Project project2, @NotNull ExternalProjectInfo externalProjectInfo) {
        if (!project2.isDisposed()) {
            ExternalProjectsManagerImpl.getInstance(project2).updateExternalProjectData(externalProjectInfo);
        }
    }

    @Nullable
    public ExternalProjectInfo getExternalProjectData(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        return !project2.isDisposed() ? ExternalProjectsDataStorage.getInstance(project2).get(projectSystemId, externalProjectPath) : null;
    }

    @NotNull
    public Collection<ExternalProjectInfo> getExternalProjectsData(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId) {
        if (!project2.isDisposed()) {
            return ExternalProjectsDataStorage.getInstance(project2).list(projectSystemId);
        }
        return ContainerUtil.emptyList();
    }

    private void ensureTheDataIsReadyToUse(@NotNull Collection<DataNode<?>> nodes) {
        for (DataNode<?> node : nodes) {
            this.ensureTheDataIsReadyToUse(node);
        }
    }

    private boolean prepareDataToUse(@NotNull DataNode dataNode) {
        Map servicesByKey = (Map)this.myServices.getValue();
        List services = (List)servicesByKey.get(dataNode.getKey());
        if (services != null) {
            try {
                LinkedHashSet classLoaders = ContainerUtil.newLinkedHashSet();
                for (ProjectDataService dataService : services) {
                    classLoaders.add(dataService.getClass().getClassLoader());
                }
                for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
                    classLoaders.add(manager.getClass().getClassLoader());
                }
                dataNode.prepareData((ClassLoader[])ContainerUtil.toArray((Collection)classLoaders, ClassLoader[]::new));
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
                dataNode.clear(true);
                return false;
            }
        }
        return true;
    }

    private static void commit(final @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project2, boolean synchronous, final @NotNull String commitDesc) {
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project2){

            public void execute() {
                long startTime = System.currentTimeMillis();
                modelsProvider.commit();
                long timeInMs = System.currentTimeMillis() - startTime;
                LOG.debug(String.format("%s committed in %d ms", commitDesc, timeInMs));
            }
        });
    }

    private static void dispose(final @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project2, boolean synchronous) {
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project2){

            public void execute() {
                modelsProvider.dispose();
            }
        });
    }
}

