/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483648)
public class ProjectDataServiceImpl
extends AbstractProjectDataService<ProjectData, Project> {
    @NotNull
    public Key<ProjectData> getTargetDataKey() {
        return ProjectKeys.PROJECT;
    }

    public void importData(@NotNull Collection<DataNode<ProjectData>> toImport, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport.isEmpty()) {
            return;
        }
        if (toImport.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected to get a single project but got %d: %s", toImport.size(), toImport));
        }
        DataNode<ProjectData> node = toImport.iterator().next();
        assert (projectData == node.getData());
        if (!ExternalSystemApiUtil.isOneToOneMapping((Project)project2, (ProjectData)((ProjectData)node.getData()))) {
            return;
        }
        if (!project2.getName().equals(projectData.getInternalName())) {
            ProjectDataServiceImpl.renameProject(projectData.getInternalName(), projectData.getOwner(), project2);
        }
    }

    private static void renameProject(final @NotNull String newName, final @NotNull ProjectSystemId externalSystemId, final @NotNull Project project2) {
        if (!(project2 instanceof ProjectEx) || newName.equals(project2.getName())) {
            return;
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project2){

            public void execute() {
                String oldName = project2.getName();
                ((ProjectEx)project2).setProjectName(newName);
                ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)externalSystemId).getPublisher().onProjectRenamed(oldName, newName);
            }
        });
    }
}

