/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.service.project.manage.SourceFolderManager;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.PathPrefixTreeMapImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0003\"#$B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J,\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00112\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u0011H\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0016J\u0016\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0011J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0011H\u0016J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0011H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u00060\u0012R\u00020\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl;", "Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isDisposed", "", "mutex", "", "postponedSourceFolderCreator", "Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl$PostponedSourceFolderCreator;", "sourceFolders", "Lcom/intellij/openapi/externalSystem/util/PathPrefixTreeMapImpl;", "Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl$SourceFolderModel;", "sourceFoldersByModule", "Lgnu/trove/THashMap;", "", "Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl$ModuleModel;", "addSourceFolder", "", "module", "Lcom/intellij/openapi/module/Module;", "url", "type", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "packagePrefix", "dispose", "getSourceFolders", "", "moduleName", "removeSourceFolders", "setSourceFolderPackagePrefix", "unsafeRemoveSourceFolder", "ModuleModel", "PostponedSourceFolderCreator", "SourceFolderModel", "intellij.platform.externalSystem.impl"})
public final class SourceFolderManagerImpl
implements SourceFolderManager,
Disposable {
    private boolean isDisposed;
    private final Object mutex;
    private final PostponedSourceFolderCreator postponedSourceFolderCreator;
    private final PathPrefixTreeMapImpl<SourceFolderModel> sourceFolders;
    private final THashMap<String, ModuleModel> sourceFoldersByModule;
    private final Project project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void addSourceFolder(@NotNull Module module2, @NotNull String url, @NotNull JpsModuleSourceRootType<?> type, @NotNull String packagePrefix) {
        Object object = this.mutex;
        synchronized (object) {
            Object object2;
            void $receiver$iv;
            boolean bl = false;
            this.sourceFolders.set(url, new SourceFolderModel(module2, url, type, packagePrefix));
            Map map2 = (Map)this.sourceFoldersByModule;
            String key$iv = module2.getName();
            Object value$iv = $receiver$iv.get(key$iv);
            if (value$iv == null) {
                ModuleModel moduleModel;
                boolean bl2 = false;
                ModuleModel it = moduleModel = new ModuleModel(module2);
                boolean bl3 = false;
                Disposer.register((Disposable)((Disposable)module2), (Disposable)it);
                ModuleModel answer$iv = moduleModel;
                $receiver$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            ModuleModel moduleModel = (ModuleModel)object2;
            boolean bl4 = moduleModel.getSourceFolders().add(url);
        }
        TransactionGuard.getInstance().submitTransactionLater((Disposable)this, new Runnable(url){
            final /* synthetic */ String $url;

            public final void run() {
                VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
                virtualFileManager.refreshAndFindFileByUrl(this.$url);
            }
            {
                this.$url = string;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceFolderPackagePrefix(@NotNull String url, @NotNull String packagePrefix) {
        Object object = this.mutex;
        synchronized (object) {
            boolean bl = false;
            SourceFolderModel sourceFolderModel = this.sourceFolders.get(url);
            if (sourceFolderModel == null) {
                return;
            }
            SourceFolderModel sourceFolder = sourceFolderModel;
            sourceFolder.setPackagePrefix(packagePrefix);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSourceFolders(@NotNull Module module2) {
        Object object = this.mutex;
        synchronized (object) {
            boolean bl = false;
            ModuleModel moduleModel = (ModuleModel)this.sourceFoldersByModule.remove((Object)module2.getName());
            if (moduleModel == null) {
                return;
            }
            ModuleModel moduleModel2 = moduleModel;
            Iterable $receiver$iv = moduleModel2.getSourceFolders();
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                this.sourceFolders.remove(it);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public void dispose() {
        boolean bl;
        boolean bl2 = bl = !this.isDisposed;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Source folder manager already disposed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.isDisposed = true;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        virtualFileManager.removeVirtualFileListener((VirtualFileListener)this.postponedSourceFolderCreator);
    }

    public final boolean isDisposed() {
        return this.isDisposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Set<String> getSourceFolders(@NotNull String moduleName) {
        Set<String> set;
        Object object = this.mutex;
        synchronized (object) {
            boolean bl = false;
            ModuleModel moduleModel = (ModuleModel)this.sourceFoldersByModule.get((Object)moduleName);
            set = moduleModel != null ? moduleModel.getSourceFolders() : null;
        }
        return set;
    }

    private final void unsafeRemoveSourceFolder(String url) {
        SourceFolderModel sourceFolderModel = this.sourceFolders.remove(url);
        if (sourceFolderModel == null) {
            return;
        }
        SourceFolderModel sourceFolder = sourceFolderModel;
        Module module2 = sourceFolder.getModule();
        ModuleModel moduleModel = (ModuleModel)this.sourceFoldersByModule.get((Object)module2.getName());
        if (moduleModel == null) {
            return;
        }
        ModuleModel moduleModel2 = moduleModel;
        Set<String> sourceFolders = moduleModel2.getSourceFolders();
        sourceFolders.remove(url);
        if (sourceFolders.isEmpty()) {
            this.sourceFoldersByModule.remove((Object)module2.getName());
        }
    }

    public SourceFolderManagerImpl(@NotNull Project project2) {
        this.project = project2;
        this.mutex = new Object();
        this.postponedSourceFolderCreator = new PostponedSourceFolderCreator();
        this.sourceFolders = new PathPrefixTreeMapImpl(null, false, 3, null);
        this.sourceFoldersByModule = new THashMap();
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        virtualFileManager.addVirtualFileListener((VirtualFileListener)this.postponedSourceFolderCreator, (Disposable)this.project);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl$PostponedSourceFolderCreator;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "(Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl;)V", "fileCreated", "", "event", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "intellij.platform.externalSystem.impl"})
    private final class PostponedSourceFolderCreator
    implements VirtualFileListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileCreated(@NotNull VirtualFileEvent event) {
            ArrayList<SourceFolderModel> sourceFoldersToChange = new ArrayList<SourceFolderModel>();
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            Object object = SourceFolderManagerImpl.this.mutex;
            synchronized (object) {
                boolean bl = false;
                for (SourceFolderModel sourceFolder : SourceFolderManagerImpl.this.sourceFolders.getAllDescendants(event.getFile().getUrl())) {
                    VirtualFile sourceFolderFile = (VirtualFile)ExternalSystemApiUtil.doWriteAction((Computable)((Computable)new Computable<VirtualFile>(sourceFolder, this, event, virtualFileManager, sourceFoldersToChange){
                        final /* synthetic */ SourceFolderModel $sourceFolder;
                        final /* synthetic */ PostponedSourceFolderCreator this$0;
                        final /* synthetic */ VirtualFileEvent $event$inlined;
                        final /* synthetic */ VirtualFileManager $virtualFileManager$inlined;
                        final /* synthetic */ ArrayList $sourceFoldersToChange$inlined;
                        {
                            this.$sourceFolder = sourceFolderModel;
                            this.this$0 = postponedSourceFolderCreator;
                            this.$event$inlined = virtualFileEvent;
                            this.$virtualFileManager$inlined = virtualFileManager;
                            this.$sourceFoldersToChange$inlined = arrayList;
                        }

                        @Nullable
                        public final VirtualFile compute() {
                            return this.$virtualFileManager$inlined.refreshAndFindFileByUrl(this.$sourceFolder.getUrl());
                        }
                    }));
                    if (sourceFolderFile == null || !sourceFolderFile.isValid()) continue;
                    sourceFoldersToChange.add(sourceFolder);
                    SourceFolderManagerImpl.this.unsafeRemoveSourceFolder(sourceFolder.getUrl());
                }
                Unit unit = Unit.INSTANCE;
            }
            ExternalSystemApiUtil.executeProjectChangeAction((boolean)false, (DisposeAwareProjectChange)new DisposeAwareProjectChange(this, sourceFoldersToChange, event, (ComponentManager)SourceFolderManagerImpl.this.project){
                final /* synthetic */ PostponedSourceFolderCreator this$0;
                final /* synthetic */ ArrayList $sourceFoldersToChange;
                final /* synthetic */ VirtualFileEvent $event;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute() {
                    for (SourceFolderModel sourceFolderModel : this.$sourceFoldersToChange) {
                        Module module2 = sourceFolderModel.component1();
                        String url = sourceFolderModel.component2();
                        JpsModuleSourceRootType<?> type = sourceFolderModel.component3();
                        String packagePrefix = sourceFolderModel.component4();
                        ModuleRootManager moduleManager = ModuleRootManager.getInstance((Module)module2);
                        ModifiableRootModel modifiableModuleModel = moduleManager.getModifiableModel();
                        try {
                            ContentEntry contentEntry = MarkRootActionBase.findContentEntry((ModuleRootModel)((ModuleRootModel)modifiableModuleModel), (VirtualFile)this.$event.getFile());
                            if (contentEntry == null) continue;
                            SourceFolder sourceFolder = contentEntry.addSourceFolder(url, type);
                            sourceFolder.setPackagePrefix(packagePrefix);
                        }
                        finally {
                            modifiableModuleModel.commit();
                        }
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$sourceFoldersToChange = $captured_local_variable$1;
                    this.$event = $captured_local_variable$2;
                    super($super_call_param$3);
                }
            });
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\r\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J5\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\f\b\u0002\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl$SourceFolderModel;", "", "module", "Lcom/intellij/openapi/module/Module;", "url", "", "type", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "packagePrefix", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;Ljava/lang/String;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getPackagePrefix", "()Ljava/lang/String;", "setPackagePrefix", "(Ljava/lang/String;)V", "getType", "()Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "getUrl", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.externalSystem.impl"})
    private static final class SourceFolderModel {
        @NotNull
        private final Module module;
        @NotNull
        private final String url;
        @NotNull
        private final JpsModuleSourceRootType<?> type;
        @NotNull
        private String packagePrefix;

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final JpsModuleSourceRootType<?> getType() {
            return this.type;
        }

        @NotNull
        public final String getPackagePrefix() {
            return this.packagePrefix;
        }

        public final void setPackagePrefix(@NotNull String string) {
            this.packagePrefix = string;
        }

        public SourceFolderModel(@NotNull Module module2, @NotNull String url, @NotNull JpsModuleSourceRootType<?> type, @NotNull String packagePrefix) {
            this.module = module2;
            this.url = url;
            this.type = type;
            this.packagePrefix = packagePrefix;
        }

        @NotNull
        public final Module component1() {
            return this.module;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @NotNull
        public final JpsModuleSourceRootType<?> component3() {
            return this.type;
        }

        @NotNull
        public final String component4() {
            return this.packagePrefix;
        }

        @NotNull
        public final SourceFolderModel copy(@NotNull Module module2, @NotNull String url, @NotNull JpsModuleSourceRootType<?> type, @NotNull String packagePrefix) {
            return new SourceFolderModel(module2, url, type, packagePrefix);
        }

        @NotNull
        public static /* synthetic */ SourceFolderModel copy$default(SourceFolderModel sourceFolderModel, Module module2, String string, JpsModuleSourceRootType jpsModuleSourceRootType, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                module2 = sourceFolderModel.module;
            }
            if ((n & 2) != 0) {
                string = sourceFolderModel.url;
            }
            if ((n & 4) != 0) {
                jpsModuleSourceRootType = sourceFolderModel.type;
            }
            if ((n & 8) != 0) {
                string2 = sourceFolderModel.packagePrefix;
            }
            return sourceFolderModel.copy(module2, string, jpsModuleSourceRootType, string2);
        }

        @NotNull
        public String toString() {
            return "SourceFolderModel(module=" + this.module + ", url=" + this.url + ", type=" + this.type + ", packagePrefix=" + this.packagePrefix + ")";
        }

        public int hashCode() {
            Module module2 = this.module;
            String string = this.url;
            JpsModuleSourceRootType<?> jpsModuleSourceRootType = this.type;
            String string2 = this.packagePrefix;
            return (((module2 != null ? module2.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (jpsModuleSourceRootType != null ? jpsModuleSourceRootType.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SourceFolderModel)) break block3;
                    SourceFolderModel sourceFolderModel = (SourceFolderModel)object;
                    if (!Intrinsics.areEqual((Object)this.module, (Object)sourceFolderModel.module) || !Intrinsics.areEqual((Object)this.url, (Object)sourceFolderModel.url) || !Intrinsics.areEqual(this.type, sourceFolderModel.type) || !Intrinsics.areEqual((Object)this.packagePrefix, (Object)sourceFolderModel.packagePrefix)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl$ModuleModel;", "Lcom/intellij/openapi/Disposable;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl;Lcom/intellij/openapi/module/Module;)V", "sourceFolders", "", "", "(Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl;Lcom/intellij/openapi/module/Module;Ljava/util/Set;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getSourceFolders", "()Ljava/util/Set;", "dispose", "", "intellij.platform.externalSystem.impl"})
    private final class ModuleModel
    implements Disposable {
        @NotNull
        private final Module module;
        @NotNull
        private final Set<String> sourceFolders;

        public void dispose() {
            SourceFolderManagerImpl.this.removeSourceFolders(this.module);
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final Set<String> getSourceFolders() {
            return this.sourceFolders;
        }

        public ModuleModel(@NotNull Module module2, Set<String> sourceFolders) {
            this.module = module2;
            this.sourceFolders = sourceFolders;
        }

        public ModuleModel(Module module2) {
            this(module2, (Set)new THashSet(FileUtil.PATH_HASHING_STRATEGY));
        }
    }
}

