/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.remote;

import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemService;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRemoteExternalSystemService<S extends ExternalSystemExecutionSettings>
implements RemoteExternalSystemService<S> {
    private final ConcurrentMap<ExternalSystemTaskType, Set<ExternalSystemTaskId>> myTasksInProgress = ContainerUtil.newConcurrentMap();
    private final AtomicReference<S> mySettings = new AtomicReference();
    private final AtomicReference<ExternalSystemTaskNotificationListener> myListener = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T execute(@NotNull ExternalSystemTaskId id, @NotNull Producer<T> task) {
        Set tasks2 = (Set)this.myTasksInProgress.get(id.getType());
        if (tasks2 == null) {
            this.myTasksInProgress.putIfAbsent(id.getType(), new HashSet());
            tasks2 = (Set)this.myTasksInProgress.get(id.getType());
        }
        tasks2.add(id);
        try {
            Object object = task.produce();
            return (T)object;
        }
        finally {
            tasks2.remove(id);
        }
    }

    @Override
    public void setSettings(@NotNull S settings) {
        this.mySettings.set(settings);
    }

    @Nullable
    public S getSettings() {
        return (S)((ExternalSystemExecutionSettings)this.mySettings.get());
    }

    @Override
    public void setNotificationListener(@NotNull ExternalSystemTaskNotificationListener listener) {
        this.myListener.set(listener);
    }

    @NotNull
    public ExternalSystemTaskNotificationListener getNotificationListener() {
        return this.myListener.get();
    }

    @Override
    public boolean isTaskInProgress(@NotNull ExternalSystemTaskId id) {
        Set tasks2 = (Set)this.myTasksInProgress.get(id.getType());
        return tasks2 != null && tasks2.contains(id);
    }

    @Override
    @NotNull
    public Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> getTasksInProgress() {
        return this.myTasksInProgress;
    }
}

