/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.settings;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.externalSystem.service.settings.AbstractSettingsControl;
import com.intellij.openapi.externalSystem.service.settings.ExternalSystemSettingsControlCustomizer;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalProjectSettingsControl<S extends ExternalProjectSettings>
extends AbstractSettingsControl
implements ExternalSystemSettingsControl<S> {
    @NotNull
    private final S myInitialSettings;
    @Nullable
    private JBCheckBox myUseAutoImportBox;
    @Nullable
    private JBCheckBox myCreateEmptyContentRootDirectoriesBox;
    @Nullable
    private JBRadioButton myUseQualifiedModuleNamesRadioButton;
    @Nullable
    private JBRadioButton myUseModuleGroupsRadioButton;
    @NotNull
    private final ExternalSystemSettingsControlCustomizer myCustomizer;
    @Nullable
    private JPanel myOrganizeModuleNamesPanel;

    protected AbstractExternalProjectSettingsControl(@NotNull S initialSettings) {
        this(null, initialSettings, null);
    }

    protected AbstractExternalProjectSettingsControl(@Nullable Project project2, @NotNull S initialSettings, @Nullable ExternalSystemSettingsControlCustomizer controlCustomizer) {
        super(project2);
        this.myInitialSettings = initialSettings;
        this.myCustomizer = controlCustomizer == null ? new ExternalSystemSettingsControlCustomizer() : controlCustomizer;
    }

    @NotNull
    public S getInitialSettings() {
        return this.myInitialSettings;
    }

    @Override
    public void fillUi(@NotNull PaintAwarePanel canvas, int indentLevel) {
        if (!this.myCustomizer.isUseAutoImportBoxHidden()) {
            this.myUseAutoImportBox = new JBCheckBox(ExternalSystemBundle.message((String)"settings.label.use.auto.import", (Object[])new Object[0]));
            canvas.add((Component)this.myUseAutoImportBox, ExternalSystemUiUtil.getFillLineConstraints(indentLevel));
        }
        if (!this.myCustomizer.isCreateEmptyContentRootDirectoriesBoxHidden()) {
            this.myCreateEmptyContentRootDirectoriesBox = new JBCheckBox(ExternalSystemBundle.message((String)"settings.label.create.empty.content.root.directories", (Object[])new Object[0]));
            canvas.add((Component)this.myCreateEmptyContentRootDirectoriesBox, ExternalSystemUiUtil.getFillLineConstraints(indentLevel));
        }
        if (!this.myCustomizer.isModulesGroupingOptionPanelHidden()) {
            this.myOrganizeModuleNamesPanel = new JPanel(new FlowLayout(0));
            this.myOrganizeModuleNamesPanel.add((Component)new JBLabel(ExternalSystemBundle.message((String)"settings.label.group.modules", (Object[])new Object[0])));
            this.myUseModuleGroupsRadioButton = new JBRadioButton(ExternalSystemBundle.message((String)"settings.radio.button.use.module.groups", (Object[])new Object[0]), true);
            this.myOrganizeModuleNamesPanel.add((Component)this.myUseModuleGroupsRadioButton);
            this.myUseQualifiedModuleNamesRadioButton = new JBRadioButton(ExternalSystemBundle.message((String)"settings.radio.button.use.qualified.name", (Object[])new Object[0]));
            this.myOrganizeModuleNamesPanel.add((Component)this.myUseQualifiedModuleNamesRadioButton);
            ButtonGroup group = new ButtonGroup();
            group.add((AbstractButton)this.myUseModuleGroupsRadioButton);
            group.add((AbstractButton)this.myUseQualifiedModuleNamesRadioButton);
            canvas.add((Component)this.myOrganizeModuleNamesPanel, ExternalSystemUiUtil.getFillLineConstraints(indentLevel));
        }
        this.fillExtraControls(canvas, indentLevel);
    }

    protected abstract void fillExtraControls(@NotNull PaintAwarePanel var1, int var2);

    @Override
    public boolean isModified() {
        boolean result = false;
        if (!this.myCustomizer.isUseAutoImportBoxHidden() && this.myUseAutoImportBox != null) {
            boolean bl = result = this.myUseAutoImportBox.isSelected() != this.getInitialSettings().isUseAutoImport();
        }
        if (!this.myCustomizer.isCreateEmptyContentRootDirectoriesBoxHidden() && this.myCreateEmptyContentRootDirectoriesBox != null) {
            boolean bl = result = result || this.myCreateEmptyContentRootDirectoriesBox.isSelected() != this.getInitialSettings().isCreateEmptyContentRootDirectories();
        }
        if (!this.myCustomizer.isModulesGroupingOptionPanelHidden() && this.myUseQualifiedModuleNamesRadioButton != null) {
            result |= this.myUseQualifiedModuleNamesRadioButton.isSelected() != this.getInitialSettings().isUseQualifiedModuleNames();
        }
        return result || this.isExtraSettingModified();
    }

    protected abstract boolean isExtraSettingModified();

    @Override
    public void reset() {
        this.reset(false, null);
    }

    @Override
    public void reset(@Nullable Project project2) {
        this.reset(false, project2);
    }

    @Override
    public void reset(@Nullable WizardContext wizardContext) {
        this.reset(false, wizardContext, null);
    }

    public void reset(boolean isDefaultModuleCreation, @Nullable Project project2) {
        this.reset(isDefaultModuleCreation, null, project2);
    }

    public void reset(boolean isDefaultModuleCreation, @Nullable WizardContext wizardContext, @Nullable Project project2) {
        super.reset(wizardContext, project2);
        if (!this.myCustomizer.isUseAutoImportBoxHidden() && this.myUseAutoImportBox != null) {
            this.myUseAutoImportBox.setSelected(this.getInitialSettings().isUseAutoImport());
        }
        if (isDefaultModuleCreation && this.myCreateEmptyContentRootDirectoriesBox != null) {
            this.myCreateEmptyContentRootDirectoriesBox.getParent().remove((Component)this.myCreateEmptyContentRootDirectoriesBox);
            this.myCreateEmptyContentRootDirectoriesBox = null;
        }
        if (!isDefaultModuleCreation && !this.myCustomizer.isCreateEmptyContentRootDirectoriesBoxHidden() && this.myCreateEmptyContentRootDirectoriesBox != null) {
            this.myCreateEmptyContentRootDirectoriesBox.setSelected(this.getInitialSettings().isCreateEmptyContentRootDirectories());
        }
        if (!this.myCustomizer.isModulesGroupingOptionPanelHidden() && this.myUseModuleGroupsRadioButton != null && this.myUseQualifiedModuleNamesRadioButton != null) {
            boolean useQualifiedModuleNames = this.getInitialSettings().isUseQualifiedModuleNames();
            this.myUseModuleGroupsRadioButton.setSelected(!useQualifiedModuleNames);
            this.myUseQualifiedModuleNamesRadioButton.setSelected(useQualifiedModuleNames);
        }
        this.resetExtraSettings(isDefaultModuleCreation, wizardContext);
    }

    protected abstract void resetExtraSettings(boolean var1);

    protected void resetExtraSettings(boolean isDefaultModuleCreation, @Nullable WizardContext wizardContext) {
        this.resetExtraSettings(isDefaultModuleCreation);
    }

    @Override
    public void apply(@NotNull S settings) {
        settings.setModules(this.myInitialSettings.getModules());
        if (!this.myCustomizer.isUseAutoImportBoxHidden() && this.myUseAutoImportBox != null) {
            settings.setUseAutoImport(this.myUseAutoImportBox.isSelected());
        }
        if (!this.myCustomizer.isCreateEmptyContentRootDirectoriesBoxHidden() && this.myCreateEmptyContentRootDirectoriesBox != null) {
            settings.setCreateEmptyContentRootDirectories(this.myCreateEmptyContentRootDirectoriesBox.isSelected());
        }
        if (this.myInitialSettings.getExternalProjectPath() != null) {
            settings.setExternalProjectPath(this.myInitialSettings.getExternalProjectPath());
        }
        if (!this.myCustomizer.isModulesGroupingOptionPanelHidden() && this.myUseQualifiedModuleNamesRadioButton != null) {
            settings.setUseQualifiedModuleNames(this.myUseQualifiedModuleNamesRadioButton.isSelected());
        }
        this.applyExtraSettings(settings);
    }

    protected abstract void applyExtraSettings(@NotNull S var1);

    @Override
    public void disposeUIResources() {
        ExternalSystemUiUtil.disposeUi(this);
    }

    @Override
    public void showUi(boolean show) {
        ExternalSystemUiUtil.showUi(this, show);
    }

    public void updateInitialSettings() {
        if (!this.myCustomizer.isUseAutoImportBoxHidden() && this.myUseAutoImportBox != null) {
            this.myInitialSettings.setUseAutoImport(this.myUseAutoImportBox.isSelected());
        }
        if (!this.myCustomizer.isCreateEmptyContentRootDirectoriesBoxHidden() && this.myCreateEmptyContentRootDirectoriesBox != null) {
            this.myInitialSettings.setCreateEmptyContentRootDirectories(this.myCreateEmptyContentRootDirectoriesBox.isSelected());
        }
        if (!this.myCustomizer.isModulesGroupingOptionPanelHidden() && this.myUseQualifiedModuleNamesRadioButton != null) {
            this.myInitialSettings.setUseQualifiedModuleNames(this.myUseQualifiedModuleNamesRadioButton.isSelected());
        }
        this.updateInitialExtraSettings();
    }

    protected void updateInitialExtraSettings() {
    }

    public void setCurrentProject(@Nullable Project project2) {
        this.setProject(project2);
    }

    @Override
    @Nullable
    public Project getProject() {
        return super.getProject();
    }
}

