/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.TaskActivationState;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import gnu.trove.THashSet;
import icons.ExternalSystemIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureTasksActivationDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExternalSystemTaskActivator myTaskActivator;
    @NotNull
    ProjectSystemId myProjectSystemId;
    private JPanel contentPane;
    private JPanel tasksPanel;
    private JPanel projectFieldPanel;
    private SimpleTree myTree;
    private AbstractTreeBuilder treeBuilder;
    private ComboBox projectCombobox;
    @NotNull
    private final ExternalSystemUiAware uiAware;
    private RootNode myRootNode;

    public ConfigureTasksActivationDialog(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @NotNull String projectPath) {
        super(project2, true);
        this.myProject = project2;
        this.myProjectSystemId = externalSystemId;
        this.$$$setupUI$$$();
        this.uiAware = ExternalSystemUiUtil.getUiAware(this.myProjectSystemId);
        this.setUpDialog(projectPath);
        this.setModal(true);
        this.setTitle(ExternalSystemBundle.message((String)"external.system.task.activation.title", (Object[])new Object[]{externalSystemId.getReadableName()}));
        this.init();
        this.myTaskActivator = ExternalProjectsManagerImpl.getInstance(this.myProject).getTaskActivator();
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getOKAction()};
    }

    private void setUpDialog(@NotNull String projectPath) {
        AbstractExternalSystemSettings externalSystemSettings = ExternalSystemApiUtil.getSettings((Project)this.myProject, (ProjectSystemId)this.myProjectSystemId);
        Collection projectsSettings = externalSystemSettings.getLinkedProjectsSettings();
        List projects = ContainerUtil.map((Collection)projectsSettings, settings -> new ProjectItem(this.uiAware.getProjectRepresentationName(settings.getExternalProjectPath(), null), (ExternalProjectSettings)settings));
        this.myTree = new SimpleTree();
        this.myRootNode = new RootNode();
        this.treeBuilder = ConfigureTasksActivationDialog.createTreeBuilder(this.myProject, (SimpleNode)this.myRootNode, (Tree)this.myTree);
        ExternalProjectSettings currentProjectSettings = externalSystemSettings.getLinkedProjectSettings(projectPath);
        if (currentProjectSettings != null) {
            SwingHelper.updateItems((JComboBox)this.projectCombobox, (List)projects, (Object)new ProjectItem(this.uiAware.getProjectRepresentationName(projectPath, null), currentProjectSettings));
        }
        this.projectCombobox.addActionListener(e -> this.updateTree(this.myRootNode));
    }

    private static AbstractTreeBuilder createTreeBuilder(@NotNull Project project2, @NotNull SimpleNode root, @NotNull Tree tree) {
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode(root));
        tree.setModel((TreeModel)treeModel);
        tree.setRootVisible(false);
        tree.getSelectionModel().setSelectionMode(4);
        AbstractTreeBuilder treeBuilder = new AbstractTreeBuilder((JTree)tree, treeModel, (AbstractTreeStructure)new SimpleTreeStructure.Impl(root), null){};
        Disposer.register((Disposable)project2, (Disposable)treeBuilder);
        return treeBuilder;
    }

    protected JComponent createCenterPanel() {
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)this.myTree).setAddAction(button -> {
            ChooseProjectStep step;
            ProjectItem projectItem = (ProjectItem)this.projectCombobox.getSelectedItem();
            if (projectItem == null) {
                return;
            }
            ExternalProjectInfo projectData = ProjectDataManager.getInstance().getExternalProjectData(this.myProject, this.myProjectSystemId, projectItem.myProjectSettings.getExternalProjectPath());
            if (projectData == null || projectData.getExternalProjectStructure() == null) {
                return;
            }
            ArrayList popupItems = ContainerUtil.newArrayList();
            for (DataNode moduleDataNode : ExternalSystemApiUtil.findAllRecursively((DataNode)projectData.getExternalProjectStructure(), (Key)ProjectKeys.MODULE)) {
                List tasks2;
                if (moduleDataNode.isIgnored() || (tasks2 = ContainerUtil.map((Collection)ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, (Key)ProjectKeys.TASK), node -> ((TaskData)node.getData()).getName())).isEmpty()) continue;
                popupItems.add(new ProjectPopupItem((ModuleData)moduleDataNode.getData(), tasks2));
            }
            ChooseProjectStep projectStep = new ChooseProjectStep(popupItems);
            List projectItems = projectStep.getValues();
            ChooseProjectStep chooseProjectStep = step = projectItems.size() == 1 ? (ListPopupStep)projectStep.onChosen((ProjectPopupItem)projectItems.get(0), false) : projectStep;
            assert (step != null);
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).show((RelativePoint)ObjectUtils.notNull((Object)button.getPreferredPopupPoint(), (Object)RelativePoint.getSouthEastOf((JComponent)this.projectCombobox)));
        }).setRemoveAction(button -> {
            List<ExternalSystemTaskActivator.TaskActivationEntry> tasks2 = this.findSelectedTasks();
            this.myTaskActivator.removeTasks(tasks2);
            this.updateTree(null);
        }).setMoveUpAction(button -> this.moveAction(-1)).setMoveUpActionUpdater(e -> this.isMoveActionEnabled(-1)).setMoveDownAction(button -> this.moveAction(1)).setMoveDownActionUpdater(e -> this.isMoveActionEnabled(1)).setToolbarPosition(ActionToolbarPosition.RIGHT).setToolbarBorder((Border)JBUI.Borders.empty());
        this.tasksPanel.add(decorator.createPanel());
        return this.contentPane;
    }

    private boolean isMoveActionEnabled(int increment) {
        DefaultMutableTreeNode sibling;
        DefaultMutableTreeNode[] selectedNodes = (DefaultMutableTreeNode[])this.myTree.getSelectedNodes(DefaultMutableTreeNode.class, null);
        if (selectedNodes.length == 0) {
            return false;
        }
        boolean enabled = true;
        for (DefaultMutableTreeNode node : selectedNodes) {
            sibling = increment == -1 ? node.getPreviousSibling() : node.getNextSibling();
            enabled = enabled && node.getUserObject() instanceof TaskNode && sibling != null;
        }
        if (!enabled) {
            enabled = true;
            for (DefaultMutableTreeNode node : selectedNodes) {
                sibling = increment == -1 ? node.getPreviousSibling() : node.getNextSibling();
                enabled = enabled && node.getUserObject() instanceof ProjectNode && sibling != null;
            }
        }
        return enabled;
    }

    private void moveAction(int increment) {
        List<ExternalSystemTaskActivator.TaskActivationEntry> tasks2 = this.findSelectedTasks();
        if (!tasks2.isEmpty()) {
            this.myTaskActivator.moveTasks(tasks2, increment);
        } else {
            List<String> projectsPaths = this.findSelectedProjects();
            if (projectsPaths.isEmpty()) {
                return;
            }
            ProjectItem item = (ProjectItem)this.projectCombobox.getSelectedItem();
            this.myTaskActivator.moveProjects(this.myProjectSystemId, projectsPaths, item.myProjectSettings.getModules(), increment);
        }
        ConfigureTasksActivationDialog.moveSelectedRows(this.myTree, increment);
    }

    private static void moveSelectedRows(final @NotNull SimpleTree tree, final int direction) {
        Object[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths == null) {
            return;
        }
        ContainerUtil.sort((Object[])selectionPaths, (Comparator)new Comparator<TreePath>(){

            @Override
            public int compare(TreePath o1, TreePath o2) {
                return -direction * this.compare(tree.getRowForPath(o1), tree.getRowForPath(o2));
            }

            @Override
            private int compare(int x, int y) {
                return Integer.compare(x, y);
            }
        });
        for (Object selectionPath : selectionPaths) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)((TreePath)selectionPath).getLastPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treeNode.getParent();
            int idx = parent.getIndex(treeNode);
            ((DefaultTreeModel)tree.getModel()).removeNodeFromParent(treeNode);
            ((DefaultTreeModel)tree.getModel()).insertNodeInto(treeNode, parent, idx + direction);
        }
        tree.addSelectionPaths((TreePath[])selectionPaths);
    }

    @NotNull
    private List<ExternalSystemTaskActivator.TaskActivationEntry> findSelectedTasks() {
        List tasks2 = ContainerUtil.newSmartList();
        for (DefaultMutableTreeNode node : (DefaultMutableTreeNode[])this.myTree.getSelectedNodes(DefaultMutableTreeNode.class, null)) {
            ContainerUtil.addAll((Collection)tasks2, this.findTasksUnder((SimpleNode[])ContainerUtil.ar((Object[])new MyNode[]{(MyNode)((Object)node.getUserObject())})));
        }
        return tasks2;
    }

    @NotNull
    private List<ExternalSystemTaskActivator.TaskActivationEntry> findTasksUnder(@NotNull SimpleNode[] nodes) {
        List tasks2 = ContainerUtil.newSmartList();
        for (SimpleNode node : nodes) {
            if (node instanceof TaskNode) {
                TaskNode taskNode = (TaskNode)node;
                String taskName = taskNode.getName();
                PhaseNode phaseNode = (PhaseNode)taskNode.getParent();
                tasks2.add(new ExternalSystemTaskActivator.TaskActivationEntry(this.myProjectSystemId, phaseNode.myPhase, phaseNode.myProjectPath, taskName));
                continue;
            }
            ContainerUtil.addAll((Collection)tasks2, this.findTasksUnder(node.getChildren()));
        }
        return tasks2;
    }

    private List<String> findSelectedProjects() {
        ArrayList tasks2 = ContainerUtil.newArrayList();
        for (DefaultMutableTreeNode node : (DefaultMutableTreeNode[])this.myTree.getSelectedNodes(DefaultMutableTreeNode.class, null)) {
            if (!(node.getUserObject() instanceof ProjectNode)) continue;
            ProjectNode projectNode = (ProjectNode)((Object)node.getUserObject());
            tasks2.add(projectNode.myProjectPath);
        }
        return tasks2;
    }

    private MyNode[] buildProjectsNodes(ExternalProjectSettings projectSettings, ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider, RootNode parent) {
        ArrayList paths = ContainerUtil.newArrayList(stateProvider.getProjectsTasksActivationMap(this.myProjectSystemId).keySet());
        paths.retainAll(projectSettings.getModules());
        return (MyNode[])ContainerUtil.mapNotNull((Object[])ArrayUtil.toStringArray((Collection)paths), path -> {
            ProjectNode node = new ProjectNode(parent, stateProvider, projectSettings.getExternalProjectPath(), (String)path);
            return node.getChildren().length > 0 ? node : null;
        }, (Object[])new MyNode[0]);
    }

    private MyNode[] buildProjectPhasesNodes(String projectPath, TaskActivationState tasksActivation, MyNode parent) {
        return (MyNode[])ContainerUtil.mapNotNull((Object[])ExternalSystemTaskActivator.Phase.values(), phase -> tasksActivation.getTasks((ExternalSystemTaskActivator.Phase)((Object)phase)).isEmpty() ? null : new PhaseNode(projectPath, (ExternalSystemTaskActivator.Phase)((Object)phase), tasksActivation, (SimpleNode)parent), (Object[])new MyNode[0]);
    }

    private void updateTree(@Nullable CachingSimpleNode nodeToUpdate) {
        THashSet toUpdate = ContainerUtil.newIdentityTroveSet();
        if (nodeToUpdate == null) {
            for (DefaultMutableTreeNode node : (DefaultMutableTreeNode[])this.myTree.getSelectedNodes(DefaultMutableTreeNode.class, null)) {
                Object userObject = node.getUserObject();
                if (!(userObject instanceof SimpleNode) || !(((SimpleNode)userObject).getParent() instanceof CachingSimpleNode)) continue;
                toUpdate.add((CachingSimpleNode)((SimpleNode)userObject).getParent());
            }
        } else {
            toUpdate.add(nodeToUpdate);
        }
        if (toUpdate.isEmpty()) {
            toUpdate.add(this.myRootNode);
        }
        Element treeStateElement = new Element("root");
        try {
            TreeState.createOn((JTree)this.myTree).writeExternal(treeStateElement);
        }
        catch (WriteExternalException writeExternalException) {
            // empty catch block
        }
        for (CachingSimpleNode node : toUpdate) {
            this.cleanUpEmptyNodes(node);
        }
        TreeState.createFrom((Element)treeStateElement).applyTo((JTree)this.myTree);
    }

    private void cleanUpEmptyNodes(@NotNull CachingSimpleNode node) {
        node.cleanUpCache();
        this.treeBuilder.addSubtreeToUpdateByElement((Object)node);
        if (node.getChildren().length == 0 && node.getParent() instanceof CachingSimpleNode) {
            this.cleanUpEmptyNodes((CachingSimpleNode)node.getParent());
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        ComboBox comboBox;
        JPanel jPanel2;
        JPanel jPanel3;
        this.contentPane = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(10, 10));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, "North");
        this.projectFieldPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.projectCombobox = comboBox = new ComboBox();
        jPanel2.add((Component)comboBox, "Center");
        this.tasksPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(1, 0, 2, 1, 0, 3, 3, 3, new Dimension(300, 300), null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private class TaskNode
    extends MyNode {
        private final String myTaskName;

        TaskNode(String taskName, PhaseNode parent) {
            super((SimpleNode)parent);
            this.myTaskName = taskName;
        }

        protected void update(@NotNull PresentationData presentation) {
            super.update(presentation);
            presentation.setIcon(ConfigureTasksActivationDialog.this.uiAware.getTaskIcon());
        }

        public MyNode[] buildChildren() {
            return new MyNode[0];
        }

        public String getName() {
            return this.myTaskName;
        }

        public boolean isAlwaysLeaf() {
            return true;
        }
    }

    private class PhaseNode
    extends MyNode {
        private final ExternalSystemTaskActivator.Phase myPhase;
        private final TaskActivationState myTaskActivationState;
        private final String myProjectPath;

        PhaseNode(String projectPath, ExternalSystemTaskActivator.Phase phase, TaskActivationState taskActivationState, SimpleNode parent) {
            super(parent);
            this.myPhase = phase;
            this.myTaskActivationState = taskActivationState;
            this.myProjectPath = projectPath;
        }

        protected void update(@NotNull PresentationData presentation) {
            super.update(presentation);
            presentation.setIcon(ExternalSystemIcons.TaskGroup);
        }

        public boolean isAutoExpandNode() {
            return true;
        }

        public MyNode[] buildChildren() {
            return (MyNode[])ContainerUtil.map2Array(this.myTaskActivationState.getTasks(this.myPhase), MyNode.class, taskName -> new TaskNode((String)taskName, this));
        }

        public String getName() {
            return this.myPhase.toString();
        }
    }

    private class ProjectNode
    extends MyNode {
        private final ExternalProjectsManagerImpl.ExternalProjectsStateProvider myStateProvider;
        private final String myRootProjectPath;
        private final String myProjectPath;
        private final String myProjectName;

        ProjectNode(RootNode parent, ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider, String rootProjectPath, String projectPath) {
            super((SimpleNode)parent);
            this.myStateProvider = stateProvider;
            this.myProjectPath = projectPath;
            this.myRootProjectPath = rootProjectPath;
            this.myProjectName = ConfigureTasksActivationDialog.this.uiAware.getProjectRepresentationName(this.myProjectPath, this.myRootProjectPath);
        }

        protected void update(@NotNull PresentationData presentation) {
            super.update(presentation);
            presentation.setIcon(ExternalSystemIcons.TaskGroup);
        }

        public String getName() {
            return this.myProjectName;
        }

        protected MyNode[] buildChildren() {
            TaskActivationState tasksActivation = this.myStateProvider.getTasksActivation(ConfigureTasksActivationDialog.this.myProjectSystemId, this.myProjectPath);
            return ConfigureTasksActivationDialog.this.buildProjectPhasesNodes(this.myProjectPath, tasksActivation, this);
        }
    }

    private class RootNode
    extends MyNode {
        private final ExternalProjectsManagerImpl.ExternalProjectsStateProvider myStateProvider;

        RootNode() {
            super(ConfigureTasksActivationDialog.this.myProject, null);
            this.myStateProvider = ExternalProjectsManagerImpl.getInstance(ConfigureTasksActivationDialog.this.myProject).getStateProvider();
        }

        public boolean isAutoExpandNode() {
            return true;
        }

        protected MyNode[] buildChildren() {
            ProjectItem item = (ProjectItem)ConfigureTasksActivationDialog.this.projectCombobox.getSelectedItem();
            if (item == null) {
                return new MyNode[0];
            }
            if (item.myProjectSettings.getModules().isEmpty() || item.myProjectSettings.getModules().size() == 1) {
                TaskActivationState tasksActivation = this.myStateProvider.getTasksActivation(ConfigureTasksActivationDialog.this.myProjectSystemId, item.myProjectSettings.getExternalProjectPath());
                return ConfigureTasksActivationDialog.this.buildProjectPhasesNodes(item.myProjectSettings.getExternalProjectPath(), tasksActivation, this);
            }
            return ConfigureTasksActivationDialog.this.buildProjectsNodes(item.myProjectSettings, this.myStateProvider, this);
        }
    }

    private static abstract class MyNode
    extends CachingSimpleNode {
        protected MyNode(SimpleNode aParent) {
            super(aParent);
        }

        MyNode(Project aProject, @Nullable NodeDescriptor aParentDescriptor) {
            super(aProject, aParentDescriptor);
        }
    }

    private class ChooseProjectStep
    extends BaseListPopupStep<ProjectPopupItem> {
        protected ChooseProjectStep(List<? extends ProjectPopupItem> values) {
            super("Choose project", values);
        }

        public PopupStep onChosen(final ProjectPopupItem projectPopupItem, boolean finalChoice) {
            return new BaseListPopupStep<ExternalSystemTaskActivator.Phase>("Choose activation phase", ExternalSystemTaskActivator.Phase.values()){

                public PopupStep onChosen(final ExternalSystemTaskActivator.Phase selectedPhase, boolean finalChoice) {
                    Map<String, TaskActivationState> activationMap = ExternalProjectsManagerImpl.getInstance(ConfigureTasksActivationDialog.this.myProject).getStateProvider().getProjectsTasksActivationMap(ConfigureTasksActivationDialog.this.myProjectSystemId);
                    final String projectPath = projectPopupItem.myModuleData.getLinkedExternalProjectPath();
                    List<String> tasks2 = activationMap.get(projectPath).getTasks(selectedPhase);
                    ArrayList tasksToSuggest = ContainerUtil.newArrayList(projectPopupItem.myTasks);
                    tasksToSuggest.removeAll(tasks2);
                    return new BaseListPopupStep<String>("Choose task", (List)tasksToSuggest){

                        public PopupStep onChosen(String taskName, boolean finalChoice) {
                            return this.doFinalStep(() -> {
                                ConfigureTasksActivationDialog.this.myTaskActivator.addTask(new ExternalSystemTaskActivator.TaskActivationEntry(ConfigureTasksActivationDialog.this.myProjectSystemId, selectedPhase, projectPath, taskName));
                                ConfigureTasksActivationDialog.this.updateTree(ConfigureTasksActivationDialog.this.myRootNode);
                            });
                        }
                    };
                }

                public boolean hasSubstep(ExternalSystemTaskActivator.Phase phase) {
                    return true;
                }
            };
        }

        public boolean hasSubstep(ProjectPopupItem selectedValue) {
            return true;
        }
    }

    private static class ProjectPopupItem {
        ModuleData myModuleData;
        List<String> myTasks;

        ProjectPopupItem(ModuleData moduleData, List<String> tasks2) {
            this.myModuleData = moduleData;
            this.myTasks = tasks2;
        }

        public String toString() {
            return this.myModuleData.getId();
        }
    }

    private static class ProjectItem {
        private static final int MAX_LENGTH = 80;
        @NotNull
        String projectName;
        @NotNull
        ExternalProjectSettings myProjectSettings;

        ProjectItem(@NotNull String projectName, @NotNull ExternalProjectSettings projectPath) {
            this.projectName = projectName;
            this.myProjectSettings = projectPath;
        }

        public String toString() {
            return this.projectName + " (" + ProjectItem.truncate(this.myProjectSettings.getExternalProjectPath()) + ")";
        }

        @NotNull
        private static String truncate(@NotNull String s) {
            return s.length() < 80 ? s : s.substring(0, 40) + "..." + s.substring(s.length() - 40 - 3);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ProjectItem)) {
                return false;
            }
            ProjectItem item = (ProjectItem)o;
            return this.myProjectSettings.equals((Object)item.myProjectSettings);
        }

        public int hashCode() {
            return this.myProjectSettings.hashCode();
        }
    }
}

