/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemNode;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemNodeDescriptor;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTasksTreeModel
extends DefaultTreeModel {
    @NotNull
    private static final Comparator<TreeNode> NODE_COMPARATOR = (t1, t2) -> {
        Object e1 = ((ExternalSystemNode)t1).getDescriptor().getElement();
        Object e2 = ((ExternalSystemNode)t2).getDescriptor().getElement();
        if (e1 instanceof ExternalProjectPojo) {
            if (e2 instanceof ExternalTaskExecutionInfo) {
                return 1;
            }
            return ((ExternalProjectPojo)e1).getName().compareTo(((ExternalProjectPojo)e2).getName());
        }
        if (e2 instanceof ExternalProjectPojo) {
            return -1;
        }
        return ExternalSystemTasksTreeModel.getTaskName((ExternalTaskExecutionInfo)e1).compareTo(ExternalSystemTasksTreeModel.getTaskName((ExternalTaskExecutionInfo)e2));
    };
    @NotNull
    private final ExternalSystemUiAware myUiAware;
    @NotNull
    private final ProjectSystemId myExternalSystemId;

    public ExternalSystemTasksTreeModel(@NotNull ProjectSystemId externalSystemId) {
        super(new ExternalSystemNode<String>(new ExternalSystemNodeDescriptor<String>("", "", "", null)));
        this.myExternalSystemId = externalSystemId;
        this.myUiAware = ExternalSystemUiUtil.getUiAware(externalSystemId);
    }

    private static String getTaskName(@NotNull ExternalTaskExecutionInfo taskInfo) {
        return (String)taskInfo.getSettings().getTaskNames().get(0);
    }

    @NotNull
    public ExternalSystemNode<ExternalProjectPojo> ensureProjectNodeExists(@NotNull ExternalProjectPojo project2) {
        Object root = this.getRoot();
        for (int i = ((DefaultMutableTreeNode)root).getChildCount() - 1; i >= 0; --i) {
            ExternalProjectPojo pojo;
            TreeNode child = ((ExternalSystemNode)root).getChildAt(i);
            ExternalSystemNodeDescriptor descriptor2 = ((ExternalSystemNode)child).getDescriptor();
            Object element = descriptor2.getElement();
            if (!(element instanceof ExternalProjectPojo) || !(pojo = (ExternalProjectPojo)element).getPath().equals(project2.getPath())) continue;
            if (!pojo.getName().equals(project2.getName())) {
                pojo.setName(project2.getName());
                descriptor2.setName(project2.getName());
                this.nodeChanged(child);
            }
            return child;
        }
        ExternalProjectPojo element = new ExternalProjectPojo(project2.getName(), project2.getPath());
        ExternalSystemNodeDescriptor<ExternalProjectPojo> descriptor3 = ExternalSystemTasksTreeModel.descriptor(element, this.myUiAware.getProjectIcon());
        ExternalSystemNode<ExternalProjectPojo> result = new ExternalSystemNode<ExternalProjectPojo>(descriptor3);
        this.insertNodeInto(result, (MutableTreeNode)root);
        return result;
    }

    public void pruneNodes(@NotNull Object payload) {
        ArrayDeque<Object> toProcess = new ArrayDeque<Object>();
        toProcess.addFirst(this.getRoot());
        while (!toProcess.isEmpty()) {
            ExternalSystemNode node = (ExternalSystemNode)toProcess.removeLast();
            if (payload.equals(node.getDescriptor().getElement())) {
                this.removeNodeFromParent(node);
                continue;
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                toProcess.addFirst(node.getChildAt(i));
            }
        }
    }

    public void ensureSubProjectsStructure(@NotNull ExternalProjectPojo topLevelProject, @NotNull Collection<ExternalProjectPojo> subProjects) {
        ExternalSystemNode<ExternalProjectPojo> topLevelProjectNode = this.ensureProjectNodeExists(topLevelProject);
        HashMap toAdd = ContainerUtilRt.newHashMap();
        for (ExternalProjectPojo subProject : subProjects) {
            toAdd.put(subProject.getPath(), subProject);
        }
        toAdd.remove(topLevelProject.getPath());
        TObjectIntHashMap taskWeights = new TObjectIntHashMap();
        for (int i = 0; i < topLevelProjectNode.getChildCount(); ++i) {
            TreeNode child = topLevelProjectNode.getChildAt(i);
            Object childElement = ((ExternalSystemNode)child).getDescriptor().getElement();
            if (childElement instanceof ExternalTaskExecutionInfo) {
                taskWeights.put(childElement, subProjects.size() + i);
                continue;
            }
            if (toAdd.remove(((ExternalProjectPojo)childElement).getPath()) != null) continue;
            this.removeNodeFromParent((MutableTreeNode)child);
            --i;
        }
        if (!toAdd.isEmpty()) {
            for (Map.Entry entry : toAdd.entrySet()) {
                ExternalProjectPojo element = new ExternalProjectPojo(((ExternalProjectPojo)entry.getValue()).getName(), ((ExternalProjectPojo)entry.getValue()).getPath());
                this.insertNodeInto(new ExternalSystemNode<ExternalProjectPojo>(ExternalSystemTasksTreeModel.descriptor(element, this.myUiAware.getProjectIcon())), topLevelProjectNode);
            }
        }
    }

    public void ensureTasks(@NotNull String externalProjectConfigPath, @NotNull Collection<ExternalTaskPojo> tasks2) {
        if (tasks2.isEmpty()) {
            return;
        }
        ExternalSystemNode<ExternalProjectPojo> moduleNode = this.findProjectNode(externalProjectConfigPath);
        if (moduleNode == null) {
            return;
        }
        HashSet toAdd = ContainerUtilRt.newHashSet();
        for (ExternalTaskPojo task : tasks2) {
            toAdd.add(this.buildTaskInfo(task));
        }
        for (int i = 0; i < moduleNode.getChildCount(); ++i) {
            TreeNode childNode = moduleNode.getChildAt(i);
            Object element = ((ExternalSystemNode)childNode).getDescriptor().getElement();
            if (!(element instanceof ExternalTaskExecutionInfo) || toAdd.remove(element)) continue;
            this.removeNodeFromParent((MutableTreeNode)childNode);
            --i;
        }
        if (!toAdd.isEmpty()) {
            for (ExternalTaskExecutionInfo taskInfo : toAdd) {
                this.insertNodeInto(new ExternalSystemNode<ExternalTaskExecutionInfo>(ExternalSystemTasksTreeModel.descriptor(taskInfo, taskInfo.getDescription(), this.myUiAware.getTaskIcon())), moduleNode);
            }
        }
    }

    @NotNull
    private ExternalTaskExecutionInfo buildTaskInfo(@NotNull ExternalTaskPojo task) {
        ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
        settings.setExternalProjectPath(task.getLinkedExternalProjectPath());
        settings.setTaskNames(Collections.singletonList(task.getName()));
        settings.setTaskDescriptions(Collections.singletonList(task.getDescription()));
        settings.setExternalSystemIdString(this.myExternalSystemId.toString());
        return new ExternalTaskExecutionInfo(settings, DefaultRunExecutor.EXECUTOR_ID);
    }

    @Nullable
    private ExternalSystemNode<ExternalProjectPojo> findProjectNode(@NotNull String configPath) {
        for (int i = ((DefaultMutableTreeNode)this.getRoot()).getChildCount() - 1; i >= 0; --i) {
            TreeNode child = ((ExternalSystemNode)this.getRoot()).getChildAt(i);
            Object childElement = ((ExternalSystemNode)child).getDescriptor().getElement();
            if (childElement instanceof ExternalProjectPojo && ((ExternalProjectPojo)childElement).getPath().equals(configPath)) {
                return child;
            }
            for (int j = ((DefaultMutableTreeNode)child).getChildCount() - 1; j >= 0; --j) {
                TreeNode grandChild = ((ExternalSystemNode)child).getChildAt(j);
                Object grandChildElement = ((ExternalSystemNode)grandChild).getDescriptor().getElement();
                if (!(grandChildElement instanceof ExternalProjectPojo) || !((ExternalProjectPojo)grandChildElement).getPath().equals(configPath)) continue;
                return grandChild;
            }
        }
        return null;
    }

    @NotNull
    private static <T> ExternalSystemNodeDescriptor<T> descriptor(@NotNull T element, @Nullable Icon icon) {
        return ExternalSystemTasksTreeModel.descriptor(element, "", icon);
    }

    @NotNull
    private static <T> ExternalSystemNodeDescriptor<T> descriptor(@NotNull T element, @NotNull String description, @Nullable Icon icon) {
        return new ExternalSystemNodeDescriptor<T>(element, element.toString(), description, icon);
    }

    @Override
    @NotNull
    public ExternalSystemNode<?> getRoot() {
        return (ExternalSystemNode)super.getRoot();
    }

    public void insertNodeInto(MutableTreeNode child, MutableTreeNode parent) {
        int index = ExternalSystemTasksTreeModel.findIndexFor(child, parent);
        super.insertNodeInto(child, parent, index);
    }

    @Override
    public void insertNodeInto(MutableTreeNode child, MutableTreeNode parent, int i) {
        this.insertNodeInto(child, parent);
    }

    private static int findIndexFor(MutableTreeNode child, MutableTreeNode parent) {
        int childCount = parent.getChildCount();
        if (childCount == 0) {
            return 0;
        }
        if (childCount == 1) {
            return NODE_COMPARATOR.compare(child, parent.getChildAt(0)) <= 0 ? 0 : 1;
        }
        return ExternalSystemTasksTreeModel.findIndexFor(child, parent, 0, childCount - 1);
    }

    private static int findIndexFor(MutableTreeNode child, MutableTreeNode parent, int i1, int i2) {
        if (i1 == i2) {
            return NODE_COMPARATOR.compare(child, parent.getChildAt(i1)) <= 0 ? i1 : i1 + 1;
        }
        int half = (i1 + i2) / 2;
        if (NODE_COMPARATOR.compare(child, parent.getChildAt(half)) <= 0) {
            return ExternalSystemTasksTreeModel.findIndexFor(child, parent, i1, half);
        }
        return ExternalSystemTasksTreeModel.findIndexFor(child, parent, half + 1, i2);
    }
}

