/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleNodeVisitor;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ExternalProjectsStructure
extends SimpleTreeStructure
implements Disposable {
    private final Project myProject;
    private final SimpleTree myTree;
    private ExternalProjectsView myExternalProjectsView;
    private SimpleTreeBuilder myTreeBuilder;
    private RootNode myRoot;
    private final Map<String, ExternalSystemNode> myNodeMapping = new THashMap();

    public ExternalProjectsStructure(Project project2, SimpleTree tree) {
        this.myProject = project2;
        this.myTree = tree;
        ExternalProjectsStructure.configureTree(tree);
    }

    public void init(ExternalProjectsView externalProjectsView) {
        this.myExternalProjectsView = externalProjectsView;
        this.myRoot = new RootNode();
        this.myTreeBuilder = new SimpleTreeBuilder((JTree)this.myTree, (DefaultTreeModel)this.myTree.getModel(), (AbstractTreeStructure)this, null){};
        Disposer.register((Disposable)this.myProject, (Disposable)this.myTreeBuilder);
        this.myTreeBuilder.initRoot();
        this.myTreeBuilder.expand((Object)this.myRoot, null);
    }

    public Project getProject() {
        return this.myProject;
    }

    public void updateFrom(SimpleNode node) {
        if (node != null) {
            this.myTreeBuilder.addSubtreeToUpdateByElement((Object)node);
        }
    }

    public void updateUpTo(SimpleNode node) {
        for (SimpleNode each = node; each != null; each = each.getParent()) {
            this.updateFrom(each);
        }
    }

    @NotNull
    public Object getRootElement() {
        return this.myRoot;
    }

    private static void configureTree(SimpleTree tree) {
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
    }

    public void accept(@NotNull SimpleNodeVisitor visitor) {
        if (this.myTreeBuilder.getTree() instanceof SimpleTree) {
            ((SimpleTree)this.myTreeBuilder.getTree()).accept((AbstractTreeBuilder)this.myTreeBuilder, visitor);
        }
    }

    public void select(SimpleNode node) {
        this.myTreeBuilder.select((Object)node, null);
    }

    protected Class<? extends ExternalSystemNode>[] getVisibleNodesClasses() {
        return null;
    }

    public void updateProjects(Collection<? extends DataNode<ProjectData>> toImport) {
        List orphanProjects = ContainerUtil.mapNotNull(this.myNodeMapping.entrySet(), entry -> entry.getValue() instanceof ProjectNode ? (String)entry.getKey() : null);
        for (DataNode<ProjectData> dataNode : toImport) {
            ProjectData projectData = (ProjectData)dataNode.getData();
            String projectPath = projectData.getLinkedExternalProjectPath();
            orphanProjects.remove(projectPath);
            ExternalSystemNode projectNode = this.findNodeFor(projectPath);
            if (projectNode instanceof ProjectNode) {
                this.doMergeChildrenChanges(projectNode, dataNode, new ProjectNode(this.myExternalProjectsView, dataNode));
            } else {
                SimpleNode parent;
                ExternalSystemNode node = this.myNodeMapping.remove(projectPath);
                if (node != null && (parent = node.getParent()) instanceof ExternalSystemNode) {
                    ((ExternalSystemNode)parent).remove(projectNode);
                }
                projectNode = new ProjectNode(this.myExternalProjectsView, dataNode);
                this.myNodeMapping.put(projectPath, projectNode);
            }
            if (toImport.size() == 1) {
                this.myTreeBuilder.expand((Object)projectNode, null);
            }
            this.doUpdateProject((ProjectNode)projectNode);
        }
        for (String string : orphanProjects) {
            SimpleNode parent;
            ExternalSystemNode projectNode = this.myNodeMapping.remove(string);
            if (!(projectNode instanceof ProjectNode) || !((parent = projectNode.getParent()) instanceof ExternalSystemNode)) continue;
            ((ExternalSystemNode)parent).remove(projectNode);
            this.updateUpTo(projectNode);
        }
    }

    private void doMergeChildrenChanges(ExternalSystemNode currentNode, DataNode<?> newDataNode, ExternalSystemNode newNode) {
        ExternalSystemNode[] cached = currentNode.getCached();
        if (cached != null) {
            Object key;
            ArrayList duplicates = ContainerUtil.newArrayList();
            LinkedHashMap oldDataMap = ContainerUtil.newLinkedHashMap();
            for (ExternalSystemNode node : cached) {
                Object key2 = node.getData() != null ? node.getData() : node.getName();
                ExternalSystemNode externalSystemNode = oldDataMap.put(key2, node);
                if (externalSystemNode == null) continue;
                duplicates.add(key2);
            }
            LinkedHashMap newDataMap = ContainerUtil.newLinkedHashMap();
            LinkedHashMap unchangedNewDataMap = ContainerUtil.newLinkedHashMap();
            for (ExternalSystemNode externalSystemNode : newNode.getChildren()) {
                Object object = key = externalSystemNode.getData() != null ? externalSystemNode.getData() : externalSystemNode.getName();
                if (oldDataMap.remove(key) == null) {
                    newDataMap.put(key, externalSystemNode);
                    continue;
                }
                unchangedNewDataMap.put(key, externalSystemNode);
            }
            for (Object duplicate : duplicates) {
                newDataMap.remove(duplicate);
            }
            currentNode.removeAll(oldDataMap.values());
            for (ExternalSystemNode externalSystemNode : currentNode.getChildren()) {
                key = externalSystemNode.getData() != null ? externalSystemNode.getData() : externalSystemNode.getName();
                ExternalSystemNode unchangedNewNode = (ExternalSystemNode)unchangedNewDataMap.get(key);
                if (unchangedNewNode == null) continue;
                this.doMergeChildrenChanges(externalSystemNode, unchangedNewNode.myDataNode, unchangedNewNode);
            }
            this.updateFrom(currentNode);
            currentNode.mergeWith(newNode);
            currentNode.addAll(newDataMap.values());
        } else {
            currentNode.mergeWith(newNode);
        }
    }

    private void doUpdateProject(ProjectNode node) {
        RootNode newParentNode = this.myRoot;
        if (!node.isVisible()) {
            newParentNode.remove(node);
        } else {
            node.updateProject();
            ExternalProjectsStructure.reconnectNode(node, newParentNode);
        }
    }

    private static void reconnectNode(ProjectNode node, ExternalSystemNode newParentNode) {
        ExternalSystemNode oldParentNode = node.getGroup();
        if (oldParentNode == null || !oldParentNode.equals(newParentNode)) {
            if (oldParentNode != null) {
                oldParentNode.remove(node);
            }
            newParentNode.add(node);
        }
    }

    private ExternalSystemNode findNodeFor(String projectPath) {
        return this.myNodeMapping.get(projectPath);
    }

    public <T extends ExternalSystemNode> void updateNodes(@NotNull Class<? extends T> nodeClass) {
        for (ExternalSystemNode node : this.getNodes(nodeClass)) {
            this.updateFrom(node);
        }
    }

    public <T extends ExternalSystemNode> void visitNodes(@NotNull Class<? extends T> nodeClass, @NotNull Consumer<? super T> consumer) {
        for (ExternalSystemNode node : this.getNodes(nodeClass)) {
            consumer.consume((Object)node);
        }
    }

    public void dispose() {
        this.myExternalProjectsView = null;
        this.myNodeMapping.clear();
        this.myRoot = null;
    }

    @NotNull
    public <T extends ExternalSystemNode> List<T> getNodes(@NotNull Class<T> nodeClass) {
        return ExternalProjectsStructure.doGetNodes(nodeClass, this.myRoot.getChildren(), new SmartList());
    }

    @NotNull
    private static <T extends ExternalSystemNode> List<T> doGetNodes(@NotNull Class<T> nodeClass, SimpleNode[] nodes, @NotNull List<T> result) {
        if (nodes == null) {
            return result;
        }
        for (SimpleNode node : nodes) {
            if (nodeClass.isInstance(node)) {
                result.add((ExternalSystemNode)node);
            }
            ExternalProjectsStructure.doGetNodes(nodeClass, node.getChildren(), result);
        }
        return result;
    }

    @NotNull
    public <T extends ExternalSystemNode> List<T> getSelectedNodes(SimpleTree tree, Class<T> nodeClass) {
        ArrayList<ExternalSystemNode> filtered = new ArrayList<ExternalSystemNode>();
        for (SimpleNode node : ExternalProjectsStructure.getSelectedNodes(tree)) {
            if (nodeClass != null && !nodeClass.isInstance(node)) {
                filtered.clear();
                break;
            }
            filtered.add((ExternalSystemNode)node);
        }
        return filtered;
    }

    private static List<SimpleNode> getSelectedNodes(SimpleTree tree) {
        ArrayList<SimpleNode> nodes = new ArrayList<SimpleNode>();
        TreePath[] treePaths = tree.getSelectionPaths();
        if (treePaths != null) {
            for (TreePath treePath : treePaths) {
                nodes.add(tree.getNodeFor(treePath));
            }
        }
        return nodes;
    }

    static enum DisplayKind {
        ALWAYS,
        NEVER,
        NORMAL;

    }

    public static enum ErrorLevel {
        NONE,
        ERROR;

    }

    public class RootNode<T>
    extends ExternalSystemNode<T> {
        public RootNode() {
            super(ExternalProjectsStructure.this.myExternalProjectsView, null, null);
        }

        @Override
        public boolean isVisible() {
            return true;
        }
    }
}

