/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemShortcutsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsStructure;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExternalSystemNode<T>
extends SimpleNode
implements Comparable<ExternalSystemNode> {
    public static final int BUILTIN_TASKS_DATA_NODE_ORDER = 10;
    public static final int BUILTIN_DEPENDENCIES_DATA_NODE_ORDER = 20;
    public static final int BUILTIN_RUN_CONFIGURATIONS_DATA_NODE_ORDER = 30;
    public static final int BUILTIN_MODULE_DATA_NODE_ORDER = 40;
    @NotNull
    public static final Comparator<ExternalSystemNode> ORDER_AWARE_COMPARATOR = new Comparator<ExternalSystemNode>(){

        @Override
        public int compare(@NotNull ExternalSystemNode o1, @NotNull ExternalSystemNode o2) {
            int order2;
            int order1 = this.getOrder(o1);
            if (order1 == (order2 = this.getOrder(o2))) {
                return o1.compareTo(o2);
            }
            return order1 < order2 ? -1 : 1;
        }

        private int getOrder(@NotNull Comparable o) {
            Order annotation = o.getClass().getAnnotation(Order.class);
            if (annotation != null) {
                return annotation.value();
            }
            return 0;
        }
    };
    protected static final ExternalSystemNode[] NO_CHILDREN = new ExternalSystemNode[0];
    private static final List<ExternalSystemNode<?>> NO_CHILDREN_LIST = Collections.emptyList();
    private static final List<String> NO_ERRORS_LIST = Collections.emptyList();
    private final ExternalProjectsView myExternalProjectsView;
    private List<ExternalSystemNode<?>> myChildrenList = NO_CHILDREN_LIST;
    protected DataNode<T> myDataNode;
    @Nullable
    private ExternalSystemNode myParent;
    private ExternalSystemNode[] myChildren;
    private ExternalProjectsStructure.ErrorLevel myErrorLevel = ExternalProjectsStructure.ErrorLevel.NONE;
    private List<String> myErrors = NO_ERRORS_LIST;
    private ExternalProjectsStructure.ErrorLevel myTotalErrorLevel = null;

    public ExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @Nullable ExternalSystemNode parent) {
        this(externalProjectsView, parent, null);
    }

    public ExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @Nullable ExternalSystemNode parent, @Nullable DataNode<T> dataNode) {
        super(externalProjectsView.getProject(), null);
        this.myExternalProjectsView = externalProjectsView;
        this.myDataNode = dataNode;
        this.myParent = parent;
    }

    public boolean isAutoExpandNode() {
        SimpleNode parent = this.getParent();
        return parent != null && parent.getChildCount() == 1;
    }

    public void setParent(@Nullable ExternalSystemNode parent) {
        this.myParent = parent;
    }

    @Nullable
    public T getData() {
        return (T)(this.myDataNode != null ? this.myDataNode.getData() : null);
    }

    public NodeDescriptor getParentDescriptor() {
        return this.myParent;
    }

    public String getName() {
        String displayName2 = this.getExternalProjectsView().getDisplayName(this.myDataNode);
        return displayName2 == null ? super.getName() : displayName2;
    }

    protected ExternalProjectsView getExternalProjectsView() {
        return this.myExternalProjectsView;
    }

    protected ExternalSystemUiAware getUiAware() {
        return this.myExternalProjectsView.getUiAware();
    }

    protected ExternalProjectsStructure getStructure() {
        return this.myExternalProjectsView.getStructure();
    }

    protected ExternalSystemShortcutsManager getShortcutsManager() {
        return this.myExternalProjectsView.getShortcutsManager();
    }

    protected ExternalSystemTaskActivator getTaskActivator() {
        return this.myExternalProjectsView.getTaskActivator();
    }

    @Nullable
    public <DataType extends ExternalSystemNode> DataType findParent(Class<DataType> parentClass) {
        ExternalSystemNode node = this;
        while ((node = node.myParent) != null && !parentClass.isInstance(node)) {
        }
        return (DataType)node;
    }

    @Nullable
    public <DataType> DataType findParentData(Class<DataType> parentDataClass) {
        ExternalSystemNode node = this;
        do {
            if ((node = node.myParent) != null) continue;
            return null;
        } while (node.getData() == null || !parentDataClass.isInstance(node.getData()));
        return (DataType)node.getData();
    }

    public boolean isVisible() {
        return this.getDisplayKind() != ExternalProjectsStructure.DisplayKind.NEVER && (!this.isIgnored() || this.myExternalProjectsView.getShowIgnored());
    }

    public boolean isIgnored() {
        if (this.myDataNode != null) {
            return this.myDataNode.isIgnored();
        }
        SimpleNode parent = this.getParent();
        return parent instanceof ExternalSystemNode && ((ExternalSystemNode)parent).isIgnored();
    }

    public void setIgnored(boolean ignored) {
        if (this.myDataNode != null) {
            ExternalProjectsManager.getInstance((Project)this.myExternalProjectsView.getProject()).setIgnored(this.myDataNode, ignored);
        }
    }

    public ExternalProjectsStructure.DisplayKind getDisplayKind() {
        Class<? extends ExternalSystemNode>[] visibles = this.getStructure().getVisibleNodesClasses();
        if (visibles == null) {
            return ExternalProjectsStructure.DisplayKind.NORMAL;
        }
        for (Class<? extends ExternalSystemNode> each : visibles) {
            if (!each.isInstance(this)) continue;
            return ExternalProjectsStructure.DisplayKind.ALWAYS;
        }
        return ExternalProjectsStructure.DisplayKind.NEVER;
    }

    @NotNull
    public final ExternalSystemNode[] getChildren() {
        if (this.myChildren == null) {
            this.myChildren = this.buildChildren();
            this.onChildrenBuilt();
        }
        return this.myChildren;
    }

    protected void onChildrenBuilt() {
    }

    @NotNull
    private ExternalSystemNode[] buildChildren() {
        List<ExternalSystemNode> newChildrenCandidates = this.doBuildChildren();
        if (newChildrenCandidates.isEmpty()) {
            return NO_CHILDREN;
        }
        this.addAll(newChildrenCandidates, true);
        this.sort(this.myChildrenList);
        ArrayList visibleNodes = new ArrayList();
        for (ExternalSystemNode<?> each : this.myChildrenList) {
            if (!each.isVisible()) continue;
            visibleNodes.add(each);
        }
        return visibleNodes.toArray(new ExternalSystemNode[0]);
    }

    public void cleanUpCache() {
        this.myChildren = null;
        this.myChildrenList = NO_CHILDREN_LIST;
        this.myTotalErrorLevel = null;
    }

    @Nullable
    protected ExternalSystemNode[] getCached() {
        return this.myChildren;
    }

    protected void sort(List<? extends ExternalSystemNode> list) {
        if (!list.isEmpty()) {
            Collections.sort(list, ORDER_AWARE_COMPARATOR);
        }
    }

    public boolean addAll(Collection<? extends ExternalSystemNode> externalSystemNodes) {
        return this.addAll(externalSystemNodes, false);
    }

    private boolean addAll(Collection<? extends ExternalSystemNode> externalSystemNodes, boolean silently) {
        if (externalSystemNodes.isEmpty()) {
            return false;
        }
        if (this.myChildrenList == NO_CHILDREN_LIST) {
            this.myChildrenList = new ArrayList();
        }
        for (ExternalSystemNode externalSystemNode : externalSystemNodes) {
            externalSystemNode.setParent(this);
            this.myChildrenList.add(externalSystemNode);
        }
        if (!silently) {
            this.childrenChanged();
        }
        return true;
    }

    public boolean add(ExternalSystemNode externalSystemNode) {
        return this.addAll(ContainerUtil.list((Object[])new ExternalSystemNode[]{externalSystemNode}));
    }

    public boolean removeAll(Collection<ExternalSystemNode> externalSystemNodes) {
        return this.removeAll(externalSystemNodes, false);
    }

    private boolean removeAll(Collection<ExternalSystemNode> externalSystemNodes, boolean silently) {
        if (externalSystemNodes.isEmpty()) {
            return false;
        }
        for (ExternalSystemNode externalSystemNode : externalSystemNodes) {
            externalSystemNode.setParent(null);
            if (this.myChildrenList == NO_CHILDREN_LIST) continue;
            this.myChildrenList.remove(externalSystemNode);
        }
        if (!silently) {
            this.childrenChanged();
        }
        return true;
    }

    public void remove(ExternalSystemNode externalSystemNode) {
        this.removeAll(ContainerUtil.list((Object[])new ExternalSystemNode[]{externalSystemNode}));
    }

    protected void childrenChanged() {
        for (ExternalSystemNode each = this; each != null; each = (ExternalSystemNode)each.getParent()) {
            each.myTotalErrorLevel = null;
        }
        this.sort(this.myChildrenList);
        List visibleNodes = ContainerUtil.filter(this.myChildrenList, node -> node.isVisible());
        this.myChildren = visibleNodes.toArray(new ExternalSystemNode[0]);
        this.myExternalProjectsView.updateUpTo(this);
    }

    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    @NotNull
    protected List<? extends ExternalSystemNode> doBuildChildren() {
        if (this.myDataNode != null && !this.myDataNode.getChildren().isEmpty()) {
            ExternalProjectsView externalProjectsView = this.getExternalProjectsView();
            return externalProjectsView.createNodes(externalProjectsView, this, this.myDataNode);
        }
        return this.myChildrenList;
    }

    protected void setDataNode(DataNode<T> dataNode) {
        this.myDataNode = dataNode;
    }

    public ExternalProjectsStructure.ErrorLevel getTotalErrorLevel() {
        if (this.myTotalErrorLevel == null) {
            this.myTotalErrorLevel = this.calcTotalErrorLevel();
        }
        return this.myTotalErrorLevel;
    }

    private ExternalProjectsStructure.ErrorLevel calcTotalErrorLevel() {
        ExternalProjectsStructure.ErrorLevel childrenErrorLevel = this.getChildrenErrorLevel();
        return childrenErrorLevel.compareTo(this.myErrorLevel) > 0 ? childrenErrorLevel : this.myErrorLevel;
    }

    public ExternalProjectsStructure.ErrorLevel getChildrenErrorLevel() {
        ExternalProjectsStructure.ErrorLevel result = ExternalProjectsStructure.ErrorLevel.NONE;
        for (ExternalSystemNode each : this.getChildren()) {
            ExternalProjectsStructure.ErrorLevel eachLevel = each.getTotalErrorLevel();
            if (eachLevel.compareTo(result) <= 0) continue;
            result = eachLevel;
        }
        return result;
    }

    public void setErrorLevel(ExternalProjectsStructure.ErrorLevel level, String ... errors) {
        if (this.myErrorLevel == level) {
            return;
        }
        this.myErrorLevel = level;
        this.myErrors = errors.length == 0 ? NO_ERRORS_LIST : Arrays.asList(errors);
        this.myExternalProjectsView.updateUpTo(this);
    }

    protected void doUpdate() {
        this.setNameAndTooltip(this.getName(), null);
    }

    protected void setNameAndTooltip(String name2, @Nullable String tooltip) {
        this.setNameAndTooltip(name2, tooltip, (String)null);
    }

    protected void setNameAndTooltip(String name2, @Nullable String tooltip, @Nullable String hint) {
        boolean ignored = this.isIgnored();
        SimpleTextAttributes textAttributes = ignored ? SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES : this.getPlainAttributes();
        this.setNameAndTooltip(name2, tooltip, textAttributes);
        if (!StringUtil.isEmptyOrSpaces((String)hint)) {
            this.addColoredFragment(" (" + hint + ")", ignored ? SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    protected void setNameAndTooltip(String name2, @Nullable String tooltip, SimpleTextAttributes attributes) {
        this.clearColoredText();
        this.addColoredFragment(name2, this.prepareAttributes(attributes));
        String s = (tooltip != null ? tooltip + "\n\r" : "") + StringUtil.join(this.myErrors, (String)"\n\r");
        this.getTemplatePresentation().setTooltip(s);
    }

    private SimpleTextAttributes prepareAttributes(SimpleTextAttributes from) {
        ExternalProjectsStructure.ErrorLevel level = this.getTotalErrorLevel();
        JBColor waveColor = level == ExternalProjectsStructure.ErrorLevel.NONE ? null : JBColor.RED;
        int style = from.getStyle();
        if (waveColor != null) {
            style |= 8;
        }
        return new SimpleTextAttributes(from.getBgColor(), from.getFgColor(), (Color)waveColor, style);
    }

    @Nullable
    @NonNls
    protected String getActionId() {
        return null;
    }

    @Nullable
    @NonNls
    protected String getMenuId() {
        return null;
    }

    protected String message(@NotNull String key, Object ... params) {
        return ExternalSystemBundle.message((String)key, (Object[])params);
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    @Nullable
    public Navigatable getNavigatable() {
        return null;
    }

    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
        String actionId = this.getActionId();
        this.getExternalProjectsView().handleDoubleClickOrEnter(this, actionId, inputEvent);
    }

    @Override
    public int compareTo(@NotNull ExternalSystemNode node) {
        return StringUtil.compare((String)this.getName(), (String)node.getName(), (boolean)true);
    }

    public void mergeWith(ExternalSystemNode<T> node) {
        this.setDataNode(node.myDataNode);
    }
}

