/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractDependencyData;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsStructure;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ExternalSystemViewContributor;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.TasksNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemViewDefaultContributor
extends ExternalSystemViewContributor {
    private static final Key<?>[] KEYS = new Key[]{ProjectKeys.MODULE, ProjectKeys.MODULE_DEPENDENCY, ProjectKeys.LIBRARY_DEPENDENCY, ProjectKeys.TASK};

    @Override
    @NotNull
    public ProjectSystemId getSystemId() {
        return ProjectSystemId.IDE;
    }

    @Override
    @NotNull
    public List<Key<?>> getKeys() {
        return Arrays.asList(KEYS);
    }

    @Override
    @NotNull
    public List<ExternalSystemNode<?>> createNodes(ExternalProjectsView externalProjectsView, MultiMap<Key<?>, DataNode<?>> dataNodes) {
        SmartList result = new SmartList();
        ExternalSystemViewDefaultContributor.addModuleNodes(externalProjectsView, dataNodes, result);
        Collection tasksNodes = dataNodes.get((Object)ProjectKeys.TASK);
        if (!tasksNodes.isEmpty()) {
            TasksNode tasksNode = new TasksNode(externalProjectsView, tasksNodes);
            if (externalProjectsView.useTasksNode()) {
                result.add(tasksNode);
            } else {
                ContainerUtil.addAll((Collection)result, (Object[])tasksNode.getChildren());
            }
        }
        ExternalSystemViewDefaultContributor.addDependenciesNode(externalProjectsView, dataNodes, result);
        return result;
    }

    @Override
    @Nullable
    public String getDisplayName(@NotNull DataNode node) {
        return ExternalSystemViewDefaultContributor.getNodeDisplayName(node);
    }

    private static void addDependenciesNode(@NotNull ExternalProjectsView externalProjectsView, @NotNull MultiMap<Key<?>, DataNode<?>> dataNodes, @NotNull List<? super ExternalSystemNode<?>> result) {
        Collection moduleDeps = dataNodes.get((Object)ProjectKeys.MODULE_DEPENDENCY);
        Collection libDeps = dataNodes.get((Object)ProjectKeys.LIBRARY_DEPENDENCY);
        if (!moduleDeps.isEmpty() || !libDeps.isEmpty()) {
            MyDependenciesNode depNode = new MyDependenciesNode(externalProjectsView);
            boolean addDepNode = false;
            for (DataNode dataNode : moduleDeps) {
                if (!(dataNode.getData() instanceof ModuleDependencyData)) continue;
                ModuleDependencyDataExternalSystemNode moduleDependencyDataExternalSystemNode = new ModuleDependencyDataExternalSystemNode(externalProjectsView, (DataNode<ModuleDependencyData>)dataNode);
                if (dataNode.getParent() != null && dataNode.getParent().getData() instanceof AbstractDependencyData) {
                    result.add(moduleDependencyDataExternalSystemNode);
                    continue;
                }
                depNode.add(moduleDependencyDataExternalSystemNode);
                addDepNode = true;
            }
            for (DataNode dataNode : libDeps) {
                if (!(dataNode.getData() instanceof LibraryDependencyData)) continue;
                LibraryDependencyDataExternalSystemNode libraryDependencyDataExternalSystemNode = new LibraryDependencyDataExternalSystemNode(externalProjectsView, (DataNode<LibraryDependencyData>)dataNode);
                if (((LibraryData)((LibraryDependencyData)dataNode.getData()).getTarget()).isUnresolved()) {
                    libraryDependencyDataExternalSystemNode.setErrorLevel(ExternalProjectsStructure.ErrorLevel.ERROR, "Unable to resolve " + ((LibraryData)((LibraryDependencyData)dataNode.getData()).getTarget()).getExternalName());
                } else {
                    libraryDependencyDataExternalSystemNode.setErrorLevel(ExternalProjectsStructure.ErrorLevel.NONE, new String[0]);
                }
                if (dataNode.getParent() != null && dataNode.getParent().getData() instanceof ModuleData) {
                    depNode.add(libraryDependencyDataExternalSystemNode);
                    addDepNode = true;
                    continue;
                }
                result.add(libraryDependencyDataExternalSystemNode);
            }
            if (addDepNode) {
                result.add(depNode);
            }
        }
    }

    private static void addModuleNodes(@NotNull ExternalProjectsView externalProjectsView, @NotNull MultiMap<Key<?>, DataNode<?>> dataNodes, @NotNull List<? super ExternalSystemNode<?>> result) {
        Collection moduleDataNodes = dataNodes.get((Object)ProjectKeys.MODULE);
        if (!moduleDataNodes.isEmpty()) {
            AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)externalProjectsView.getProject(), (ProjectSystemId)externalProjectsView.getSystemId());
            Map groupToModule = ContainerUtil.newHashMap((int)moduleDataNodes.size());
            ArrayList moduleNodes = ContainerUtil.newArrayList();
            for (DataNode dataNode : moduleDataNodes) {
                ModuleData data = (ModuleData)dataNode.getData();
                ExternalProjectSettings projectSettings = systemSettings.getLinkedProjectSettings(data.getLinkedExternalProjectPath());
                DataNode projectDataNode = ExternalSystemApiUtil.findParent((DataNode)dataNode, (Key)ProjectKeys.PROJECT);
                boolean isRoot = projectSettings != null && data.getLinkedExternalProjectPath().equals(projectSettings.getExternalProjectPath()) && projectDataNode != null && ((ProjectData)projectDataNode.getData()).getInternalName().equals(data.getInternalName());
                ModuleNode moduleNode = new ModuleNode(externalProjectsView, (DataNode<ModuleData>)dataNode, null, isRoot);
                moduleNodes.add(moduleNode);
                String group = moduleNode.getIdeGrouping();
                if (group == null) continue;
                groupToModule.put(group, moduleNode);
            }
            for (ModuleNode moduleNode : moduleNodes) {
                ModuleNode parent;
                moduleNode.setAllModules(moduleNodes);
                String parentGroup = moduleNode.getIdeParentGrouping();
                ModuleNode moduleNode2 = parent = parentGroup != null ? (ModuleNode)groupToModule.get(parentGroup) : null;
                if (parent == null) continue;
                moduleNode.setParent(parent);
            }
            result.addAll(moduleNodes);
        }
    }

    @NotNull
    private static String getNodeDisplayName(@NotNull DataNode node) {
        Object data = node.getData();
        if (data instanceof LibraryDependencyData) {
            LibraryDependencyData libraryDependencyData = (LibraryDependencyData)data;
            String externalName = libraryDependencyData.getExternalName();
            if (StringUtil.isEmpty((String)externalName)) {
                Set paths = ((LibraryData)libraryDependencyData.getTarget()).getPaths(LibraryPathType.BINARY);
                if (paths.size() == 1) {
                    String relativePathToRoot = null;
                    String path = ExternalSystemApiUtil.toCanonicalPath((String)((String)paths.iterator().next()));
                    DataNode projectDataDataNode = ExternalSystemApiUtil.findParent((DataNode)node, (Key)ProjectKeys.PROJECT);
                    if (projectDataDataNode != null) {
                        relativePathToRoot = FileUtil.getRelativePath((String)((ProjectData)projectDataDataNode.getData()).getLinkedExternalProjectPath(), (String)path, (char)'/');
                        relativePathToRoot = relativePathToRoot != null && StringUtil.startsWith((CharSequence)relativePathToRoot, (CharSequence)"../../") ? new File(relativePathToRoot).getName() : relativePathToRoot;
                    }
                    return (String)ObjectUtils.notNull(relativePathToRoot, (Object)path);
                }
                return "<file set>";
            }
            return externalName;
        }
        if (data instanceof Named) {
            return ((Named)data).getExternalName();
        }
        if (data instanceof TaskData) {
            return ((TaskData)data).getName();
        }
        return StringUtil.notNullize((String)node.toString());
    }

    private static class LibraryDependencyDataExternalSystemNode
    extends DependencyDataExternalSystemNode<LibraryDependencyData> {
        LibraryDependencyDataExternalSystemNode(ExternalProjectsView externalProjectsView, DataNode<LibraryDependencyData> dataNode) {
            super(externalProjectsView, null, dataNode);
        }

        protected void update(@NotNull PresentationData presentation) {
            super.update(presentation);
            presentation.setIcon(AllIcons.Nodes.PpLib);
            LibraryDependencyData data = (LibraryDependencyData)this.getData();
            if (data != null) {
                this.setNameAndTooltip(this.getName(), null, data.getScope().getDisplayName());
            }
        }
    }

    private static class ModuleDependencyDataExternalSystemNode
    extends DependencyDataExternalSystemNode<ModuleDependencyData> {
        ModuleDependencyDataExternalSystemNode(ExternalProjectsView externalProjectsView, DataNode<ModuleDependencyData> dataNode) {
            super(externalProjectsView, null, dataNode);
        }

        protected void update(@NotNull PresentationData presentation) {
            super.update(presentation);
            presentation.setIcon(this.getUiAware().getProjectIcon());
            ModuleDependencyData data = (ModuleDependencyData)this.getData();
            if (data != null) {
                this.setNameAndTooltip(this.getName(), null, data.getScope().getDisplayName());
            }
        }

        @Override
        public ExternalProjectsStructure.ErrorLevel getChildrenErrorLevel() {
            return ExternalProjectsStructure.ErrorLevel.NONE;
        }
    }

    private static abstract class DependencyDataExternalSystemNode<T extends DependencyData>
    extends ExternalSystemNode<T> {
        DependencyDataExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @Nullable ExternalSystemNode parent, @Nullable DataNode<T> dataNode) {
            super(externalProjectsView, parent, dataNode);
        }

        @Override
        @Nullable
        public Navigatable getNavigatable() {
            return new Navigatable(){
                @Nullable
                private OrderEntry myOrderEntry;

                public void navigate(boolean requestFocus) {
                    if (this.myOrderEntry != null) {
                        ProjectSettingsService.getInstance((Project)myProject).openModuleDependenciesSettings(this.myOrderEntry.getOwnerModule(), this.myOrderEntry);
                    }
                }

                public boolean canNavigate() {
                    this.myOrderEntry = this.getOrderEntry();
                    return this.myOrderEntry != null;
                }

                public boolean canNavigateToSource() {
                    return true;
                }
            };
        }

        @Nullable
        private OrderEntry getOrderEntry() {
            DependencyData data = (DependencyData)this.getData();
            if (data == null) {
                return null;
            }
            Project project2 = this.getProject();
            if (project2 == null) {
                return null;
            }
            return new IdeModelsProviderImpl(project2).findIdeModuleOrderEntry(data);
        }

        @Override
        public int compareTo(@NotNull ExternalSystemNode node) {
            int order2;
            int order1;
            DependencyData myData = (DependencyData)this.getData();
            Object thatData = node.getData();
            if (myData instanceof OrderAware && thatData instanceof OrderAware && (order1 = ((OrderAware)myData).getOrder()) != (order2 = ((OrderAware)thatData).getOrder())) {
                return order1 < order2 ? -1 : 1;
            }
            String dependencyName = DependencyDataExternalSystemNode.getDependencySimpleName(this);
            String thatDependencyName = DependencyDataExternalSystemNode.getDependencySimpleName(node);
            return StringUtil.compare((String)dependencyName, (String)thatDependencyName, (boolean)true);
        }

        @NotNull
        private static String getDependencySimpleName(@NotNull ExternalSystemNode node) {
            Set paths;
            LibraryDependencyData dependencyData;
            String externalName;
            Object thatData = node.getData();
            if (thatData instanceof LibraryDependencyData && StringUtil.isEmpty((String)(externalName = (dependencyData = (LibraryDependencyData)thatData).getExternalName())) && (paths = ((LibraryData)dependencyData.getTarget()).getPaths(LibraryPathType.BINARY)).size() == 1) {
                return new File((String)paths.iterator().next()).getName();
            }
            return node.getName();
        }
    }

    @Order(value=20)
    private static class MyDependenciesNode
    extends ExternalSystemNode {
        MyDependenciesNode(ExternalProjectsView externalProjectsView) {
            super(externalProjectsView, null, null);
        }

        protected void update(@NotNull PresentationData presentation) {
            super.update(presentation);
            presentation.setIcon(AllIcons.Nodes.PpLibFolder);
        }

        @Override
        public String getName() {
            return "Dependencies";
        }
    }
}

