/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ConfigurationError;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.PairProcessor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.awt.EventQueue;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public interface ConfigurationErrors {
    public static final Topic<ConfigurationErrors> TOPIC = Topic.create((String)"Configuration Error", ConfigurationErrors.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.NONE);

    public void addError(@NotNull ConfigurationError var1);

    public void removeError(@NotNull ConfigurationError var1);

    public static class Bus {
        public static void addError(@NotNull ConfigurationError error, @NotNull Project project2) {
            Bus._do(error, project2, (PairProcessor<? super ConfigurationErrors, ? super ConfigurationError>)((PairProcessor)(configurationErrors, configurationError) -> {
                configurationErrors.addError((ConfigurationError)configurationError);
                return false;
            }));
        }

        public static void removeError(@NotNull ConfigurationError error, @NotNull Project project2) {
            Bus._do(error, project2, (PairProcessor<? super ConfigurationErrors, ? super ConfigurationError>)((PairProcessor)(configurationErrors, configurationError) -> {
                configurationErrors.removeError((ConfigurationError)configurationError);
                return false;
            }));
        }

        private static void _do(@NotNull ConfigurationError error, @NotNull Project project2, @NotNull PairProcessor<? super ConfigurationErrors, ? super ConfigurationError> fun) {
            if (!project2.isInitialized()) {
                StartupManager.getInstance((Project)project2).runWhenProjectIsInitialized(() -> fun.process(project2.getMessageBus().syncPublisher(TOPIC), (Object)error));
                return;
            }
            MessageBus bus = project2.getMessageBus();
            if (EventQueue.isDispatchThread()) {
                fun.process(bus.syncPublisher(TOPIC), (Object)error);
            } else {
                SwingUtilities.invokeLater(() -> fun.process(bus.syncPublisher(TOPIC), (Object)error));
            }
        }
    }
}

