/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkListConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkComboBox
extends ComboBoxWithWidePopup<JdkComboBoxItem> {
    private static final Icon EMPTY_ICON = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)1, (int)16));
    @Nullable
    private final Condition<? super Sdk> myFilter;
    @Nullable
    private final Condition<SdkTypeId> myCreationFilter;
    private JButton mySetUpButton;
    private final Condition<? super SdkTypeId> mySdkTypeFilter;

    public JdkComboBox(@NotNull ProjectSdksModel jdkModel) {
        this(jdkModel, null);
    }

    public JdkComboBox(@NotNull ProjectSdksModel jdkModel, @Nullable Condition<? super SdkTypeId> filter) {
        this(jdkModel, filter, JdkComboBox.getSdkFilter(filter), filter, false);
    }

    public JdkComboBox(final @NotNull ProjectSdksModel jdkModel, @Nullable Condition<? super SdkTypeId> sdkTypeFilter, @Nullable Condition<? super Sdk> filter, @Nullable Condition<? super SdkTypeId> creationFilter, boolean addSuggestedItems) {
        super((ComboBoxModel)new JdkComboBoxModel(jdkModel, sdkTypeFilter, filter, addSuggestedItems));
        this.myFilter = filter;
        this.mySdkTypeFilter = sdkTypeFilter;
        this.myCreationFilter = JdkComboBox.getCreationFilter(creationFilter);
        this.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JdkComboBoxItem>(){

            protected void customizeCellRenderer(@NotNull JList<? extends JdkComboBoxItem> list, JdkComboBoxItem value, int index, boolean selected, boolean hasFocus) {
                if (JdkComboBox.this.isEnabled()) {
                    this.setIcon(EMPTY_ICON);
                    if (value instanceof InvalidJdkComboBoxItem) {
                        String str = value.toString();
                        this.append(str, SimpleTextAttributes.ERROR_ATTRIBUTES);
                    } else if (value instanceof ProjectJdkComboBoxItem) {
                        Sdk jdk = jdkModel.getProjectSdk();
                        if (jdk != null) {
                            this.setIcon(((SdkType)jdk.getSdkType()).getIcon());
                            this.append(ProjectBundle.message((String)"project.roots.project.jdk.inherited", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                            this.append(" (" + jdk.getName() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        } else {
                            String str = value.toString();
                            this.append(str, SimpleTextAttributes.ERROR_ATTRIBUTES);
                        }
                    } else if (value instanceof SuggestedJdkItem) {
                        SdkType type = ((SuggestedJdkItem)value).getSdkType();
                        String home = ((SuggestedJdkItem)value).getPath();
                        this.setIcon(type.getIconForAddAction());
                        String version = type.getVersionString(home);
                        this.append(version == null ? type.getPresentableName() : version);
                        this.append(" (" + home + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    } else if (value != null) {
                        OrderEntryAppearanceService.getInstance().forJdk(value.getJdk(), false, selected, true).customize((SimpleColoredComponent)this);
                    } else {
                        this.customizeCellRenderer(list, new NoneJdkComboBoxItem(), index, selected, hasFocus);
                    }
                }
            }
        });
    }

    @NotNull
    private static Condition<SdkTypeId> getCreationFilter(@Nullable Condition<? super SdkTypeId> creationFilter) {
        return SimpleJavaSdkType.notSimpleJavaSdkType(creationFilter);
    }

    public Dimension getPreferredSize() {
        Rectangle rec = ScreenUtil.getScreenRectangle((int)0, (int)0);
        Dimension size = super.getPreferredSize();
        int maxWidth = rec.width / 4;
        if (size.width > maxWidth) {
            size.width = maxWidth;
        }
        return size;
    }

    public Dimension getMinimumSize() {
        Dimension minSize = super.getMinimumSize();
        Dimension prefSize = this.getPreferredSize();
        if (minSize.width > prefSize.width) {
            minSize.width = prefSize.width;
        }
        return minSize;
    }

    public void setSetupButton(JButton setUpButton, @Nullable Project project2, ProjectSdksModel jdksModel, JdkComboBoxItem firstItem, @Nullable Condition<Sdk> additionalSetup, boolean moduleJdkSetup) {
        this.setSetupButton(setUpButton, project2, jdksModel, firstItem, additionalSetup, ProjectBundle.message((String)"project.roots.set.up.jdk.title", (Object[])new Object[]{moduleJdkSetup ? 1 : 2}));
    }

    public void setSetupButton(JButton setUpButton, @Nullable Project project2, ProjectSdksModel jdksModel, JdkComboBoxItem firstItem, @Nullable Condition<? super Sdk> additionalSetup, String actionGroupTitle) {
        this.mySetUpButton = setUpButton;
        this.mySetUpButton.addActionListener(e -> {
            DefaultActionGroup group = new DefaultActionGroup();
            jdksModel.createAddActions(group, (JComponent)((Object)this), this.getSelectedJdk(), jdk -> {
                if (project2 != null) {
                    JdkListConfigurable configurable = JdkListConfigurable.getInstance(project2);
                    configurable.addJdkNode((Sdk)jdk, false);
                }
                this.reloadModel(new ActualJdkComboBoxItem((Sdk)jdk), project2);
                this.setSelectedJdk((Sdk)jdk);
                if (additionalSetup != null && additionalSetup.value(jdk)) {
                    this.setSelectedJdk(firstItem.getJdk());
                }
            }, this.myCreationFilter);
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
            if (group.getChildrenCount() > 1) {
                JBPopupFactory.getInstance().createActionGroupPopup(actionGroupTitle, (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.MNEMONICS, false).showUnderneathOf((Component)setUpButton);
            } else {
                AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", new Presentation(""), ActionManager.getInstance(), 0);
                group.getChildren(event)[0].actionPerformed(event);
            }
        });
    }

    public void setEditButton(JButton editButton, Project project2, Computable<? extends Sdk> retrieveJDK) {
        editButton.addActionListener(e -> {
            Sdk projectJdk = (Sdk)retrieveJDK.compute();
            if (projectJdk != null) {
                ProjectStructureConfigurable.getInstance(project2).select(projectJdk, true);
            }
        });
        this.addActionListener(e -> {
            JdkComboBoxItem selectedItem = this.getSelectedItem();
            if (selectedItem instanceof ProjectJdkComboBoxItem) {
                editButton.setEnabled(ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel().getProjectSdk() != null);
            } else {
                editButton.setEnabled(!(selectedItem instanceof InvalidJdkComboBoxItem) && selectedItem != null && selectedItem.getJdk() != null);
            }
        });
    }

    public JButton getSetUpButton() {
        return this.mySetUpButton;
    }

    public JdkComboBoxItem getSelectedItem() {
        return (JdkComboBoxItem)super.getSelectedItem();
    }

    @Nullable
    public Sdk getSelectedJdk() {
        JdkComboBoxItem selectedItem = this.getSelectedItem();
        return selectedItem != null ? selectedItem.getJdk() : null;
    }

    public void setSelectedJdk(Sdk jdk) {
        int index = this.indexOf(jdk);
        if (index >= 0) {
            this.setSelectedIndex(index);
        }
    }

    public void setInvalidJdk(String name2) {
        this.removeInvalidElement();
        this.addItem(new InvalidJdkComboBoxItem(name2));
        this.setSelectedIndex(this.getModel().getSize() - 1);
    }

    private int indexOf(Sdk jdk) {
        JdkComboBoxModel model = (JdkComboBoxModel)this.getModel();
        int count = model.getSize();
        for (int idx = 0; idx < count; ++idx) {
            Sdk elementAtJdk;
            JdkComboBoxItem elementAt = (JdkComboBoxItem)model.getElementAt(idx);
            if (!(jdk == null ? elementAt instanceof NoneJdkComboBoxItem || elementAt instanceof ProjectJdkComboBoxItem : (elementAtJdk = elementAt.getJdk()) != null && jdk.getName().equals(elementAtJdk.getName()))) continue;
            return idx;
        }
        return -1;
    }

    private void removeInvalidElement() {
        JdkComboBoxModel model = (JdkComboBoxModel)this.getModel();
        int count = model.getSize();
        for (int idx = 0; idx < count; ++idx) {
            JdkComboBoxItem elementAt = (JdkComboBoxItem)model.getElementAt(idx);
            if (!(elementAt instanceof InvalidJdkComboBoxItem)) continue;
            this.removeItemAt(idx);
            break;
        }
    }

    public void reloadModel(JdkComboBoxItem firstItem, @Nullable Project project2) {
        JdkComboBoxModel model = (JdkComboBoxModel)this.getModel();
        if (project2 == null) {
            model.addElement(firstItem);
            return;
        }
        model.reload(firstItem, ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel(), this.mySdkTypeFilter, this.myFilter, false);
    }

    public static Condition<Sdk> getSdkFilter(@Nullable Condition<? super SdkTypeId> filter) {
        return filter == null ? Conditions.alwaysTrue() : sdk -> filter.value((Object)sdk.getSdkType());
    }

    public static class SuggestedJdkItem
    extends JdkComboBoxItem {
        private final SdkType mySdkType;
        private final String myPath;

        SuggestedJdkItem(@NotNull SdkType sdkType, @NotNull String path) {
            this.mySdkType = sdkType;
            this.myPath = path;
        }

        @NotNull
        public SdkType getSdkType() {
            return this.mySdkType;
        }

        @NotNull
        public String getPath() {
            return this.myPath;
        }

        public String toString() {
            return this.myPath;
        }
    }

    private static class InvalidJdkComboBoxItem
    extends JdkComboBoxItem {
        private final String mySdkName;

        InvalidJdkComboBoxItem(String name2) {
            this.mySdkName = name2;
        }

        @Override
        public String getSdkName() {
            return this.mySdkName;
        }

        public String toString() {
            return ProjectBundle.message((String)"jdk.combo.box.invalid.item", (Object[])new Object[]{this.mySdkName});
        }
    }

    public static class NoneJdkComboBoxItem
    extends JdkComboBoxItem {
        public String toString() {
            return ProjectBundle.message((String)"jdk.combo.box.none.item", (Object[])new Object[0]);
        }
    }

    public static class ProjectJdkComboBoxItem
    extends JdkComboBoxItem {
        public String toString() {
            return ProjectBundle.message((String)"jdk.combo.box.project.item", (Object[])new Object[0]);
        }
    }

    public static class ActualJdkComboBoxItem
    extends JdkComboBoxItem {
        private final Sdk myJdk;

        public ActualJdkComboBoxItem(@NotNull Sdk jdk) {
            this.myJdk = jdk;
        }

        public String toString() {
            return this.myJdk.getName();
        }

        @Override
        @Nullable
        public Sdk getJdk() {
            return this.myJdk;
        }

        @Override
        @Nullable
        public String getSdkName() {
            return this.myJdk.getName();
        }
    }

    public static abstract class JdkComboBoxItem {
        @Nullable
        public Sdk getJdk() {
            return null;
        }

        @Nullable
        public String getSdkName() {
            return null;
        }
    }

    private static class JdkComboBoxModel
    extends DefaultComboBoxModel<JdkComboBoxItem> {
        JdkComboBoxModel(@NotNull ProjectSdksModel jdksModel, @Nullable Condition<? super SdkTypeId> sdkTypeFilter, @Nullable Condition<? super Sdk> sdkFilter, boolean addSuggested) {
            this.reload(null, jdksModel, sdkTypeFilter, sdkFilter, addSuggested);
        }

        void reload(@Nullable JdkComboBoxItem firstItem, @NotNull ProjectSdksModel jdksModel, @Nullable Condition<? super SdkTypeId> sdkTypeFilter, @Nullable Condition<? super Sdk> sdkFilter, boolean addSuggested) {
            Sdk[] jdks;
            this.removeAllElements();
            if (firstItem != null) {
                this.addElement(firstItem);
            }
            for (Sdk jdk : jdks = JdkComboBoxModel.sortSdks(jdksModel.getSdks())) {
                if (sdkFilter != null && !sdkFilter.value((Object)jdk)) continue;
                this.addElement(new ActualJdkComboBoxItem(jdk));
            }
            if (addSuggested) {
                this.addSuggestedItems(sdkTypeFilter, jdks);
            }
        }

        @NotNull
        private static Sdk[] sortSdks(@NotNull Sdk[] sdks) {
            Sdk[] clone = (Sdk[])sdks.clone();
            Arrays.sort(clone, (sdk1, sdk2) -> {
                SdkType sdkType1 = (SdkType)sdk1.getSdkType();
                SdkType sdkType2 = (SdkType)sdk2.getSdkType();
                if (!sdkType1.getComparator().equals(sdkType2.getComparator())) {
                    return StringUtil.compare((String)sdkType1.getPresentableName(), (String)sdkType2.getPresentableName(), (boolean)true);
                }
                return sdkType1.getComparator().compare(sdk1, sdk2);
            });
            return clone;
        }

        void addSuggestedItems(@Nullable Condition<? super SdkTypeId> sdkTypeFilter, Sdk[] jdks) {
            SdkType[] types;
            for (SdkType type : types = SdkType.getAllTypes()) {
                if (sdkTypeFilter != null && (!sdkTypeFilter.value((Object)type) || ContainerUtil.find((Object[])jdks, sdk -> sdk.getSdkType() == type) != null)) continue;
                Collection paths = type.suggestHomePaths();
                for (String path : paths) {
                    if (path == null || !type.isValidSdkHome(path)) continue;
                    this.addElement(new SuggestedJdkItem(type, path));
                }
            }
        }
    }
}

