/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.JdkComboBox;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectJdkConfigurable
implements UnnamedConfigurable {
    private static final Logger LOG = Logger.getInstance(ProjectJdkConfigurable.class);
    private JdkComboBox myCbProjectJdk;
    private JPanel myJdkPanel;
    private final Project myProject;
    private final ProjectSdksModel myJdksModel;
    private final SdkModel.Listener myListener = new SdkModel.Listener(){

        public void sdkAdded(@NotNull Sdk sdk) {
            ProjectJdkConfigurable.this.reloadModel();
        }

        public void beforeSdkRemove(@NotNull Sdk sdk) {
            ProjectJdkConfigurable.this.reloadModel();
        }

        public void sdkChanged(@NotNull Sdk sdk, String previousName) {
            ProjectJdkConfigurable.this.reloadModel();
        }

        public void sdkHomeSelected(@NotNull Sdk sdk, @NotNull String newSdkHome) {
            ProjectJdkConfigurable.this.reloadModel();
        }
    };
    private boolean myFreeze = false;

    public ProjectJdkConfigurable(Project project2, ProjectSdksModel jdksModel) {
        this.myProject = project2;
        this.myJdksModel = jdksModel;
        this.myJdksModel.addListener(this.myListener);
    }

    @Nullable
    public Sdk getSelectedProjectJdk() {
        return this.myJdksModel.findSdk(this.myCbProjectJdk.getSelectedJdk());
    }

    @NotNull
    public JComponent createComponent() {
        if (this.myJdkPanel == null) {
            this.myJdkPanel = new JPanel(new GridBagLayout());
            this.myCbProjectJdk = new JdkComboBox(this.myJdksModel);
            this.myCbProjectJdk.insertItemAt(new JdkComboBox.NoneJdkComboBoxItem(), 0);
            this.myCbProjectJdk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ProjectJdkConfigurable.this.myFreeze) {
                        return;
                    }
                    ProjectJdkConfigurable.this.myJdksModel.setProjectSdk(ProjectJdkConfigurable.this.myCbProjectJdk.getSelectedJdk());
                    ProjectJdkConfigurable.this.clearCaches();
                }
            });
            this.myJdkPanel.add((Component)new JLabel(ProjectBundle.message((String)"module.libraries.target.jdk.project.radio", (Object[])new Object[0])), new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insetsBottom((int)4), 0, 0));
            this.myJdkPanel.add((Component)((Object)this.myCbProjectJdk), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, (Insets)JBUI.insetsLeft((int)4), 0, 0));
            JButton setUpButton = new JButton(ApplicationBundle.message((String)"button.new", (Object[])new Object[0]));
            this.myCbProjectJdk.setSetupButton(setUpButton, this.myProject, this.myJdksModel, (JdkComboBox.JdkComboBoxItem)new JdkComboBox.NoneJdkComboBoxItem(), null, false);
            this.myJdkPanel.add((Component)setUpButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insetsLeft((int)4), 0, 0));
            JButton editButton = new JButton(ApplicationBundle.message((String)"button.edit", (Object[])new Object[0]));
            this.myCbProjectJdk.setEditButton(editButton, this.myProject, (Computable<? extends Sdk>)((Computable)() -> this.myJdksModel.getProjectSdk()));
            this.myJdkPanel.add((Component)editButton, new GridBagConstraints(-1, 1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsLeft((int)4), 0, 0));
        }
        return this.myJdkPanel;
    }

    private void reloadModel() {
        this.myFreeze = true;
        Sdk projectJdk = this.myJdksModel.getProjectSdk();
        if (this.myCbProjectJdk != null) {
            String sdkName;
            this.myCbProjectJdk.reloadModel(new JdkComboBox.NoneJdkComboBoxItem(), this.myProject);
            String string = sdkName = projectJdk == null ? ProjectRootManager.getInstance((Project)this.myProject).getProjectSdkName() : projectJdk.getName();
            if (sdkName != null) {
                Sdk jdk = this.myJdksModel.findSdk(sdkName);
                if (jdk != null) {
                    this.myCbProjectJdk.setSelectedJdk(jdk);
                } else {
                    this.myCbProjectJdk.setInvalidJdk(sdkName);
                    this.clearCaches();
                }
            } else {
                this.myCbProjectJdk.setSelectedJdk(null);
            }
        } else {
            LOG.error("'createComponent' wasn't called before 'reset' for " + this.toString());
        }
        this.myFreeze = false;
    }

    private void clearCaches() {
        Module[] modules;
        ModuleStructureConfigurable rootConfigurable = ModuleStructureConfigurable.getInstance(this.myProject);
        for (Module module2 : modules = rootConfigurable.getModules()) {
            StructureConfigurableContext context = rootConfigurable.getContext();
            context.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(context, module2));
        }
    }

    public boolean isModified() {
        Sdk projectJdk = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        return !Comparing.equal((Object)projectJdk, (Object)this.getSelectedProjectJdk());
    }

    public void apply() {
        ProjectRootManager.getInstance((Project)this.myProject).setProjectSdk(this.getSelectedProjectJdk());
    }

    public void reset() {
        this.reloadModel();
        if (this.myCbProjectJdk != null) {
            String sdkName = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdkName();
            if (sdkName != null) {
                Sdk jdk = this.myJdksModel.findSdk(sdkName);
                if (jdk != null) {
                    this.myCbProjectJdk.setSelectedJdk(jdk);
                } else {
                    this.myCbProjectJdk.setInvalidJdk(sdkName);
                }
            } else {
                this.myCbProjectJdk.setSelectedJdk(null);
            }
        }
    }

    public void disposeUIResources() {
        this.myJdksModel.removeListener(this.myListener);
        this.myJdkPanel = null;
        this.myCbProjectJdk = null;
    }

    void addChangeListener(ActionListener listener) {
        this.myCbProjectJdk.addActionListener(listener);
    }
}

