/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProblemDescription;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.PlaceInArtifact;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ConfigurationErrorQuickFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.ui.ArtifactProblemsHolderBase;
import com.intellij.packaging.ui.ArtifactEditor;
import com.intellij.packaging.ui.ArtifactProblemQuickFix;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactProblemsHolderImpl
extends ArtifactProblemsHolderBase {
    private final ArtifactsStructureConfigurableContext myContext;
    private final Artifact myOriginalArtifact;
    private final ProjectStructureProblemsHolder myProblemsHolder;

    public ArtifactProblemsHolderImpl(ArtifactsStructureConfigurableContext context, Artifact originalArtifact, ProjectStructureProblemsHolder problemsHolder) {
        super(context);
        this.myContext = context;
        this.myOriginalArtifact = originalArtifact;
        this.myProblemsHolder = problemsHolder;
    }

    public void registerError(@NotNull String message, @NotNull String problemTypeId, @Nullable List<PackagingElement<?>> pathToPlace, ArtifactProblemQuickFix ... quickFixes) {
        this.registerProblem(message, pathToPlace, ProjectStructureProblemType.error(problemTypeId), quickFixes);
    }

    public void registerWarning(@NotNull String message, @NotNull String problemTypeId, @Nullable List<PackagingElement<?>> pathToPlace, ArtifactProblemQuickFix ... quickFixes) {
        this.registerProblem(message, pathToPlace, ProjectStructureProblemType.warning(problemTypeId), quickFixes);
    }

    private void registerProblem(@NotNull String message, @Nullable List<PackagingElement<?>> pathToPlace, ProjectStructureProblemType problemType, ArtifactProblemQuickFix ... quickFixes) {
        PackagingElement<?> element;
        String parentPath;
        if (pathToPlace != null && !pathToPlace.isEmpty()) {
            parentPath = PackagingElementPath.createPath(pathToPlace.subList(1, pathToPlace.size() - 1)).getPathString();
            element = pathToPlace.get(pathToPlace.size() - 1);
        } else {
            parentPath = null;
            element = null;
        }
        Artifact artifact = this.myContext.getArtifactModel().getArtifactByOriginal(this.myOriginalArtifact);
        PlaceInArtifact place = new PlaceInArtifact(artifact, this.myContext, parentPath, element);
        this.myProblemsHolder.registerProblem(new ArtifactProblemDescription(message, problemType, pathToPlace, place, this.convertQuickFixes(quickFixes)));
    }

    private List<ConfigurationErrorQuickFix> convertQuickFixes(ArtifactProblemQuickFix[] quickFixes) {
        SmartList result = new SmartList();
        for (final ArtifactProblemQuickFix fix : quickFixes) {
            result.add(new ConfigurationErrorQuickFix(fix.getActionName()){

                @Override
                public void performFix() {
                    ArtifactEditor editor = ArtifactProblemsHolderImpl.this.myContext.getOrCreateEditor(ArtifactProblemsHolderImpl.this.myOriginalArtifact);
                    fix.performFix(((ArtifactEditorEx)editor).getContext());
                }
            });
        }
        return result;
    }
}

