/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactConfigurable;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactConfigurableBase;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorSettings;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactStructureConfigurableState;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContextImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.InvalidArtifactConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.GlobalLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsState;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.openapi.util.Comparing;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactAdapter;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.InvalidArtifact;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.LibraryElementType;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactsStructureConfigurable
extends BaseStructureConfigurable {
    private ArtifactsStructureConfigurableContextImpl myPackagingEditorContext;
    private final ArtifactEditorSettings myDefaultSettings = new ArtifactEditorSettings();

    public ArtifactsStructureConfigurable(@NotNull Project project2) {
        super(project2, new ArtifactStructureConfigurableState());
    }

    protected String getComponentStateKey() {
        return "ArtifactsStructureConfigurable.UI";
    }

    public void init(StructureConfigurableContext context, ModuleStructureConfigurable moduleStructureConfigurable, ProjectLibrariesConfigurable projectLibrariesConfig, GlobalLibrariesConfigurable globalLibrariesConfig) {
        super.init(context);
        this.myPackagingEditorContext = new ArtifactsStructureConfigurableContextImpl(this.myContext, this.myProject, this.myDefaultSettings, new ArtifactAdapter(){

            public void artifactAdded(@NotNull Artifact artifact) {
                MasterDetailsComponent.MyNode node = ArtifactsStructureConfigurable.this.addArtifactNode(artifact);
                ArtifactsStructureConfigurable.this.selectNodeInTree((DefaultMutableTreeNode)node);
                ArtifactsStructureConfigurable.this.myContext.getDaemonAnalyzer().queueUpdate(ArtifactsStructureConfigurable.this.myPackagingEditorContext.getOrCreateArtifactElement(artifact));
            }
        });
        context.getModulesConfigurator().addAllModuleChangeListener(new ModuleEditor.ChangeListener(){

            @Override
            public void moduleStateChanged(ModifiableRootModel moduleRootModel) {
                for (ProjectStructureElement projectStructureElement : ArtifactsStructureConfigurable.this.getProjectStructureElements()) {
                    ArtifactsStructureConfigurable.this.myContext.getDaemonAnalyzer().queueUpdate(projectStructureElement);
                }
            }
        });
        MasterDetailsComponent.ItemsChangeListener listener = new MasterDetailsComponent.ItemsChangeListener(){

            public void itemChanged(@Nullable Object deletedItem) {
                if (deletedItem instanceof Library || deletedItem instanceof Module) {
                    ArtifactsStructureConfigurable.this.onElementDeleted();
                }
            }
        };
        moduleStructureConfigurable.addItemsChangeListener(listener);
        projectLibrariesConfig.addItemsChangeListener(listener);
        globalLibrariesConfig.addItemsChangeListener(listener);
        context.addLibraryEditorListener(new LibraryEditorListener(){

            @Override
            public void libraryRenamed(@NotNull Library library, String oldName, String newName) {
                Artifact[] artifacts;
                for (Artifact artifact : artifacts = ArtifactsStructureConfigurable.this.myPackagingEditorContext.getArtifactModel().getArtifacts()) {
                    ArtifactsStructureConfigurable.this.updateLibraryElements(artifact, library, oldName, newName);
                }
            }
        });
    }

    private void updateLibraryElements(Artifact artifact, final Library library, final String oldName, final String newName) {
        if (ArtifactUtil.processPackagingElements(this.myPackagingEditorContext.getRootElement(artifact), LibraryElementType.LIBRARY_ELEMENT_TYPE, new PackagingElementProcessor<LibraryPackagingElement>(){

            @Override
            public boolean process(@NotNull LibraryPackagingElement element, @NotNull PackagingElementPath path) {
                return !ArtifactsStructureConfigurable.isResolvedToLibrary(element, library, oldName);
            }
        }, this.myPackagingEditorContext, false, artifact.getArtifactType())) {
            return;
        }
        this.myPackagingEditorContext.editLayout(artifact, () -> {
            ModifiableArtifact modifiableArtifact = this.myPackagingEditorContext.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(artifact);
            ArtifactUtil.processPackagingElements((Artifact)modifiableArtifact, LibraryElementType.LIBRARY_ELEMENT_TYPE, new PackagingElementProcessor<LibraryPackagingElement>(){

                @Override
                public boolean process(@NotNull LibraryPackagingElement element, @NotNull PackagingElementPath path) {
                    if (ArtifactsStructureConfigurable.isResolvedToLibrary(element, library, oldName)) {
                        element.setLibraryName(newName);
                    }
                    return true;
                }
            }, (PackagingElementResolvingContext)this.myPackagingEditorContext, false);
        });
        ArtifactEditorImpl artifactEditor = this.myPackagingEditorContext.getArtifactEditor(artifact);
        if (artifactEditor != null) {
            artifactEditor.rebuildTries();
        }
    }

    private static boolean isResolvedToLibrary(LibraryPackagingElement element, Library library, String name2) {
        if (!element.getLibraryName().equals(name2)) {
            return false;
        }
        LibraryTable table = library.getTable();
        if (table != null) {
            return table.getTableLevel().equals(element.getLevel());
        }
        return element.getLevel().equals("module");
    }

    private void onElementDeleted() {
        for (ArtifactEditorImpl artifactEditorImpl : this.myPackagingEditorContext.getArtifactEditors()) {
            artifactEditorImpl.getSourceItemsTree().rebuildTree();
            artifactEditorImpl.queueValidation();
        }
    }

    protected MasterDetailsState getState() {
        ((ArtifactStructureConfigurableState)this.myState).setDefaultArtifactSettings(this.myDefaultSettings.getState());
        return super.getState();
    }

    public void loadState(MasterDetailsState object) {
        super.loadState(object);
        this.myDefaultSettings.loadState(((ArtifactStructureConfigurableState)this.myState).getDefaultArtifactSettings());
    }

    @Nls
    public String getDisplayName() {
        return ProjectBundle.message((String)"display.name.artifacts", (Object[])new Object[0]);
    }

    @Override
    protected void loadTree() {
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(false);
        for (Artifact artifact : this.myPackagingEditorContext.getArtifactModel().getAllArtifactsIncludingInvalid()) {
            this.addArtifactNode(artifact);
        }
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<ArtifactProjectStructureElement> elements = new ArrayList<ArtifactProjectStructureElement>();
        for (Artifact artifact : this.myPackagingEditorContext.getArtifactModel().getAllArtifactsIncludingInvalid()) {
            elements.add(this.myPackagingEditorContext.getOrCreateArtifactElement(artifact));
        }
        return elements;
    }

    private MasterDetailsComponent.MyNode addArtifactNode(Artifact artifact) {
        ArtifactConfigurableBase configurable = artifact instanceof InvalidArtifact ? new InvalidArtifactConfigurable((InvalidArtifact)artifact, this.myPackagingEditorContext, this.TREE_UPDATER) : new ArtifactConfigurable(artifact, this.myPackagingEditorContext, this.TREE_UPDATER);
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)configurable);
        this.addNode(node, this.myRoot);
        return node;
    }

    @Override
    public void reset() {
        this.loadComponentState();
        this.myPackagingEditorContext.resetModifiableModel();
        super.reset();
    }

    public boolean isModified() {
        ModifiableArtifactModel modifiableModel = this.myPackagingEditorContext.getActualModifiableModel();
        if (modifiableModel != null && modifiableModel.isModified()) {
            return true;
        }
        return this.myPackagingEditorContext.getManifestFilesInfo().isManifestFilesModified() || super.isModified();
    }

    public ArtifactsStructureConfigurableContext getArtifactsStructureContext() {
        return this.myPackagingEditorContext;
    }

    public ModifiableArtifactModel getModifiableArtifactModel() {
        return this.myPackagingEditorContext.getOrCreateModifiableArtifactModel();
    }

    @Override
    protected BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        return new BaseStructureConfigurable.AbstractAddGroup(ProjectBundle.message((String)"add.new.header.text", (Object[])new Object[0])){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                ArtifactType[] types = ArtifactType.getAllTypes();
                AnAction[] actions = new AnAction[types.length];
                for (int i = 0; i < types.length; ++i) {
                    actions[i] = ArtifactsStructureConfigurable.this.createAddArtifactAction(types[i]);
                }
                return actions;
            }
        };
    }

    private AnAction createAddArtifactAction(final @NotNull ArtifactType type) {
        List templates = type.getNewArtifactTemplates((PackagingElementResolvingContext)this.myPackagingEditorContext);
        ArtifactTemplate emptyTemplate = new ArtifactTemplate(){

            public String getPresentableName() {
                return "Empty";
            }

            public ArtifactTemplate.NewArtifactConfiguration createArtifact() {
                String name2 = "unnamed";
                return new ArtifactTemplate.NewArtifactConfiguration(type.createRootElement("unnamed"), "unnamed", type);
            }
        };
        if (templates.isEmpty()) {
            return new AddArtifactAction(type, emptyTemplate, type.getPresentableName(), type.getIcon());
        }
        DefaultActionGroup group = new DefaultActionGroup(type.getPresentableName(), true);
        group.getTemplatePresentation().setIcon(type.getIcon());
        group.add((AnAction)new AddArtifactAction(type, emptyTemplate, emptyTemplate.getPresentableName(), null));
        group.addSeparator();
        for (ArtifactTemplate template : templates) {
            group.add((AnAction)new AddArtifactAction(type, template, template.getPresentableName(), null));
        }
        return group;
    }

    private void addArtifact(@NotNull ArtifactType type, @NotNull ArtifactTemplate artifactTemplate) {
        Artifact artifact = ArtifactUtil.addArtifact(this.myPackagingEditorContext.getOrCreateModifiableArtifactModel(), type, artifactTemplate);
        this.selectNodeInTree((DefaultMutableTreeNode)ArtifactsStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)artifact));
    }

    @Override
    @NotNull
    protected List<? extends AnAction> createCopyActions(boolean fromPopup) {
        ArrayList<CopyArtifactAction> actions = new ArrayList<CopyArtifactAction>();
        actions.add(new CopyArtifactAction());
        return actions;
    }

    public void apply() throws ConfigurationException {
        this.myPackagingEditorContext.saveEditorSettings();
        this.checkForEmptyAndDuplicatedNames("Artifact", CommonBundle.getErrorTitle(), ArtifactConfigurableBase.class);
        super.apply();
        this.myPackagingEditorContext.getManifestFilesInfo().saveManifestFiles();
        ModifiableArtifactModel modifiableModel = this.myPackagingEditorContext.getActualModifiableModel();
        if (modifiableModel != null) {
            WriteAction.run(() -> modifiableModel.commit());
        }
        this.myPackagingEditorContext.resetModifiableModel();
        this.reloadTreeNodes();
        this.restoreLastSelection();
    }

    @Override
    public void disposeUIResources() {
        this.myPackagingEditorContext.saveEditorSettings();
        super.disposeUIResources();
        this.myPackagingEditorContext.disposeUIResources();
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        ArtifactEditorImpl editor;
        boolean selectionChanged;
        boolean bl = selectionChanged = !Comparing.equal((Object)this.myCurrentConfigurable, (Object)configurable);
        if (selectionChanged && this.myCurrentConfigurable instanceof ArtifactConfigurable && (editor = this.myPackagingEditorContext.getArtifactEditor(((ArtifactConfigurable)this.myCurrentConfigurable).getArtifact())) != null) {
            editor.getLayoutTreeComponent().saveElementProperties();
        }
        super.updateSelection(configurable);
        if (selectionChanged && configurable instanceof ArtifactConfigurable && (editor = this.myPackagingEditorContext.getArtifactEditor(((ArtifactConfigurable)configurable).getArtifact())) != null) {
            editor.getLayoutTreeComponent().resetElementProperties();
        }
    }

    public String getHelpTopic() {
        String topic = super.getHelpTopic();
        return topic != null ? topic : "reference.settingsdialog.project.structure.artifacts";
    }

    @Override
    protected List<? extends RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return Collections.singletonList(new ArtifactRemoveHandler());
    }

    @NotNull
    public String getId() {
        return "project.artifacts";
    }

    public void dispose() {
    }

    private class CopyArtifactAction
    extends AnAction {
        private CopyArtifactAction() {
            super(CommonBundle.message((String)"button.copy", (Object[])new Object[0]), CommonBundle.message((String)"button.copy", (Object[])new Object[0]), COPY_ICON);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object o = ArtifactsStructureConfigurable.this.getSelectedObject();
            if (o instanceof Artifact) {
                Artifact selected = (Artifact)o;
                ModifiableArtifactModel artifactModel = ArtifactsStructureConfigurable.this.myPackagingEditorContext.getOrCreateModifiableArtifactModel();
                String suggestedName = ArtifactUtil.generateUniqueArtifactName(selected.getName(), artifactModel);
                String newName = Messages.showInputDialog((String)"Enter artifact name:", (String)"Copy Artifact", (Icon)COPY_ICON, (String)suggestedName, (InputValidator)new NonEmptyInputValidator());
                if (newName == null) {
                    return;
                }
                CompositePackagingElement<?> rootCopy = ArtifactUtil.copyFromRoot(selected.getRootElement(), ArtifactsStructureConfigurable.this.myProject);
                artifactModel.addArtifact(newName, selected.getArtifactType(), rootCopy);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (ArtifactsStructureConfigurable.this.myTree.getSelectionPaths() == null || ArtifactsStructureConfigurable.this.myTree.getSelectionPaths().length != 1) {
                e.getPresentation().setEnabled(false);
            } else {
                e.getPresentation().setEnabled(ArtifactsStructureConfigurable.this.getSelectedObject() instanceof Artifact);
            }
        }
    }

    private class AddArtifactAction
    extends DumbAwareAction {
        private final ArtifactType myType;
        private final ArtifactTemplate myArtifactTemplate;

        AddArtifactAction(@NotNull ArtifactType type, @NotNull ArtifactTemplate artifactTemplate, String actionText, Icon icon) {
            super(actionText, null, icon);
            this.myType = type;
            this.myArtifactTemplate = artifactTemplate;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ArtifactsStructureConfigurable.this.addArtifact(this.myType, this.myArtifactTemplate);
        }
    }

    private class ArtifactRemoveHandler
    extends RemoveConfigurableHandler<Artifact> {
        ArtifactRemoveHandler() {
            super(ArtifactConfigurableBase.class);
        }

        @Override
        public boolean remove(@NotNull Collection<? extends Artifact> artifacts) {
            for (Artifact artifact : artifacts) {
                ArtifactsStructureConfigurable.this.myPackagingEditorContext.getOrCreateModifiableArtifactModel().removeArtifact(artifact);
                ArtifactsStructureConfigurable.this.myContext.getDaemonAnalyzer().removeElement(ArtifactsStructureConfigurable.this.myPackagingEditorContext.getOrCreateArtifactElement(artifact));
            }
            return true;
        }
    }
}

