/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.nodes;

import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ComplexElementSubstitutionParameters;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.ArtifactRootNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.ComplexPackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.CompositePackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingNodeSource;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.ui.ArtifactEditorContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingTreeNodeFactory {
    private PackagingTreeNodeFactory() {
    }

    public static void addNodes(@NotNull List<? extends PackagingElement<?>> elements, @NotNull CompositePackagingElementNode parentNode, @NotNull CompositePackagingElement parentElement, @NotNull ArtifactEditorContext context, @NotNull ComplexElementSubstitutionParameters substitutionParameters, @NotNull Collection<PackagingNodeSource> nodeSources, @NotNull List<PackagingElementNode<?>> nodes, ArtifactType artifactType, Set<? super PackagingElement<?>> processed) {
        for (PackagingElement<?> element : elements) {
            PackagingElementNode<?> prev = PackagingTreeNodeFactory.findEqual(nodes, element);
            if (prev != null) {
                prev.addElement(element, parentElement, nodeSources);
                continue;
            }
            if (element instanceof ArtifactRootElement) {
                throw new AssertionError((Object)"artifact root not expected here");
            }
            if (element instanceof CompositePackagingElement) {
                nodes.add(new CompositePackagingElementNode((CompositePackagingElement)element, context, parentNode, parentElement, substitutionParameters, nodeSources, artifactType));
                continue;
            }
            if (element instanceof ComplexPackagingElement) {
                List substitution;
                ComplexPackagingElement complexElement = (ComplexPackagingElement)element;
                if (processed.add(element) && substitutionParameters.shouldSubstitute(complexElement) && (substitution = complexElement.getSubstitution((PackagingElementResolvingContext)context, artifactType)) != null) {
                    PackagingNodeSource source = new PackagingNodeSource(complexElement, parentNode, parentElement, nodeSources);
                    PackagingTreeNodeFactory.addNodes(substitution, parentNode, parentElement, context, substitutionParameters, Collections.singletonList(source), nodes, artifactType, processed);
                    continue;
                }
                nodes.add(new ComplexPackagingElementNode(complexElement, context, parentNode, parentElement, substitutionParameters, nodeSources));
                continue;
            }
            nodes.add(new PackagingElementNode(element, context, parentNode, parentElement, nodeSources));
        }
    }

    @Nullable
    private static PackagingElementNode<?> findEqual(List<? extends PackagingElementNode<?>> children, PackagingElement<?> element) {
        for (PackagingElementNode<?> node : children) {
            if (!node.getFirstElement().isEqualTo(element)) continue;
            return node;
        }
        return null;
    }

    @NotNull
    public static ArtifactRootNode createRootNode(ArtifactEditorImpl artifactsEditor, ArtifactEditorContext context, ComplexElementSubstitutionParameters substitutionParameters, ArtifactType artifactType) {
        return new ArtifactRootNode(artifactsEditor, context, substitutionParameters, artifactType);
    }
}

