/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.SourceItemPresentation;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModuleGroupItem
extends PackagingSourceItem {
    private final String myGroupName;
    private final List<String> myPath;

    public ModuleGroupItem(@NotNull List<String> path) {
        super(false);
        this.myGroupName = path.get(path.size() - 1);
        this.myPath = path;
    }

    public boolean equals(Object obj) {
        return obj instanceof ModuleGroupItem && this.myPath.equals(((ModuleGroupItem)((Object)obj)).myPath);
    }

    public int hashCode() {
        return this.myPath.hashCode();
    }

    @NotNull
    public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        return new ModuleGroupSourceItemPresentation(this.myGroupName);
    }

    @NotNull
    public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
        return Collections.emptyList();
    }

    public List<String> getPath() {
        return this.myPath;
    }

    private static class ModuleGroupSourceItemPresentation
    extends SourceItemPresentation {
        private final String myGroupName;

        ModuleGroupSourceItemPresentation(String groupName) {
            this.myGroupName = groupName;
        }

        public String getPresentableName() {
            return this.myGroupName;
        }

        public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
            presentationData.setIcon(PlatformIcons.CLOSED_MODULE_GROUP_ICON);
            presentationData.addText(this.myGroupName, mainAttributes);
        }

        public int getWeight() {
            return 100;
        }
    }
}

