/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.DelegatedSourceItemPresentation;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import com.intellij.packaging.impl.elements.ProductionModuleOutputPackagingElement;
import com.intellij.packaging.impl.ui.ModuleElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.SourceItemPresentation;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModuleOutputSourceItem
extends PackagingSourceItem {
    private final Module myModule;

    public ModuleOutputSourceItem(@NotNull Module module2) {
        this.myModule = module2;
    }

    public Module getModule() {
        return this.myModule;
    }

    public boolean equals(Object obj) {
        return obj instanceof ModuleOutputSourceItem && this.myModule.equals(((ModuleOutputSourceItem)((Object)obj)).myModule);
    }

    public int hashCode() {
        return this.myModule.hashCode();
    }

    @NotNull
    public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)context.getProject()).create(this.myModule);
        return new DelegatedSourceItemPresentation(new ModuleElementPresentation(modulePointer, context, ProductionModuleOutputElementType.ELEMENT_TYPE)){

            @Override
            public int getWeight() {
                return 30;
            }
        };
    }

    @NotNull
    public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)context.getProject()).create(this.myModule);
        return Collections.singletonList(new ProductionModuleOutputPackagingElement(context.getProject(), modulePointer));
    }

    @NotNull
    public PackagingElementOutputKind getKindOfProducedElements() {
        return PackagingElementOutputKind.DIRECTORIES_WITH_CLASSES;
    }
}

