/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.LibrarySourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleGroupItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleOutputSourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleSourceItemGroup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ModuleElementTypeBase;
import com.intellij.packaging.impl.elements.ModulePackagingElementBase;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.PackagingSourceItemsProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModulesAndLibrariesSourceItemsProvider
extends PackagingSourceItemsProvider {
    @NotNull
    public Collection<? extends PackagingSourceItem> getSourceItems(@NotNull ArtifactEditorContext editorContext, @NotNull Artifact artifact, PackagingSourceItem parent) {
        if (parent == null) {
            return ModulesAndLibrariesSourceItemsProvider.createModuleItems(editorContext, Collections.emptyList());
        }
        if (parent instanceof ModuleGroupItem) {
            return ModulesAndLibrariesSourceItemsProvider.createModuleItems(editorContext, ((ModuleGroupItem)parent).getPath());
        }
        if (parent instanceof ModuleSourceItemGroup) {
            return ModulesAndLibrariesSourceItemsProvider.createAvailableItems(editorContext, artifact, ((ModuleSourceItemGroup)parent).getModule());
        }
        return Collections.emptyList();
    }

    @NotNull
    private static Collection<? extends PackagingSourceItem> createAvailableItems(@NotNull ArtifactEditorContext editorContext, @NotNull Artifact artifact, @NotNull Module module2) {
        ArrayList<PackagingSourceItem> items = new ArrayList<PackagingSourceItem>();
        for (Module toAdd : ModulesAndLibrariesSourceItemsProvider.getAvailableModules(editorContext, artifact, ProductionModuleOutputElementType.ELEMENT_TYPE, module2)) {
            items.add(new ModuleOutputSourceItem(toAdd));
        }
        ArrayList<Library> libraries2 = new ArrayList<Library>();
        ModuleRootModel rootModel = editorContext.getModulesProvider().getRootModel(module2);
        for (OrderEntry orderEntry : rootModel.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry)) continue;
            LibraryOrderEntry libraryEntry = (LibraryOrderEntry)orderEntry;
            Library library = libraryEntry.getLibrary();
            DependencyScope scope = libraryEntry.getScope();
            if (library == null || !scope.isForProductionRuntime()) continue;
            libraries2.add(library);
        }
        for (Library library : ModulesAndLibrariesSourceItemsProvider.getNotAddedLibraries(editorContext, artifact, libraries2)) {
            items.add(new LibrarySourceItem(library));
        }
        return items;
    }

    @NotNull
    private static Collection<? extends PackagingSourceItem> createModuleItems(@NotNull ArtifactEditorContext editorContext, @NotNull List<String> groupPath) {
        ArrayList<PackagingSourceItem> items = new ArrayList<PackagingSourceItem>();
        ModuleGrouper grouper = ModuleGrouper.instanceFor((Project)editorContext.getProject(), (ModifiableModuleModel)editorContext.getModifiableModuleModel());
        HashSet groups = new HashSet();
        for (Module module2 : grouper.getAllModules()) {
            List path = grouper.getGroupPath(module2);
            if (Comparing.equal((Object)path, groupPath)) {
                items.add(new ModuleSourceItemGroup(module2));
                continue;
            }
            if (!ContainerUtil.startsWith((List)path, groupPath)) continue;
            groups.add(path.get(groupPath.size()));
        }
        for (String group : groups) {
            items.add(0, new ModuleGroupItem(ContainerUtil.append(groupPath, (Object[])new String[]{group})));
        }
        return items;
    }

    @NotNull
    private static <E extends ModulePackagingElementBase> List<? extends Module> getAvailableModules(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull ModuleElementTypeBase<E> elementType, Module ... allModules) {
        HashSet<Module> modules = new HashSet<Module>();
        for (Module module2 : allModules) {
            if (!elementType.isSuitableModule(context.getModulesProvider(), module2)) continue;
            modules.add(module2);
        }
        ArtifactUtil.processPackagingElements(artifact, elementType, moduleElement -> {
            modules.remove(moduleElement.findModule((PackagingElementResolvingContext)context));
            return true;
        }, (PackagingElementResolvingContext)context, true);
        return new ArrayList(modules);
    }

    private static List<? extends Library> getNotAddedLibraries(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, List<Library> librariesList) {
        HashSet roots = new HashSet();
        ArtifactUtil.processPackagingElements(artifact, PackagingElementFactoryImpl.FILE_COPY_ELEMENT_TYPE, fileCopyPackagingElement -> {
            VirtualFile root = fileCopyPackagingElement.getLibraryRoot();
            if (root != null) {
                roots.add(root);
            }
            return true;
        }, (PackagingElementResolvingContext)context, true);
        ArrayList<Library> result = new ArrayList<Library>();
        for (Library library : librariesList) {
            if (roots.containsAll(Arrays.asList(library.getFiles(OrderRootType.CLASSES)))) continue;
            result.add(library);
        }
        return result;
    }
}

