/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemsTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.PutIntoDefaultLocationActionBase;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.ui.PackagingSourceItem;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackAndPutIntoDefaultLocationAction
extends PutIntoDefaultLocationActionBase {
    public PackAndPutIntoDefaultLocationAction(SourceItemsTree sourceItemsTree, ArtifactEditorEx artifactEditor) {
        super(sourceItemsTree, artifactEditor);
    }

    public void update(@NotNull AnActionEvent e) {
        String jarName = this.suggestJarName();
        String pathForJars = this.myArtifactEditor.getArtifact().getArtifactType().getDefaultPathFor(PackagingElementOutputKind.JAR_FILES);
        Presentation presentation = e.getPresentation();
        if (jarName != null && pathForJars != null) {
            presentation.setText("Pack Into " + DeploymentUtil.appendToPath((String)pathForJars, (String)(jarName + ".jar")));
            presentation.setVisible(true);
        } else {
            presentation.setVisible(false);
        }
    }

    @Nullable
    private String suggestJarName() {
        List<PackagingSourceItem> items = this.mySourceItemsTree.getSelectedItems();
        for (PackagingSourceItem item : items) {
            if (!item.isProvideElements() || !item.getKindOfProducedElements().containsDirectoriesWithClasses()) continue;
            return item.createPresentation(this.myArtifactEditor.getContext()).getPresentableName();
        }
        return null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String pathForJars = this.myArtifactEditor.getArtifact().getArtifactType().getDefaultPathFor(PackagingElementOutputKind.JAR_FILES);
        String jarName = this.suggestJarName();
        if (pathForJars != null) {
            this.myArtifactEditor.getLayoutTreeComponent().packInto(this.mySourceItemsTree.getSelectedItems(), DeploymentUtil.appendToPath((String)pathForJars, (String)(jarName + ".jar")));
        }
    }
}

