/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.NativeLibraryOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.AttachRootButtonDescriptor;
import com.intellij.openapi.roots.libraries.ui.DescendentBasedRootFilter;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRootTypePresentation;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.roots.ui.configuration.LibrarySourceRootDetectorUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.JavadocQuarantineStatusCleaner;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLibraryRootsComponentDescriptor
extends LibraryRootsComponentDescriptor {
    private static final Set<String> NATIVE_LIBRARY_EXTENSIONS = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY, (Object[])new String[]{"dll", "so", "dylib"});
    public static final Condition<VirtualFile> LIBRARY_ROOT_CONDITION = file -> FileElement.isArchive((VirtualFile)file) || DefaultLibraryRootsComponentDescriptor.isNativeLibrary(file);

    public OrderRootTypePresentation getRootTypePresentation(@NotNull OrderRootType type) {
        return DefaultLibraryRootsComponentDescriptor.getDefaultPresentation(type);
    }

    @NotNull
    public List<? extends AttachRootButtonDescriptor> createAttachButtons() {
        return Collections.singletonList(new AttachUrlJavadocDescriptor());
    }

    @NotNull
    public List<? extends RootDetector> getRootDetectors() {
        ArrayList<Object> results = new ArrayList<Object>();
        results.add(new DescendentBasedRootFilter(OrderRootType.CLASSES, false, "classes", file -> StdFileTypes.CLASS.equals(file.getFileType()) || file.getFileSystem() instanceof JarFileSystem && DefaultLibraryRootsComponentDescriptor.isNativeLibrary(file)));
        results.add(DescendentBasedRootFilter.createFileTypeBasedFilter((OrderRootType)OrderRootType.CLASSES, (boolean)true, (FileType)StdFileTypes.CLASS, (String)"jar directory"));
        ContainerUtil.addAll(results, (Iterable)LibrarySourceRootDetectorUtil.JAVA_SOURCE_ROOT_DETECTOR.getExtensionList());
        results.add(DescendentBasedRootFilter.createFileTypeBasedFilter((OrderRootType)OrderRootType.SOURCES, (boolean)true, (FileType)StdFileTypes.JAVA, (String)"source archive directory"));
        results.add((Object)new JavadocRootDetector());
        results.add(new DescendentBasedRootFilter(AnnotationOrderRootType.getInstance(), false, "external annotations", file -> "annotations.xml".equals(file.getName())));
        results.add((Object)new NativeLibraryRootFilter());
        return results;
    }

    private static boolean isNativeLibrary(VirtualFile file) {
        String extension = file.getExtension();
        return extension != null && NATIVE_LIBRARY_EXTENSIONS.contains(extension);
    }

    @NotNull
    public FileChooserDescriptor createAttachFilesChooserDescriptor(@Nullable String libraryName) {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, true, true, false, true, true).withFileFilter(LIBRARY_ROOT_CONDITION);
        descriptor2.setTitle(StringUtil.isEmpty((String)libraryName) ? ProjectBundle.message((String)"library.attach.files.action", (Object[])new Object[0]) : ProjectBundle.message((String)"library.attach.files.to.library.action", (Object[])new Object[]{libraryName}));
        descriptor2.setDescription(ProjectBundle.message((String)"library.java.attach.files.description", (Object[])new Object[0]));
        return descriptor2;
    }

    public static OrderRootTypePresentation getDefaultPresentation(OrderRootType type) {
        OrderRootTypeUIFactory factory = (OrderRootTypeUIFactory)OrderRootTypeUIFactory.FACTORY.getByKey((Object)type);
        return new OrderRootTypePresentation(factory.getNodeText(), factory.getIcon());
    }

    private static class AttachUrlJavadocDescriptor
    extends AttachRootButtonDescriptor {
        private AttachUrlJavadocDescriptor() {
            super(JavadocOrderRootType.getInstance(), IconUtil.getAddLinkIcon(), ProjectBundle.message((String)"module.libraries.javadoc.url.button", (Object[])new Object[0]));
        }

        public VirtualFile[] selectFiles(@NotNull JComponent parent, @Nullable VirtualFile initialSelection, @Nullable Module contextModule, @NotNull LibraryEditor libraryEditor) {
            VirtualFile[] virtualFileArray;
            VirtualFile vFile = Util.showSpecifyJavadocUrlDialog((JComponent)parent);
            if (vFile != null) {
                VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                virtualFileArray = virtualFileArray2;
                virtualFileArray2[0] = vFile;
            } else {
                virtualFileArray = VirtualFile.EMPTY_ARRAY;
            }
            return virtualFileArray;
        }
    }

    private static class NativeLibraryRootFilter
    extends RootDetector {
        private NativeLibraryRootFilter() {
            super(NativeLibraryOrderRootType.getInstance(), false, "native library location");
        }

        @NotNull
        public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
            if (rootCandidate.isInLocalFileSystem()) {
                if (rootCandidate.isDirectory()) {
                    for (VirtualFile file : rootCandidate.getChildren()) {
                        if (!DefaultLibraryRootsComponentDescriptor.isNativeLibrary(file)) continue;
                        return Collections.singleton(rootCandidate);
                    }
                } else if (DefaultLibraryRootsComponentDescriptor.isNativeLibrary(rootCandidate)) {
                    return Collections.singleton(rootCandidate.getParent());
                }
            }
            return Collections.emptyList();
        }
    }

    private static class JavadocRootDetector
    extends RootDetector {
        private JavadocRootDetector() {
            super(JavadocOrderRootType.getInstance(), false, "JavaDocs");
        }

        @NotNull
        public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
            ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
            JavadocRootDetector.collectJavadocRoots(rootCandidate, result, progressIndicator);
            JavadocQuarantineStatusCleaner.cleanIfNeeded(VfsUtilCore.toVirtualFileArray(result));
            return result;
        }

        private static void collectJavadocRoots(VirtualFile file, final List<VirtualFile> result, final ProgressIndicator progressIndicator) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    progressIndicator.checkCanceled();
                    if (file.isDirectory() && file.findChild("allclasses-frame.html") != null && file.findChild("allclasses-noframe.html") != null) {
                        result.add(file);
                        return false;
                    }
                    return true;
                }
            });
        }
    }
}

