/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ItemElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeContentElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.annotations.NotNull;

public class ExcludedRootElement
extends LibraryTableTreeContentElement<ExcludedRootElement> {
    @NotNull
    private final String myUrl;

    public ExcludedRootElement(@NotNull NodeDescriptor parentDescriptor, String rootUrl, @NotNull String excludedUrl) {
        super(parentDescriptor);
        String relativePath;
        this.myUrl = excludedUrl;
        this.myName = excludedUrl.startsWith(rootUrl) ? ((relativePath = StringUtil.trimStart((String)excludedUrl.substring(rootUrl.length()), (String)"/")).isEmpty() ? "<all>" : relativePath) : ItemElement.getPresentablePath(excludedUrl);
        this.myColor = ExcludedRootElement.getForegroundColor(VirtualFileManager.getInstance().findFileByUrl(excludedUrl) != null);
        this.setIcon(AllIcons.Modules.ExcludeRoot);
    }

    @NotNull
    public String getUrl() {
        return this.myUrl;
    }
}

