/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryDetectionManager;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExistingLibraryEditor
extends LibraryEditorBase
implements Disposable {
    private final LibraryEx myLibrary;
    private final LibraryEditorListener myListener;
    private String myLibraryName;
    private LibraryProperties myLibraryProperties;
    private LibraryProperties myDetectedLibraryProperties;
    private LibraryEx.ModifiableModelEx myModel;
    private LibraryType<?> myDetectedType;
    private boolean myDetectedTypeComputed;

    public ExistingLibraryEditor(@NotNull Library library, @Nullable LibraryEditorListener listener) {
        this.myLibrary = (LibraryEx)library;
        this.myListener = listener;
    }

    public Library getLibrary() {
        return this.myLibrary;
    }

    public String getName() {
        if (this.myLibraryName != null) {
            return this.myLibraryName;
        }
        return this.myLibrary.getName();
    }

    public LibraryType<?> getType() {
        PersistentLibraryKind kind = this.myLibrary.getKind();
        if (kind != null) {
            return LibraryType.findByKind((LibraryKind)kind);
        }
        return this.detectType();
    }

    @Override
    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        return this.myLibrary.getExternalSource();
    }

    @Override
    public void setType(@NotNull LibraryType<?> type) {
        this.getModel().setKind(type.getKind());
    }

    private LibraryType detectType() {
        if (!this.myDetectedTypeComputed) {
            Pair pair2;
            LibraryTable libraryTable = this.myLibrary.getTable();
            if ((libraryTable == null || libraryTable.isEditable()) && (pair2 = LibraryDetectionManager.getInstance().detectType(Arrays.asList(this.getFiles(OrderRootType.CLASSES)))) != null) {
                this.myDetectedType = (LibraryType)pair2.getFirst();
                this.myDetectedLibraryProperties = (LibraryProperties)pair2.getSecond();
            }
            this.myDetectedTypeComputed = true;
        }
        return this.myDetectedType;
    }

    public LibraryProperties getProperties() {
        LibraryType<?> type = this.getType();
        if (type == null) {
            return null;
        }
        if (this.myDetectedType != null) {
            return this.myDetectedLibraryProperties;
        }
        if (this.myLibraryProperties == null) {
            this.myLibraryProperties = type.getKind().createDefaultProperties();
            this.myLibraryProperties.loadState(this.getOriginalProperties().getState());
        }
        return this.myLibraryProperties;
    }

    @Override
    public void setProperties(LibraryProperties properties) {
        this.myLibraryProperties = properties;
    }

    private LibraryProperties getOriginalProperties() {
        return this.myLibrary.getProperties();
    }

    public void dispose() {
        if (this.myModel != null) {
            Disposer.dispose((Disposable)this.myModel);
        }
    }

    @NotNull
    public String[] getUrls(@NotNull OrderRootType rootType) {
        if (this.myModel != null) {
            return this.myModel.getUrls(rootType);
        }
        return this.myLibrary.getUrls(rootType);
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
        if (this.myModel != null) {
            return this.myModel.getFiles(rootType);
        }
        return this.myLibrary.getFiles(rootType);
    }

    @NotNull
    public String[] getExcludedRootUrls() {
        if (this.myModel != null) {
            return this.myModel.getExcludedRootUrls();
        }
        return this.myLibrary.getExcludedRootUrls();
    }

    public void setName(String name2) {
        String oldName = this.getModel().getName();
        this.myLibraryName = name2;
        this.getModel().setName(name2);
        if (this.myListener != null) {
            this.myListener.libraryRenamed((Library)this.myLibrary, oldName, name2);
        }
    }

    public void addRoot(@NotNull VirtualFile file, @NotNull OrderRootType rootType) {
        this.getModel().addRoot(file, rootType);
    }

    public void addRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        this.getModel().addRoot(url, rootType);
    }

    public void addExcludedRoot(@NotNull String url) {
        this.getModel().addExcludedRoot(url);
    }

    public void addJarDirectory(@NotNull VirtualFile file, boolean recursive, @NotNull OrderRootType rootType) {
        this.getModel().addJarDirectory(file, recursive, rootType);
    }

    public void addJarDirectory(@NotNull String url, boolean recursive, @NotNull OrderRootType rootType) {
        this.getModel().addJarDirectory(url, recursive, rootType);
    }

    public void removeRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        this.getModel().removeRoot(url, rootType);
    }

    public void removeExcludedRoot(@NotNull String url) {
        this.getModel().removeExcludedRoot(url);
    }

    public void commit() {
        if (this.myModel != null) {
            if (this.myLibraryProperties != null) {
                this.myModel.setProperties(this.myLibraryProperties);
            }
            this.myModel.commit();
            this.myModel = null;
            this.myLibraryName = null;
            this.myLibraryProperties = null;
        }
    }

    public LibraryEx.ModifiableModelEx getModel() {
        if (this.myModel == null) {
            this.myModel = this.myLibrary.getModifiableModel();
        }
        return this.myModel;
    }

    public boolean hasChanges() {
        if (this.myModel != null && this.myModel.isChanged()) {
            return true;
        }
        return this.myLibraryProperties != null && !this.myLibraryProperties.equals((Object)this.getOriginalProperties());
    }

    public boolean isJarDirectory(@NotNull String url, @NotNull OrderRootType rootType) {
        if (this.myModel != null) {
            return this.myModel.isJarDirectory(url, rootType);
        }
        return this.myLibrary.isJarDirectory(url, rootType);
    }

    public boolean isValid(@NotNull String url, @NotNull OrderRootType orderRootType) {
        if (this.myModel != null) {
            return this.myModel.isValid(url, orderRootType);
        }
        return this.myLibrary.isValid(url, orderRootType);
    }

    @Override
    public Collection<OrderRootType> getOrderRootTypes() {
        return Arrays.asList(OrderRootType.getAllTypes());
    }
}

