/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryEditorBase
implements LibraryEditor {
    public void removeAllRoots() {
        ArrayList<OrderRootType> types = new ArrayList<OrderRootType>(this.getOrderRootTypes());
        for (OrderRootType type : types) {
            String[] urls;
            for (String url : urls = this.getUrls(type)) {
                this.removeRoot(url, type);
            }
        }
    }

    protected abstract Collection<OrderRootType> getOrderRootTypes();

    public abstract void setProperties(LibraryProperties var1);

    public abstract void setType(@NotNull LibraryType<?> var1);

    public void addRoots(@NotNull Collection<? extends OrderRoot> roots) {
        for (OrderRoot orderRoot : roots) {
            if (orderRoot.isJarDirectory()) {
                this.addJarDirectory(orderRoot.getFile(), false, orderRoot.getType());
                continue;
            }
            this.addRoot(orderRoot.getFile(), orderRoot.getType());
        }
    }

    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        return null;
    }
}

