/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.facet.Facet;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FindUsagesInProjectStructureActionBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementRenderer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzerListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsState;
import com.intellij.openapi.ui.MasterDetailsStateService;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.navigation.Place;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseStructureConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable,
Disposable,
Place.Navigator {
    protected StructureConfigurableContext myContext;
    protected final Project myProject;
    protected boolean myUiDisposed = true;
    private boolean myWasTreeInitialized;
    protected boolean myAutoScrollEnabled = true;

    protected BaseStructureConfigurable(Project project2, MasterDetailsState state) {
        super(state);
        this.myProject = project2;
    }

    protected BaseStructureConfigurable(@NotNull Project project2) {
        this.myProject = project2;
    }

    public void init(StructureConfigurableContext context) {
        this.myContext = context;
        this.myContext.getDaemonAnalyzer().addListener(new ProjectStructureDaemonAnalyzerListener(){

            @Override
            public void problemsChanged(@NotNull ProjectStructureElement element) {
                if (!BaseStructureConfigurable.this.myTree.isShowing()) {
                    return;
                }
                BaseStructureConfigurable.this.myTree.revalidate();
                BaseStructureConfigurable.this.myTree.repaint();
            }
        });
    }

    protected MasterDetailsStateService getStateService() {
        return MasterDetailsStateService.getInstance((Project)this.myProject);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        MasterDetailsComponent.MyNode nodeByName;
        if (place == null) {
            return ActionCallback.DONE;
        }
        Object object = place.getPath("treeObject");
        String byName = (String)place.getPath("treeName");
        if (object == null && byName == null) {
            return ActionCallback.DONE;
        }
        MasterDetailsComponent.MyNode node = object == null ? null : BaseStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)object);
        MasterDetailsComponent.MyNode myNode = nodeByName = byName == null ? null : BaseStructureConfigurable.findNodeByName((TreeNode)this.myRoot, (String)byName);
        if (node == null && nodeByName == null) {
            return ActionCallback.DONE;
        }
        NamedConfigurable config = node != null ? node.getConfigurable() : nodeByName.getConfigurable();
        ActionCallback result = new ActionCallback().doWhenDone(() -> {
            this.myAutoScrollEnabled = true;
        });
        this.myAutoScrollEnabled = false;
        this.myAutoScrollHandler.cancelAllRequests();
        MasterDetailsComponent.MyNode nodeToSelect = node != null ? node : nodeByName;
        this.selectNodeInTree((DefaultMutableTreeNode)nodeToSelect, requestFocus).doWhenDone(() -> {
            this.setSelectedNode(nodeToSelect);
            Place.goFurther((Object)config, (Place)place, (boolean)requestFocus).notifyWhenDone(result);
        });
        return result;
    }

    public void queryPlace(@NotNull Place place) {
        if (this.myCurrentConfigurable != null) {
            place.putPath("treeObject", this.myCurrentConfigurable.getEditableObject());
            Place.queryFurther((Object)this.myCurrentConfigurable, (Place)place);
        }
    }

    protected void initTree() {
        if (this.myWasTreeInitialized) {
            return;
        }
        this.myWasTreeInitialized = true;
        super.initTree();
        new TreeSpeedSearch(this.myTree, treePath -> this.getTextForSpeedSearch((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()), true);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new ProjectStructureElementRenderer(this.myContext)));
    }

    @NotNull
    protected String getTextForSpeedSearch(MasterDetailsComponent.MyNode node) {
        return node.getDisplayName();
    }

    public void disposeUIResources() {
        if (this.myUiDisposed) {
            return;
        }
        super.disposeUIResources();
        this.myUiDisposed = true;
        this.myAutoScrollHandler.cancelAllRequests();
        this.myContext.getDaemonAnalyzer().clear();
        Disposer.dispose((Disposable)this);
    }

    public void checkCanApply() throws ConfigurationException {
    }

    protected void addCollapseExpandActions(List<? super AnAction> result) {
        TreeExpander expander = new TreeExpander(){

            public void expandAll() {
                TreeUtil.expandAll((JTree)BaseStructureConfigurable.this.myTree);
            }

            public boolean canExpand() {
                return true;
            }

            public void collapseAll() {
                TreeUtil.collapseAll((JTree)BaseStructureConfigurable.this.myTree, (int)0);
            }

            public boolean canCollapse() {
                return true;
            }
        };
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        result.add((AnAction)actionsManager.createExpandAllAction(expander, (JComponent)this.myTree));
        result.add((AnAction)actionsManager.createCollapseAllAction(expander, (JComponent)this.myTree));
    }

    @Nullable
    public ProjectStructureElement getSelectedElement() {
        MasterDetailsComponent.MyNode node;
        NamedConfigurable configurable;
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null && selectionPath.getLastPathComponent() instanceof MasterDetailsComponent.MyNode && (configurable = (node = (MasterDetailsComponent.MyNode)selectionPath.getLastPathComponent()).getConfigurable()) instanceof ProjectStructureElementConfigurable) {
            return ((ProjectStructureElementConfigurable)configurable).getProjectStructureElement();
        }
        return null;
    }

    public void reset() {
        this.myUiDisposed = false;
        if (!this.myWasTreeInitialized) {
            this.initTree();
            this.myTree.setShowsRootHandles(false);
            this.loadTreeNodes();
        } else {
            this.reloadTreeNodes();
        }
        super.reset();
    }

    private void loadTreeNodes() {
        this.loadTree();
        for (ProjectStructureElement projectStructureElement : this.getProjectStructureElements()) {
            this.myContext.getDaemonAnalyzer().queueUpdate(projectStructureElement);
        }
    }

    protected final void reloadTreeNodes() {
        super.disposeUIResources();
        this.myTree.setShowsRootHandles(false);
        this.loadTreeNodes();
    }

    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        return Collections.emptyList();
    }

    protected abstract void loadTree();

    @NotNull
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        AbstractAddGroup addAction = this.createAddAction();
        if (addAction != null) {
            result.add((AnAction)addAction);
        }
        result.add((AnAction)new MyRemoveAction());
        List<? extends AnAction> copyActions = this.createCopyActions(fromPopup);
        result.addAll(copyActions);
        result.add((AnAction)Separator.getInstance());
        if (fromPopup) {
            result.add(new MyFindUsagesAction((JComponent)this.myTree));
        }
        return result;
    }

    @NotNull
    protected List<? extends AnAction> createCopyActions(boolean fromPopup) {
        return Collections.emptyList();
    }

    public void onStructureUnselected() {
    }

    public void onStructureSelected() {
    }

    @Nullable
    protected abstract AbstractAddGroup createAddAction();

    protected List<? extends RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return Collections.emptyList();
    }

    @NotNull
    private MultiMap<RemoveConfigurableHandler, MasterDetailsComponent.MyNode> groupNodes(List<? extends MasterDetailsComponent.MyNode> nodes) {
        List<? extends RemoveConfigurableHandler<?>> handlers = this.getRemoveHandlers();
        LinkedMultiMap grouped = new LinkedMultiMap();
        for (MasterDetailsComponent.MyNode myNode : nodes) {
            RemoveConfigurableHandler<?> handler;
            NamedConfigurable configurable = myNode.getConfigurable();
            if (configurable == null || (handler = BaseStructureConfigurable.findHandler(handlers, configurable.getClass())) == null) continue;
            grouped.putValue(handler, (Object)myNode);
        }
        return grouped;
    }

    private static RemoveConfigurableHandler<?> findHandler(List<? extends RemoveConfigurableHandler<?>> handlers, Class<? extends NamedConfigurable> configurableClass) {
        for (RemoveConfigurableHandler<?> handler : handlers) {
            if (!handler.getConfigurableClass().isAssignableFrom(configurableClass)) continue;
            return handler;
        }
        return null;
    }

    private static List<?> getEditableObjects(Collection<? extends MasterDetailsComponent.MyNode> value) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (MasterDetailsComponent.MyNode myNode : value) {
            objects.add(myNode.getConfigurable().getEditableObject());
        }
        return objects;
    }

    protected void removeFacetNodes(@NotNull List<? extends Facet> facets) {
        for (Facet facet : facets) {
            MasterDetailsComponent.MyNode node = BaseStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)facet);
            if (node == null) continue;
            this.removePaths(new TreePath[]{TreeUtil.getPathFromRoot((TreeNode)node)});
        }
    }

    protected static abstract class AbstractAddGroup
    extends ActionGroup
    implements MasterDetailsComponent.ActionGroupWithPreselection {
        protected AbstractAddGroup(String text, Icon icon) {
            super(text, true);
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(icon);
            Keymap active = KeymapManager.getInstance().getActiveKeymap();
            if (active != null) {
                Shortcut[] shortcuts = active.getShortcuts("NewElement");
                this.setShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts));
            }
        }

        public AbstractAddGroup(String text) {
            this(text, IconUtil.getAddIcon());
        }

        public ActionGroup getActionGroup() {
            return this;
        }
    }

    protected class MyRemoveAction
    extends MasterDetailsComponent.MyDeleteAction {
        public MyRemoveAction() {
            super((MasterDetailsComponent)BaseStructureConfigurable.this, (Condition)new Condition<Object[]>(){

                public boolean value(Object[] objects) {
                    ArrayList<MasterDetailsComponent.MyNode> nodes = new ArrayList<MasterDetailsComponent.MyNode>();
                    for (Object object : objects) {
                        if (!(object instanceof MasterDetailsComponent.MyNode)) {
                            return false;
                        }
                        nodes.add((MasterDetailsComponent.MyNode)object);
                    }
                    MultiMap map2 = BaseStructureConfigurable.this.groupNodes(nodes);
                    for (Map.Entry entry : map2.entrySet()) {
                        if (((RemoveConfigurableHandler)entry.getKey()).canBeRemoved(BaseStructureConfigurable.getEditableObjects((Collection)entry.getValue()))) continue;
                        return false;
                    }
                    return true;
                }
            });
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            TreePath[] paths = BaseStructureConfigurable.this.myTree.getSelectionPaths();
            if (paths == null) {
                return;
            }
            List<MasterDetailsComponent.MyNode> removedNodes = this.removeFromModel(paths);
            BaseStructureConfigurable.this.removeNodes(removedNodes);
        }

        private List<MasterDetailsComponent.MyNode> removeFromModel(TreePath[] paths) {
            List nodes = ContainerUtil.mapNotNull((Object[])paths, path -> {
                Object node = path.getLastPathComponent();
                return node instanceof MasterDetailsComponent.MyNode ? (MasterDetailsComponent.MyNode)node : null;
            });
            MultiMap grouped = BaseStructureConfigurable.this.groupNodes(nodes);
            ArrayList<MasterDetailsComponent.MyNode> removedNodes = new ArrayList<MasterDetailsComponent.MyNode>();
            for (Map.Entry entry : grouped.entrySet()) {
                boolean removed = ((RemoveConfigurableHandler)entry.getKey()).remove(BaseStructureConfigurable.getEditableObjects((Collection)entry.getValue()));
                if (!removed) continue;
                removedNodes.addAll((Collection)entry.getValue());
            }
            return removedNodes;
        }
    }

    private class MyFindUsagesAction
    extends FindUsagesInProjectStructureActionBase {
        MyFindUsagesAction(JComponent parentComponent) {
            super(parentComponent, BaseStructureConfigurable.this.myProject);
        }

        @Override
        protected boolean isEnabled() {
            TreePath selectionPath = BaseStructureConfigurable.this.myTree.getSelectionPath();
            if (selectionPath != null) {
                MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)selectionPath.getLastPathComponent();
                return !node.isDisplayInBold();
            }
            return false;
        }

        @Override
        protected StructureConfigurableContext getContext() {
            return BaseStructureConfigurable.this.myContext;
        }

        @Override
        protected ProjectStructureElement getSelectedElement() {
            return BaseStructureConfigurable.this.getSelectedElement();
        }

        @Override
        protected RelativePoint getPointToShowResults() {
            int selectedRow = BaseStructureConfigurable.this.myTree.getSelectionRows()[0];
            Rectangle rowBounds = BaseStructureConfigurable.this.myTree.getRowBounds(selectedRow);
            Point location = rowBounds.getLocation();
            location.x += rowBounds.width;
            return new RelativePoint((Component)BaseStructureConfigurable.this.myTree, location);
        }
    }
}

