/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryAttachDialog;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ComparingJarFilesTask;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ConvertToRepositoryLibraryActionBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ConvertToRepositoryLibraryActionBaseKt;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibraryJarsDiffDialog;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b&\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0013H$J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00152\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\f0\u001dH$J\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u00112\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110!H\u0002J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertToRepositoryLibraryActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "context", "Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;", "(Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;)V", "getContext", "()Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "changeCoordinatesAndRetry", "mavenCoordinates", "Lorg/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor;", "library", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "detectOrSpecifyMavenCoordinates", "Lcom/intellij/openapi/roots/libraries/Library;", "downloadLibraryAndReplace", "getSelectedLibrary", "replaceByLibrary", "configuration", "Lcom/intellij/openapi/roots/libraries/NewLibraryConfiguration;", "replaceLibrary", "configureNewLibrary", "Lkotlin/Function1;", "Lcom/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryEditorBase;", "specifyMavenCoordinates", "detectedCoordinates", "", "update", "Companion", "intellij.java.ui"})
public abstract class ConvertToRepositoryLibraryActionBase
extends DumbAwareAction {
    @NotNull
    private final Project project;
    @NotNull
    private final StructureConfigurableContext context;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @Nullable
    protected abstract LibraryEx getSelectedLibrary();

    public void update(@NotNull AnActionEvent e) {
        LibraryEx library = this.getSelectedLibrary();
        e.getPresentation().setEnabledAndVisible(library != null && library.getKind() == null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        LibraryEx libraryEx = this.getSelectedLibrary();
        if (libraryEx == null) {
            return;
        }
        LibraryEx library = libraryEx;
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor = this.detectOrSpecifyMavenCoordinates((Library)library);
        if (jpsMavenRepositoryLibraryDescriptor == null) {
            return;
        }
        JpsMavenRepositoryLibraryDescriptor mavenCoordinates = jpsMavenRepositoryLibraryDescriptor;
        this.downloadLibraryAndReplace(library, mavenCoordinates);
    }

    /*
     * WARNING - void declaration
     */
    private final void downloadLibraryAndReplace(LibraryEx library, JpsMavenRepositoryLibraryDescriptor mavenCoordinates) {
        void $receiver$iv$iv;
        VirtualFile[] $receiver$iv;
        File file;
        Object object;
        OrderRoot it;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        RepositoryLibraryProperties libraryProperties = new RepositoryLibraryProperties(mavenCoordinates.getGroupId(), mavenCoordinates.getArtifactId(), mavenCoordinates.getVersion(), mavenCoordinates.isIncludeTransitiveDependencies(), mavenCoordinates.getExcludedDependencies());
        boolean hasSources = RepositoryUtils.libraryHasSources((Library)library);
        boolean hasJavadoc = RepositoryUtils.libraryHasJavaDocs((Library)library);
        ConvertToRepositoryLibraryActionBaseKt.access$getLOG$p().debug("Resolving " + mavenCoordinates);
        Collection<OrderRoot> roots = JarRepositoryManager.loadDependenciesModal(this.project, libraryProperties, hasSources, hasJavadoc, null, null);
        Iterable iterable = $receiver$iv2 = (Iterable)roots;
        VirtualFile[] destination$iv$iv = (VirtualFile[])new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            it = (OrderRoot)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)OrderRootType.CLASSES)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            it = (OrderRoot)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            file = VfsUtilCore.virtualToIoFile((VirtualFile)it.getFile());
            object.add(file);
        }
        List downloadedFiles = (List)destination$iv$iv;
        if (downloadedFiles.isEmpty()) {
            if (Messages.showYesNoDialog((String)"No files were downloaded. Do you want to try different coordinates?", (String)"Failed to Download Library", null) != 0) {
                return;
            }
            this.changeCoordinatesAndRetry(mavenCoordinates, library);
            return;
        }
        destination$iv$iv = $receiver$iv = library.getFiles(OrderRootType.CLASSES);
        Collection destination$iv$iv2 = new ArrayList($receiver$iv.length);
        void var12_11 = $receiver$iv$iv;
        int n = ((void)var12_11).length;
        for (int i = 0; i < n; ++i) {
            void it2;
            void item$iv$iv;
            void $i$f$map = item$iv$iv = var12_11[i];
            object = destination$iv$iv2;
            boolean bl = false;
            file = VfsUtilCore.virtualToIoFile((VirtualFile)it2);
            object.add(file);
        }
        List libraryFiles = (List)destination$iv$iv2;
        ComparingJarFilesTask task = new ComparingJarFilesTask(this.project, downloadedFiles, libraryFiles);
        task.queue();
        if (task.getCancelled()) {
            return;
        }
        if (!task.getFilesAreTheSame()) {
            LibraryJarsDiffDialog dialog = new LibraryJarsDiffDialog(task.getLibraryFileToCompare(), task.getDownloadedFileToCompare(), mavenCoordinates, LibraryUtil.getPresentableName((Library)((Library)library)), this.project);
            dialog.show();
            task.deleteTemporaryFiles();
            switch (dialog.getExitCode()) {
                case 1: {
                    return;
                }
                case 2: {
                    this.changeCoordinatesAndRetry(mavenCoordinates, library);
                    return;
                }
            }
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(this, library, roots, libraryProperties){
            final /* synthetic */ ConvertToRepositoryLibraryActionBase this$0;
            final /* synthetic */ LibraryEx $library;
            final /* synthetic */ Collection $roots;
            final /* synthetic */ RepositoryLibraryProperties $libraryProperties;

            public final void run() {
                Library library = (Library)this.$library;
                String string = this.$library.getName();
                if (string == null) {
                    string = "";
                }
                ConvertToRepositoryLibraryActionBase.access$replaceByLibrary(this.this$0, library, new NewLibraryConfiguration(this, string, RepositoryLibraryType.getInstance(), (LibraryProperties)this.$libraryProperties){
                    final /* synthetic */ downloadLibraryAndReplace.1 this$0;

                    public void addRoots(@NotNull LibraryEditor editor) {
                        editor.addRoots(this.this$0.$roots);
                    }
                    {
                        this.this$0 = $outer;
                        super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                    }
                });
            }
            {
                this.this$0 = convertToRepositoryLibraryActionBase;
                this.$library = libraryEx;
                this.$roots = collection;
                this.$libraryProperties = repositoryLibraryProperties;
            }
        });
    }

    private final void changeCoordinatesAndRetry(JpsMavenRepositoryLibraryDescriptor mavenCoordinates, LibraryEx library) {
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor = this.specifyMavenCoordinates(CollectionsKt.listOf((Object)mavenCoordinates));
        if (jpsMavenRepositoryLibraryDescriptor == null) {
            return;
        }
        JpsMavenRepositoryLibraryDescriptor coordinates = jpsMavenRepositoryLibraryDescriptor;
        ApplicationManager.getApplication().invokeLater(new Runnable(this, library, coordinates){
            final /* synthetic */ ConvertToRepositoryLibraryActionBase this$0;
            final /* synthetic */ LibraryEx $library;
            final /* synthetic */ JpsMavenRepositoryLibraryDescriptor $coordinates;

            public final void run() {
                ConvertToRepositoryLibraryActionBase.access$downloadLibraryAndReplace(this.this$0, this.$library, this.$coordinates);
            }
            {
                this.this$0 = convertToRepositoryLibraryActionBase;
                this.$library = libraryEx;
                this.$coordinates = jpsMavenRepositoryLibraryDescriptor;
            }
        });
    }

    private final JpsMavenRepositoryLibraryDescriptor detectOrSpecifyMavenCoordinates(Library library) {
        String message;
        List<JpsMavenRepositoryLibraryDescriptor> detectedCoordinates = Companion.detectMavenCoordinates(library.getFiles(OrderRootType.CLASSES));
        ConvertToRepositoryLibraryActionBaseKt.access$getLOG$p().debug("Maven coordinates for " + LibraryUtil.getPresentableName((Library)library) + " JARs: " + detectedCoordinates);
        if (detectedCoordinates.size() == 1) {
            return detectedCoordinates.get(0);
        }
        String string = message = detectedCoordinates.isEmpty() ? "Cannot detect Maven coordinates from the library JARs" : "Multiple Maven coordinates are found in the library JARs";
        if (Messages.showYesNoDialog((Project)this.project, (String)(message + ". Do you want to search Maven repositories manually?"), (String)"Cannot Detect Maven Coordinates", null) != 0) {
            return null;
        }
        return this.specifyMavenCoordinates(detectedCoordinates);
    }

    private final JpsMavenRepositoryLibraryDescriptor specifyMavenCoordinates(List<? extends JpsMavenRepositoryLibraryDescriptor> detectedCoordinates) {
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor = (JpsMavenRepositoryLibraryDescriptor)CollectionsKt.firstOrNull(detectedCoordinates);
        RepositoryAttachDialog dialog = new RepositoryAttachDialog(this.project, jpsMavenRepositoryLibraryDescriptor != null ? jpsMavenRepositoryLibraryDescriptor.getMavenId() : null, RepositoryAttachDialog.Mode.SEARCH);
        if (!dialog.showAndGet()) {
            return null;
        }
        return new JpsMavenRepositoryLibraryDescriptor(dialog.getCoordinateText(), dialog.getIncludeTransitiveDependencies(), CollectionsKt.emptyList());
    }

    private final void replaceByLibrary(Library library, NewLibraryConfiguration configuration) {
        String[] annotationUrls = library.getUrls(AnnotationOrderRootType.getInstance());
        ProjectStructureConfigurable.getInstance(this.project).registerObsoleteLibraryRoots(ArraysKt.asList((Object[])ArraysKt.plus((Object[])library.getFiles(OrderRootType.CLASSES), (Object[])library.getFiles(OrderRootType.SOURCES))));
        this.replaceLibrary(library, (Function1<? super LibraryEditorBase, Unit>)((Function1)new Function1<LibraryEditorBase, Unit>(configuration, annotationUrls){
            final /* synthetic */ NewLibraryConfiguration $configuration;
            final /* synthetic */ String[] $annotationUrls;

            public final void invoke(@NotNull LibraryEditorBase editor) {
                String[] $receiver$iv;
                editor.setProperties(this.$configuration.getProperties());
                editor.removeAllRoots();
                this.$configuration.addRoots((LibraryEditor)editor);
                String[] stringArray = $receiver$iv = this.$annotationUrls;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String element$iv;
                    String it = element$iv = stringArray[i];
                    boolean bl = false;
                    editor.addRoot(it, AnnotationOrderRootType.getInstance());
                }
            }
            {
                this.$configuration = newLibraryConfiguration;
                this.$annotationUrls = stringArray;
                super(1);
            }
        }));
    }

    protected abstract void replaceLibrary(@NotNull Library var1, @NotNull Function1<? super LibraryEditorBase, Unit> var2);

    @NotNull
    protected final StructureConfigurableContext getContext() {
        return this.context;
    }

    public ConvertToRepositoryLibraryActionBase(@NotNull StructureConfigurableContext context) {
        super("Convert to Repository Library...", "Convert a regular library to a repository library which additionally stores its Maven coordinates, so the IDE can automatically download the library JARs if they are missing", null);
        this.context = context;
        this.project = this.context.getProject();
    }

    public static final /* synthetic */ void access$replaceByLibrary(ConvertToRepositoryLibraryActionBase $this, Library library, NewLibraryConfiguration configuration) {
        $this.replaceByLibrary(library, configuration);
    }

    public static final /* synthetic */ void access$downloadLibraryAndReplace(ConvertToRepositoryLibraryActionBase $this, LibraryEx library, JpsMavenRepositoryLibraryDescriptor mavenCoordinates) {
        $this.downloadLibraryAndReplace(library, mavenCoordinates);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertToRepositoryLibraryActionBase$Companion;", "", "()V", "detectMavenCoordinates", "", "Lorg/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor;", "libraryRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/util/List;", "parsePomProperties", "virtualFile", "intellij.java.ui"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<JpsMavenRepositoryLibraryDescriptor> detectMavenCoordinates(@NotNull VirtualFile[] libraryRoots) {
            void $receiver$iv$iv;
            VirtualFile[] $receiver$iv;
            VirtualFile[] virtualFileArray = $receiver$iv = libraryRoots;
            Collection destination$iv$iv = new ArrayList();
            void var5_5 = $receiver$iv$iv;
            int n = ((void)var5_5).length;
            for (int i = 0; i < n; ++i) {
                List list;
                Object element$iv$iv;
                Object $receiver$iv$iv2;
                Collection destination$iv$iv2;
                Object $receiver$iv2;
                void element$iv$iv2;
                void root = element$iv$iv2 = var5_5[i];
                boolean bl = false;
                VirtualFile[] virtualFileArray2 = root.findFileByRelativePath("META-INF/maven");
                if (virtualFileArray2 != null && (virtualFileArray2 = virtualFileArray2.getChildren()) != null) {
                    $receiver$iv2 = virtualFileArray2;
                    VirtualFile[] virtualFileArray3 = $receiver$iv2;
                    destination$iv$iv2 = new ArrayList();
                    Object object = $receiver$iv$iv2;
                    int n2 = ((VirtualFile[])object).length;
                    for (int j = 0; j < n2; ++j) {
                        List list2;
                        Object groupDir = element$iv$iv = object[j];
                        boolean bl2 = false;
                        if (groupDir.getChildren() != null) {
                            void $receiver$iv$iv3;
                            void $receiver$iv$iv$iv;
                            VirtualFile[] $receiver$iv3;
                            VirtualFile[] virtualFileArray4 = $receiver$iv3;
                            Collection destination$iv$iv3 = new ArrayList();
                            void var24_26 = $receiver$iv$iv$iv = $receiver$iv$iv3;
                            int n3 = ((void)var24_26).length;
                            for (int k = 0; k < n3; ++k) {
                                VirtualFile virtualFile;
                                void element$iv$iv$iv;
                                void element$iv$iv3;
                                void artifactDir = element$iv$iv3 = (element$iv$iv$iv = var24_26[k]);
                                boolean bl3 = false;
                                if (artifactDir.findChild("pom.properties") == null) continue;
                                VirtualFile it$iv$iv = virtualFile;
                                destination$iv$iv3.add(it$iv$iv);
                            }
                            list2 = (List)destination$iv$iv3;
                        } else {
                            list2 = CollectionsKt.emptyList();
                        }
                        Iterable list$iv$iv = list2;
                        CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                    }
                    list = (List)destination$iv$iv2;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List pomPropertiesFiles = list;
                $receiver$iv$iv2 = $receiver$iv2 = (Iterable)pomPropertiesFiles;
                destination$iv$iv2 = new ArrayList();
                Object $receiver$iv$iv$iv = $receiver$iv$iv2;
                Iterator iterator2 = $receiver$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor;
                    Object element$iv$iv$iv = iterator2.next();
                    element$iv$iv = element$iv$iv$iv;
                    VirtualFile it = (VirtualFile)element$iv$iv;
                    boolean bl4 = false;
                    if (Companion.parsePomProperties(it) == null) continue;
                    JpsMavenRepositoryLibraryDescriptor it$iv$iv = jpsMavenRepositoryLibraryDescriptor;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final JpsMavenRepositoryLibraryDescriptor parsePomProperties(VirtualFile virtualFile) {
            Properties properties = new Properties();
            try {
                Closeable closeable = virtualFile.getInputStream();
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    properties.load(it);
                    it = Unit.INSTANCE;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                return null;
            }
            String groupId = properties.getProperty("groupId");
            String artifactId = properties.getProperty("artifactId");
            String version = properties.getProperty("version");
            return groupId != null && artifactId != null && version != null ? new JpsMavenRepositoryLibraryDescriptor(groupId, artifactId, version) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

