/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ConfigurationErrorQuickFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.util.SmartList;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureProblemsHolderImpl
implements ProjectStructureProblemsHolder {
    private List<ProjectStructureProblemDescription> myProblemDescriptions;

    @Override
    public void registerProblem(@NotNull String message, @Nullable String description, @NotNull ProjectStructureProblemType problemType, @NotNull PlaceInProjectStructure place, @Nullable ConfigurationErrorQuickFix fix) {
        List<Object> fixes = fix != null ? Collections.singletonList(fix) : Collections.emptyList();
        this.registerProblem(new ProjectStructureProblemDescription(message, description, place, problemType, fixes));
    }

    @Override
    public void registerProblem(@NotNull ProjectStructureProblemDescription description) {
        if (this.myProblemDescriptions == null) {
            this.myProblemDescriptions = new SmartList();
        }
        this.myProblemDescriptions.add(description);
    }

    public String composeTooltipMessage() {
        StringBuilder buf = new StringBuilder();
        buf.append("<html><body>");
        if (this.myProblemDescriptions != null) {
            int problems = 0;
            for (ProjectStructureProblemDescription problemDescription : this.myProblemDescriptions) {
                buf.append(XmlStringUtil.convertToHtmlContent((String)problemDescription.getMessage(false))).append("<br>");
                if (++problems < 10 || this.myProblemDescriptions.size() <= 12) continue;
                buf.append(this.myProblemDescriptions.size() - problems).append(" more problems...<br>");
                break;
            }
        }
        buf.append("</body></html>");
        return buf.toString();
    }

    public boolean containsProblems() {
        return this.myProblemDescriptions != null && !this.myProblemDescriptions.isEmpty();
    }

    public boolean containsProblems(ProjectStructureProblemType.Severity severity) {
        if (this.myProblemDescriptions != null) {
            for (ProjectStructureProblemDescription description : this.myProblemDescriptions) {
                if (description.getSeverity() != severity) continue;
                return true;
            }
        }
        return false;
    }

    public void removeProblem(@NotNull ProjectStructureProblemDescription description) {
        if (this.myProblemDescriptions != null) {
            this.myProblemDescriptions.remove(description);
        }
    }

    @Nullable
    public List<ProjectStructureProblemDescription> getProblemDescriptions() {
        return this.myProblemDescriptions;
    }
}

